package com.efuture.ocp.common.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class FtBoundSql extends BoundSql
{
    public FtBoundSql(Configuration configuration, String sql, List<ParameterMapping> parameterMappings, Object parameterObject)
    {
        super(configuration, sql, parameterMappings, parameterObject);
    }
    
    
    //private String sql;
    //private List<ParameterMapping> parameterMappings;
    //private Object parameterObject;
    private Map<String, Object> additionalParameters;
    private MetaObject metaParameters;
    private BoundSql oldboundsql;
   
    public void setoldboundsql(BoundSql oldboundsql){
        MetaObject metaObject = SystemMetaObject.forObject(oldboundsql);
        this.additionalParameters =(Map<String, Object>)metaObject.getValue("additionalParameters");
        this.metaParameters =(MetaObject)metaObject.getValue("metaParameters");
        this.oldboundsql = oldboundsql;
    }
    @Override
    public boolean hasAdditionalParameter(String name)
    {
        return metaParameters.hasGetter(name);
    }
    @Override
    public void setAdditionalParameter(String name, Object value)
    {
        metaParameters.setValue(name, value);
    }
    @Override
    public Object getAdditionalParameter(String name)
    {
        return metaParameters.getValue(name);
    }

}
