package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.proxy.EnterpriseConfigBean;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import javax.ws.rs.core.MultivaluedMap;

@Lazy(true)
@Component("RestClientUtils_MyShop")
public class RestClientUtils_MyShop extends RestClientUtils
{

    //	public RestClientUtils_MyShop() {
    //		super();
    //	}

    //	public RestClientUtils_MyShop(Integer poolSize, boolean entPool, int entMaxPool, long maxWait, String config) {
    //		super(poolSize, entPool, entMaxPool, maxWait, config);
    //	}

    //	public RestClientUtils_MyShop(int poolSize, long maxWait, String config) {
    //		super(poolSize, maxWait, config);
    //	}

    //	public RestClientUtils_MyShop(String config) {
    //		super(config);
    //	}

    private String getData(JSONObject json, String key, String defval)
    {
        if (json.containsKey(key)) {
            return json.getString(key);
        }
        else {
            return defval;
        }
    }

    @Override
    public ServiceResponse sendRequest(ServiceSession session, String baseUrl, EnterpriseConfigBean ent, JSONObject param, String dataNode) throws Exception
    {
        String urlstr = getUrl(session, baseUrl, ent.getSrvConfig("authUrl", true), ent.getSrvConfig("authKey", true));
        String result = PostDataLog(session, urlstr, ent.getSrvConfig("authKey", true), param, "UTF-8");
        ServiceLogs.debuglog("", "myshop.client.url:".concat(urlstr), 0);
        ServiceLogs.debuglog("", "myshop.client.authKey:".concat(ent.getSrvConfig("authKey", true)), 0);
        ServiceLogs.debuglog("", "myshop.client.param:".concat(param.toJSONString()), 0);
        //		logger.info("myshop.client.url: " + urlstr);
        //		logger.info("myshop.client.authKey: " + ent.getSrvConfig("authKey", true));
        //		logger.info("myshop.client.param: " + param.toJSONString());
        JSONObject ret = JSONObject.parseObject(result);
        ServiceLogs.debuglog("", "myshop.client.result:".concat(ret.toJSONString()), 0);
        String retcode = this.getData(ret, "code", "0");

        if (!"0".equals(retcode)) {
            return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, getData(ret, "msg", "N/A"));
        }

        retcode = getData(ret, "returncode", "0");

        if (!"0".equals(retcode)) {
            return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, getData(ret, "data", "N/A"));
        }

        if (!StringUtils.isEmpty(dataNode) && ret.containsKey(dataNode)) {
            return ServiceResponse.buildSuccess(ret.get(dataNode));
        }

        return ServiceResponse.buildSuccess(ret);
    }

    //	@Override
    //	public ServiceResponse sendRequest(ServiceSession session, String baseUrl, EnterpriseConfigBean ent, JSONObject param, String dataNode) throws Exception {
    //		String urlstr = getUrl(session, baseUrl, ent.getSrvConfig("authUrl", true), ent.getSrvConfig("authKey", true));
    //		String result = PostDataLog(urlstr, ent.getSrvConfig("authKey", true), param.toJSONString(), "UTF-8");
    //		logger.info("myshop.client.url: " + urlstr);
    //		logger.info("myshop.client.authKey: " + ent.getSrvConfig("authKey", true));
    //		logger.info("myshop.client.param: " + param.toJSONString());
    //		JSONObject ret = JSONObject.parseObject(result);
    //		String retcode = this.getData(ret, "code", "0");
    //		if (!"0".equals(retcode))
    //			return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, getData(ret, "msg", "N/A"));
    //		retcode = getData(ret, "returncode", "0");
    //		if (!"0".equals(retcode))
    //			return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, getData(ret, "data", "N/A"));
    //
    //		if (!StringUtils.isEmpty(dataNode) && ret.containsKey(dataNode)) {
    //			return ServiceResponse.buildSuccess(ret.get(dataNode));
    //		}
    //
    //		return ServiceResponse.buildSuccess(ret);
    //	}

    public String getTokenStr(ServiceSession session, String authUrl, String authKey) throws Exception
    {
        ServiceLogs.debuglog("go getTokenStr", "entid:" + session.getEnt_id() + ",authUrl:" + authUrl + ",authKey: authKey", 0);
        String memKey = "MyShop:token:" + session.getEnt_id();
        String accessToken = null; // (String) CacheUtils.getCacheUtils().getData(memKey);
        JSONObject remote_token = new JSONObject();

        if (StringUtils.isEmpty(accessToken)) {
            JSONObject param = new JSONObject();
            param.put("authorization", authKey);
            Object result = RestClientUtils.getRestUtils().sendRequest(session, authUrl, param,
                    new RestClientUtils_MyShop.defaultRequestCallback(), "notrace");

            if (result != null) {
                remote_token = JSON.parseObject((String) result);
                ServiceLogs.debuglog("getTokenStr", remote_token.toJSONString(), 0);
            }

            //			remote_token = JSONObject.parseObject(getRemoteToken(authUrl, authKey));
            if (remote_token.containsKey("access_token")) {
                accessToken = remote_token.getString("access_token");
                int expires_in = remote_token.getIntValue("expires_in");
                CacheUtils.getCacheUtils().putData(memKey, accessToken, expires_in - 10);
            }
            else {
                throw new ServiceException(ResponseCode.FAILURE, "获取代理TOKEN错误,请联系系统管理员！");
            }
        }

        return "&access_token=".concat(accessToken);
    }

    //	public String getTokenStr(long ent_id, String baseUrl, String authUrl, String authKey) throws Exception {
    //		String memKey = "MyShop" + String.valueOf(ent_id);
    //		String accessToken = null; //(String) CacheUtils.getCacheUtils().getData(memKey);
    //		JSONObject remote_token = new JSONObject();
    //		if (StringUtils.isEmpty(accessToken)) {
    //			remote_token = JSONObject.parseObject(getRemoteToken(authUrl, authKey));
    //			if (remote_token.containsKey("access_token")) {
    //				accessToken = remote_token.getString("access_token");
    //				int expires_in = remote_token.getIntValue("expires_in");
    //				CacheUtils.getCacheUtils().putData(memKey, accessToken, expires_in - 10);
    //			} else {
    //				throw new ServiceException(ResponseCode.FAILURE, "获取代理TOKEN错误,请联系系统管理员！");
    //			}
    //		}
    //		return "&access_token=".concat(accessToken);
    //	}

    public String getUrl(ServiceSession session, String baseUrl, String authUrl, String authKey) throws Exception
    {
        if (!StringUtils.isEmpty(authUrl)) {
            String tokenStr = getTokenStr(session, authUrl, authKey);
            return baseUrl.concat(tokenStr);
        }
        else {
            return baseUrl;
        }
    }

    protected String PostDataLog(ServiceSession session, String urlStr, String authKey, JSONObject jsonparam, String encoding) throws Exception
    {
        //	    long logkey = UniqueID.getUniqueID();
        //	    this.logger.info(String.format("[%d] REQUEST: %s, %s", logkey, urlStr, jsonparam.toJSONString()));
        String result = PostData(session, urlStr, authKey, jsonparam, encoding);
        //	    this.logger.info(String.format("[%d] RESPONSE: %s", logkey, result));
        return result;
    }

    protected String PostData(ServiceSession session, String urlStr, String authKey, JSONObject jsonparam, String encoding) throws Exception
    {
        jsonparam.put("authorization", authKey);
        Object result = RestClientUtils.getRestUtils().sendRequest(session, urlStr, jsonparam,
                new RestClientUtils_MyShop.defaultRequestCallback(), "notrace");

        if (result != null) {
            JSONObject json = JSON.parseObject((String) result);
            return json.toJSONString();
        }

        throw new ServiceException(ResponseCode.FAILURE, "请求无响应");
    }

    //	protected String PostData(String urlStr, String authKey, String content, String encoding) throws IOException {
    //		URL url = null;
    //		HttpURLConnection connection = null;
    //		try {
    //			url = new URL(urlStr);
    //			connection = (HttpURLConnection) url.openConnection();
    //			connection.setConnectTimeout(10000);
    //			connection.setReadTimeout(10000);
    //			connection.setDoOutput(true);
    //			connection.setDoInput(true);
    //			connection.setRequestMethod("POST");
    //			connection.setUseCaches(false);
    //			connection.setRequestProperty("Content-Type", "application/json");
    //			connection.setRequestProperty("Accept", "application/json");
    //			connection.setRequestProperty("Authorization", authKey);
    //			connection.connect();
    //
    //			DataOutputStream out = new DataOutputStream(connection.getOutputStream());
    //			out.write(content.getBytes(encoding));
    //			out.flush();
    //			out.close();
    //
    //			BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
    //			StringBuffer buffer = new StringBuffer();
    //			String line = "";
    //			while ((line = reader.readLine()) != null) {
    //				buffer.append(line);
    //			}
    //			reader.close();
    //			return buffer.toString();
    //		} catch (IOException e) {
    //			throw e;
    //		} finally {
    //			if (connection != null) {
    //				connection.disconnect();
    //			}
    //		}
    //	}

    //	protected String getRemoteToken(String authUrl, String authKey) throws IOException {
    //		URL url = null;
    //		HttpURLConnection connection = null;
    //		try {
    //			url = new URL(authUrl);
    //			connection = (HttpURLConnection) url.openConnection();
    //			connection.setConnectTimeout(10000);
    //			connection.setReadTimeout(10000);
    //			connection.setDoOutput(true);
    //			connection.setDoInput(true);
    //			connection.setRequestMethod("POST");
    //			connection.setUseCaches(false);
    //			connection.setRequestProperty("Accept", "application/json");
    //			connection.setRequestProperty("Authorization", authKey);
    //			connection.connect();
    //
    //			DataOutputStream out = new DataOutputStream(connection.getOutputStream());
    //			out.flush();
    //			out.close();
    //
    //			BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
    //			StringBuffer buffer = new StringBuffer();
    //			String line = "";
    //			while ((line = reader.readLine()) != null) {
    //				buffer.append(line);
    //			}
    //			reader.close();
    //			return buffer.toString();
    //		} catch (IOException e) {
    //			throw e;
    //		} finally {
    //			if (connection != null) {
    //				connection.disconnect();
    //			}
    //		}
    //	}

    public class defaultRequestCallback implements requestCallback
    {
        @Override
        public Object onSend(String url, Client client, Object param) throws Exception
        {
            WebResource webResource = client.resource(url);
            MultivaluedMap<String, String> queryParams = new MultivaluedMapImpl();
            Object resp;
            JSONObject jsonparam = new JSONObject();
            String authorization = null;

            if (param instanceof JSONObject) {
                if (((JSONObject) param).containsKey("authorization")) {
                    authorization = ((JSONObject) param).getString("authorization");
                    jsonparam = (JSONObject) param;
                    jsonparam.remove("authorization");
                }
            }

            resp = webResource.queryParams(queryParams)
                    .header("Content-Type", "application/json")
                    .header("Accept", "application/json")
                    .header("Authorization", authorization)
                    .post(String.class, jsonparam);
            return resp;
        }
    }
}
