package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.RestClientUtils;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
@Lazy(true)
@Component("RestClientUtils_OCM")
public class RestClientUtils_OCM extends RestClientUtils
{
    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception
    {
        Object result = RestClientUtils.getRestUtils().sendRequest(session, method, param,
                        new RestClientUtils.defaultRequestCallback(), traceprex);
        ServiceResponse response = null;

        if (result != null) {
            JSONObject json = JSON.parseObject((String) result);
            response = JSON.toJavaObject(json, ServiceResponse.class);
        }

        if (response == null) {
            throw new ServiceException(ResponseCode.EXCEPTION, (String) result);
        }

        return response;
    }
}
