package com.efuture.ocp.common.slice.filter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.filter.FtSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Invocation;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class CollectionDeleteWrapper extends CollectionSelectWrapper
{
    protected void onDeleteStatement(Logger logger, JSONObject logJson, Invocation invocation, MappedStatement mappedStatement, BoundSql boundSql, SQLStatement stmt, String partionKey, String sliceKey)
            throws Throwable
    {
        SQLDeleteStatement deleteStmt = (SQLDeleteStatement)stmt;

        String collectionName = deleteStmt.getTableName().getSimpleName();

        SQLExpr newWhereExpr = new SQLBinaryOpExpr();
        String authWhereSql = getPartionWhere(collectionName, null, partionKey, sliceKey);

        if (!StringUtils.isEmpty(authWhereSql)) {
            SQLExpr authWhereExpr = getWhereInfo(authWhereSql);
            if ((deleteStmt.getWhere() != null) && ((deleteStmt.getWhere() instanceof SQLBinaryOpExpr)))
            {
                SQLBinaryOpExpr whereExpr = (SQLBinaryOpExpr)deleteStmt.getWhere();
                if (whereExpr != null)
                {
                    ((SQLBinaryOpExpr)newWhereExpr).setOperator( SQLBinaryOperator.BooleanAnd);
                    ((SQLBinaryOpExpr)newWhereExpr).setLeft(whereExpr);
                    ((SQLBinaryOpExpr)newWhereExpr).setRight(authWhereExpr);
                }
            }
            else
            {
                newWhereExpr = authWhereExpr;
            }
            deleteStmt.setWhere(newWhereExpr);
        }

        StringBuffer newSql = new StringBuffer();
        SQLASTOutputVisitor visitor = null;
        if (getDbType().equals("mysql"))
        {
            visitor = new MySqlOutputVisitor(newSql);
        }
        else if (getDbType().equals("oracle"))
        {
            visitor = new OracleOutputVisitor(newSql);
        }
        else
        {
            throw new Exception("未识别的dbType");
        }
        visitor.visit(deleteStmt);
        visitor.println();
        visitor.endVisit(deleteStmt);

        SqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
        MappedStatement newMs = copyFromMappedStatement(mappedStatement, sqlSource);

        invocation.getArgs()[0] = newMs;

        logJson.put("newSql", newSql.toString());
        logger.debug(String.format("newSQL --->%1$s", new Object[] { newSql.toString() }));
    }
}
