/**
 * Copyright (C), 2007-2015, eFuture 北京富基融通科技有限公司
 * FileName:	QuartConcurrent.java
 * Author:		亮
 * Date:		2015-11-3 上午11:37:22
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.util;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;

import com.efuture.ocp.common.cache.CacheUtils;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.scheduling.quartz.JobMethodInvocationFailedException;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/**
 * @author		亮
 * @description	
 * 
 */
public class ConcurrentQuartz extends MethodInvokingJobDetailFactoryBean
{
    private static Method setResultMethod;
    CacheUtils cacheUtils;
    String quartzId;
    
    @SuppressWarnings({"rawtypes", "unchecked"})
    public ConcurrentQuartz()
    {
        //setConcurrent(false);
        
        try
        {
            Class jobExecutionContextClass = QuartzJobBean.class.getClassLoader().loadClass("org.quartz.JobExecutionContext");
            setResultMethod = jobExecutionContextClass.getMethod("setResult", new Class[]
            {
                Object.class
            });
        }
        catch (Exception ex)
        {
            throw new IllegalStateException("Incompatible Quartz API: " + ex);
        }
    }
    
    /**
     * @return cacheUtils
     */
    public CacheUtils getCacheUtils()
    {
        if (cacheUtils == null) cacheUtils = CacheUtils.getCacheUtils();        
        return cacheUtils;
    }

    /**
     * @param cacheUtils 要设置的 cacheUtils
     */
    public void setCacheUtils(CacheUtils cacheUtils)
    {
        this.cacheUtils = cacheUtils;
    }

    /**
     * @return quartzId
     */
    public String getQuartzId()
    {
        return quartzId;
    }

    /**
     * @param quartzId 要设置的 quartzId
     */
    public void setQuartzId(String quartzId)
    {
        this.quartzId = quartzId;
    }

//    @Override  
//    public void afterPropertiesSet() throws ClassNotFoundException, NoSuchMethodException
//    {
//        super.afterPropertiesSet();
//        
//        // 注册新的执行方法,控制定时器并发
//        ((JobDetail)super.getObject()).setJobClass(ConcurrentMethodInvokingJob.class);
//    }
    
    @Override 
    protected void postProcessJobDetail(JobDetail jobDetail) {
      BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(jobDetail);

		bw.setPropertyValue("jobClass", ConcurrentMethodInvokingJob.class);
	}
    
    
    public static class ConcurrentMethodInvokingJob extends QuartzJobBean
    {
        protected static final Logger logger = LoggerFactory.getLogger(ConcurrentMethodInvokingJob.class);
        private MethodInvoker methodInvoker;

        public void setMethodInvoker(MethodInvoker methodInvoker)
        {
            this.methodInvoker = methodInvoker;
        }

        protected void executeInternal(JobExecutionContext context) throws JobExecutionException
        {
            ConcurrentQuartz quartz = (ConcurrentQuartz)context.getJobDetail().getJobDataMap().get("methodInvoker");
            String quartzid = quartz.getQuartzId();
            long quarttime = 0;    
            String quartkey = null;
            boolean start = false;
            
            try
            {
                // 检查是否有定时器在执行
                if (!StringUtils.isEmpty(quartzid))
                {
                    // 随机延时,打乱集群定时器的时间
                    int random = (Math.abs(new Random().nextInt())%1000);
                    Thread.sleep(random);
                    quarttime = System.currentTimeMillis();
                    quartkey = ManagementFactory.getRuntimeMXBean().getName() + "-" + quarttime + "-" + random;
                    
                    // 从缓存读取定时器标识,避免多个定时器同时执行                    
                    Object obj = quartz.getCacheUtils().getData(quartzid);
                    if (!StringUtils.isEmpty(obj)) return;
                    quartz.getCacheUtils().putData(quartzid,quartkey,CacheUtils.CacheTimeOut.Hour);
                    
                    // 延时5s,重新读取缓存标志,确保没有改变定时器标识
                    Thread.sleep(5000);
                    obj = quartz.getCacheUtils().getData(quartzid);
                    if (!quartkey.equals(obj))
                    {
                        if (logger.isInfoEnabled()) logger.info("Quartz end  : " + quartkey + " concurrent: " + obj);
                        return;
                    }
                    
                    // 执行
                    start = true;
                    if (logger.isInfoEnabled()) logger.info("Quartz start: " + quartkey);
                }
                
                // 执行定时任务
                ReflectionUtils.invokeMethod(ConcurrentQuartz.setResultMethod, context, new Object[]
                {
                    this.methodInvoker.invoke()
                });
            }
            catch (InvocationTargetException ex)
            {
                if (ex.getTargetException() instanceof JobExecutionException) { throw ((JobExecutionException) ex.getTargetException()); }

                throw new JobMethodInvocationFailedException(this.methodInvoker, ex.getTargetException());
            }
            catch (Exception ex)
            {
                throw new JobMethodInvocationFailedException(this.methodInvoker, ex);
            }
            finally
            {                
                if (start)
                {
                    quartz.getCacheUtils().deleteData(quartzid);                    
                    if (logger.isInfoEnabled()) logger.info("Quartz end  : " + quartkey + " elapsed: " + (System.currentTimeMillis() - quarttime) + " ms");
                }
            }
        }
    }    
}
