package com.efuture.ocp.common.util;

import org.springframework.core.env.Environment;

public class EnvironmentParaUtils {

	public static Environment getEnvironment() {
		return SpringBeanFactory.getContext().getBean(Environment.class);
	}

	public static String getEnvPra(String key, String defaultValue) {
		return getEnvPra(0, key, defaultValue);

	}

	public static String getEnvPra(long entId, String key, String defaultValue) {
		Environment env = getEnvironment();
		if (env == null) {
			return defaultValue;
		} else {

			String value = get(env, entId, key);
			if (value == null || value.isEmpty()) {
				return defaultValue;
			} else {
				return value;
			}
		}

	}

	private static String get(Environment env, long entId, String key) {
		String entKey = key;
		if (entId != 0) {
			entKey = entKey + "-" + entId;
		}
		String value = env.getProperty(entKey);
		if (value == null || value.isEmpty()) {
			return env.getProperty(key);
		} else {
			return value;
		}

	}
}
