/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	ValidatorUtil.java
 * Author:		yvon
 * Date:		2014年4月8日 下午10:36:52
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.util;

import java.util.Set;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

/**
 * @author		yvon
 * @description	bean验证工具类
 * 
 */
public class ValidatorUtils 
{
	// Validator的实例是线程安全的
	private static Validator validator;
	
	static 
	{
	    try
	    {
    		ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    		validator = factory.getValidator();
	    }
	    catch(Exception ex)
	    {
	        ex.printStackTrace(); 
	    }
	}
	
	public static Set<ConstraintViolation<Object>> validate(Object object, Class<?>... groups){
		return validator.validate(object, groups);
	}
	
	public static Validator getValidator(){	    
		return validator;
	}
}
