/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.annotation;

import com.efuture.ocp.common.annotation.RateLimit;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.RateLimiter;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class RateLimitAspect {
    private Map<String, RateLimiter> limitMap = Maps.newConcurrentMap();

    @Pointcut(value="@annotation(RateLimit)")
    public void rateLimit() {
    }

    private String getLimitKey(ProceedingJoinPoint joinPoint) {
        if (ServiceRestReflect.getLocale() == null || ServiceRestReflect.getLocale().get() == null) {
            return null;
        }
        String className = joinPoint.getTarget().getClass().getSimpleName();
        String methodName = joinPoint.getSignature().getName();
        return String.valueOf(ServiceRestReflect.getLocale().get().getEnt_id()).concat("-").concat(className).concat(".").concat(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="rateLimit()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        String limitKey = this.getLimitKey(joinPoint);
        RateLimit rateLimiter = this.getRateLimit((JoinPoint)joinPoint);
        if (limitKey != null && rateLimiter != null) {
            boolean acquire;
            RateLimiter limiter = null;
            if (!this.limitMap.containsKey(limitKey)) {
                RateLimitAspect rateLimitAspect = this;
                synchronized (rateLimitAspect) {
                    if (!this.limitMap.containsKey(limitKey)) {
                        limiter = RateLimiter.create((double)rateLimiter.permitsPerSecond());
                        this.limitMap.put(limitKey, limiter);
                    }
                }
            }
            if (!(acquire = (limiter = this.limitMap.get(limitKey)).tryAcquire(rateLimiter.timeout(), rateLimiter.timeunit()))) {
                throw new ServiceException("30000", rateLimiter.msg(), new Object[0]);
            }
        }
        return joinPoint.proceed();
    }

    private RateLimit getRateLimit(JoinPoint joinPoint) {
        Method[] methods = joinPoint.getTarget().getClass().getDeclaredMethods();
        String name = joinPoint.getSignature().getName();
        if (!StringUtils.isEmpty((Object)name)) {
            for (Method method : methods) {
                RateLimit annotation = method.getAnnotation(RateLimit.class);
                if (Objects.isNull(annotation) || !name.equals(method.getName())) continue;
                return annotation;
            }
        }
        return null;
    }
}

