/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.dict;

import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.dict.MdmService;
import com.efuture.ocp.common.util.EnvironmentParaUtils;
import com.efuture.omd.storage.FMybatisTemplate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="mdmdbservice")
public class MdmServiceDBImpl
extends BasicComponent
implements MdmService {
    @Value(value="${efuture.report.mdmdb:ocmmdm}")
    String mdmdb = "ocmmdm";
    @Value(value="${efuture.report.MdmStorageOperation:}")
    String MdmStorageOperation = "";
    @Value(value="${efuture.report.mdmkeys:}")
    String mdmkeys = "mf,cat,pp,sup";
    private HashMap<String, String> tableInfo = new HashMap();
    private HashMap<String, String> tableDefConfig = new HashMap();
    boolean ibinit = false;

    public MdmServiceDBImpl() {
        this.tableDefConfig.put("mf", "v_manaframe,jygs,code,name,parent_id,4");
        this.tableDefConfig.put("category", "v_category,jygs,code,name,parent_id,4");
        this.tableDefConfig.put("pp", "v_brand,jygs,code,name");
        this.tableDefConfig.put("sup", "v_vendor,jygs,code,name");
    }

    public void init() {
        if (!this.ibinit) {
            if (this.MdmStorageOperation != null && !this.MdmStorageOperation.isEmpty()) {
                this.setStorageOperation_other(this.MdmStorageOperation);
            }
            String[] mdmkeyArray = this.mdmkeys.split(",");
            for (int i = 0; i < mdmkeyArray.length; ++i) {
                String mdmkey = mdmkeyArray[i];
                String configkey = "efuture.report.mdm." + mdmkey;
                this.tableInfo.put(mdmkey, EnvironmentParaUtils.getEnvPra(configkey, this.tableDefConfig.get(mdmkey)));
            }
            this.ibinit = true;
        }
    }

    public String getTableInfo(String dicttype) {
        return this.tableInfo.get(dicttype);
    }

    public String getFromDb(long ent_id, String dicttype, String jygs, String dictcode) {
        String tableinfo = this.getTableInfo(dicttype);
        if (tableinfo == null || tableinfo.equals("")) {
            return dictcode;
        }
        String[] t = tableinfo.split(",");
        if (t.length < 4) {
            return dictcode;
        }
        String tablename = t[0];
        String jygscol = t[1];
        String codecol = t[2];
        String namecol = t[3];
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id);
        if (jygscol != null && !jygscol.equals("")) {
            criteria.and(jygscol).is((Object)jygs);
        }
        criteria.and(codecol).is((Object)dictcode);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include(namecol);
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations();
        List dname = storage.select(query, tablename);
        if (dname != null && dname.size() >= 1) {
            return ((Map)dname.get(0)).get(namecol).toString();
        }
        return dictcode;
    }

    @Override
    public Map<String, Object> getMdmRowData(long ent_id, String dicttype, String jygs, String dictcode) {
        this.init();
        String tableinfo = this.getTableInfo(dicttype);
        if (tableinfo == null || tableinfo.equals("")) {
            return null;
        }
        String[] t = tableinfo.split(",");
        String tablename = t[0];
        String jygscol = t[1];
        String codecol = t[2];
        String namecol = t[3];
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id);
        if (jygscol != null && !jygscol.equals("") && jygs != null && !jygs.equals("")) {
            criteria.and(jygscol).is((Object)jygs);
        }
        criteria.and(codecol).is((Object)dictcode);
        Query query = new Query((CriteriaDefinition)criteria);
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations();
        List dname = storage.select(query, tablename);
        if (dname != null && dname.size() >= 1) {
            return (Map)dname.get(0);
        }
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        rtn.put(namecol, dictcode);
        return rtn;
    }

    @Override
    public boolean hasType(String dicttype) {
        this.init();
        return this.tableInfo.containsKey(dicttype);
    }

    @Override
    public String getMdmName(Map<String, Object> dict, String dicttype) {
        this.init();
        String tableinfo = this.getTableInfo(dicttype);
        String[] t = tableinfo.split(",");
        String namecol = t[3];
        if (dict.get(namecol) != null) {
            return dict.get(namecol).toString();
        }
        return null;
    }

    @Override
    public String getMdmNameCol(String dicttype) {
        this.init();
        String tableinfo = this.getTableInfo(dicttype);
        if (tableinfo == null || tableinfo.equals("")) {
            return null;
        }
        String[] t = tableinfo.split(",");
        String namecol = t[3];
        return namecol;
    }

    @Override
    public String getMdmPcodeCol(String dicttype) {
        this.init();
        String tableinfo = this.getTableInfo(dicttype);
        if (tableinfo == null || tableinfo.equals("")) {
            return null;
        }
        String[] t = tableinfo.split(",");
        String pcodecol = t[4];
        return pcodecol;
    }

    @Override
    public int getMaxLevel(String dicttype) {
        this.init();
        String tableinfo = this.getTableInfo(dicttype);
        if (tableinfo == null || tableinfo.isEmpty()) {
            return 1;
        }
        String[] t = tableinfo.split(",");
        if (t.length < 6) {
            return 1;
        }
        String max = t[5];
        if (NumberUtils.isNumber((String)max)) {
            return NumberUtils.toInt((String)max);
        }
        return 1;
    }
}

