/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.distributedLock;

import com.efuture.ocp.common.distributedLock.AbstractDistributedLockHandle;
import com.efuture.ocp.common.util.CacheUtils;
import org.springframework.stereotype.Component;

@Component(value="fLockHandleByCacheUtils")
public class LockHandleByCacheUtils
extends AbstractDistributedLockHandle {
    @Override
    public boolean tryLock(String key, int lockExpire, int waitMillSeconds) {
        long id = System.currentTimeMillis();
        boolean ok = this.doNaiveCachePut(key, id, lockExpire, waitMillSeconds);
        if (!ok) {
            return false;
        }
        return ok;
    }

    @Override
    public boolean doNaiveCachePut(String key, long id, int lockExpire, int waitMillSeconds) {
        return CacheUtils.getCacheUtils().AddData(key, id, lockExpire);
    }

    @Override
    public boolean doNaiveCacheDelete(String key) {
        return CacheUtils.getCacheUtils().deleteData(key);
    }

    @Override
    public long doNaiveCacheGet(String key) {
        Object val = CacheUtils.getCacheUtils().getData(key);
        if (val == null) {
            return 0L;
        }
        return Long.valueOf(val.toString());
    }

    @Override
    public boolean unlock(String key, int lockExpire) {
        return this.doNaiveCacheDelete(key);
    }

    @Override
    public boolean unlock(String key) {
        return this.unlock(key, 60);
    }
}

