/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.rest.taobao;

import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.rest.taobao.CheckResult;
import com.efuture.ocp.common.util.MD5Utils;
import com.efuture.ocp.common.util.Utils;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class SpiUtils {
    public static CheckResult checkSign(HttpServletRequest request, String secret, String body, String datafmt) throws IOException {
        CheckResult result = new CheckResult();
        String sm = request.getParameter("sign_method");
        if (!StringUtils.isEmpty((Object)sm) && sm.equals("DEMO")) {
            result.setSuccess(true);
            return result;
        }
        String ctype = request.getContentType();
        String charset = Utils.getResponseCharset(ctype);
        if (ctype.startsWith("application/json") || ctype.startsWith("text/xml") || ctype.startsWith("text/plain")) {
            boolean valid;
            if (datafmt.equalsIgnoreCase("FORM")) {
                Map<String, String> form = Utils.UrlToMap(body);
                valid = SpiUtils.checkSignInternal(request, form, null, secret, charset);
            } else {
                valid = SpiUtils.checkSignInternal(request, null, body, secret, charset);
            }
            result.setSuccess(valid);
            result.setRequestBody(body);
        } else if (ctype.startsWith("application/x-www-form-urlencoded")) {
            boolean valid;
            if (datafmt.equalsIgnoreCase("FORM")) {
                Map<String, String> form = Utils.UrlToMap(body);
                valid = SpiUtils.checkSignInternal(request, form, null, secret, charset);
            } else {
                valid = SpiUtils.checkSignInternal(request, null, null, secret, charset);
            }
            result.setSuccess(valid);
        } else {
            throw new RuntimeException("Unspported SPI request");
        }
        return result;
    }

    private static boolean checkSignInternal(HttpServletRequest request, Map<String, String> form, String body, String secret, String charset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        Map<String, String> headerMap = SpiUtils.getHeaderMap(request, charset);
        params.putAll(headerMap);
        Map<String, String> queryMap = SpiUtils.getQueryMap(request, charset);
        params.putAll(queryMap);
        if (form == null && body == null) {
            Map<String, String> formMap = SpiUtils.getFormMap(request, queryMap);
            params.putAll(formMap);
        } else if (form != null) {
            params.putAll(form);
        }
        String remoteSign = queryMap.get("sign");
        String localSign = SpiUtils.sign(params, body, secret, charset);
        if (localSign.equals(remoteSign)) {
            return true;
        }
        String paramStr = SpiUtils.getParamStrFromMap(params);
        ServiceVersion.getInstance().debugLog("checkTopSign error^_^remoteSign=" + remoteSign + "^_^localSign=" + localSign + "^_^paramStr=" + paramStr + "^_^body=" + body);
        return false;
    }

    public static Map<String, String> getHeaderMap(HttpServletRequest request, String charset) throws IOException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        String signList = request.getHeader("top-sign-list");
        if (!StringUtils.isEmpty((Object)signList)) {
            String[] keys;
            for (String key : keys = signList.split(",")) {
                String value = request.getHeader(key);
                if (StringUtils.isEmpty((Object)value)) {
                    headerMap.put(key, "");
                    continue;
                }
                headerMap.put(key, URLDecoder.decode(value, charset));
            }
        }
        return headerMap;
    }

    public static Map<String, String> getQueryMap(HttpServletRequest request, String charset) throws IOException {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        String queryString = request.getQueryString();
        String[] params = queryString.split("&");
        for (int i = 0; i < params.length; ++i) {
            String key;
            String[] kv = params[i].split("=");
            if (kv.length == 2) {
                key = URLDecoder.decode(kv[0], charset);
                String value = URLDecoder.decode(kv[1], charset);
                queryMap.put(key, value);
                continue;
            }
            if (kv.length != 1) continue;
            key = URLDecoder.decode(kv[0], charset);
            queryMap.put(key, "");
        }
        return queryMap;
    }

    public static Map<String, String> getFormMap(HttpServletRequest request, Map<String, String> queryMap) throws IOException {
        HashMap<String, String> formMap = new HashMap<String, String>();
        Set keys = request.getParameterMap().keySet();
        for (Object tmp : keys) {
            String key = String.valueOf(tmp);
            if (queryMap.containsKey(key)) continue;
            String value = request.getParameter(key);
            if (StringUtils.isEmpty((Object)value)) {
                formMap.put(key, "");
                continue;
            }
            formMap.put(key, value);
        }
        return formMap;
    }

    private static String getParamStrFromMap(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            Object[] keys = params.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                Object name = keys[i];
                if ("sign".equals(name)) continue;
                sb.append((String)name);
                sb.append(params.get(name));
            }
        }
        return sb.toString();
    }

    private static String sign(Map<String, String> params, String body, String secret, String charset) throws IOException {
        StringBuilder sb = new StringBuilder(secret);
        sb.append(SpiUtils.getParamStrFromMap(params));
        if (body != null) {
            sb.append(body);
        }
        sb.append(secret);
        byte[] bytes = MD5Utils.encryptMD5(sb.toString().getBytes(charset));
        String signKey = MD5Utils.byte2hex(bytes);
        return signKey;
    }
}

