package com.efuture.ocp.common.annotation;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.MD5Utils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Map;

@Component("AutoCacheKey")
public class AutoCacheKeyImpl implements AutoCacheKeyHandle
{

    private String genKeyByNormal(int argIndex, String keyName, String expKeys, Object[] args)
    {
        StringBuffer sb = new StringBuffer();
        String[] ExpKeys = expKeys.split( "," );

        if (argIndex != -1 && args.length > argIndex) {
            Object arg = args[argIndex];
            JSONObject jsonarg;

            if (arg instanceof JSONObject) {
                jsonarg = (JSONObject) arg;
            }
            else if (arg instanceof String) {
                jsonarg = new JSONObject();
                jsonarg.put(String.valueOf(argIndex), arg);
            }
            else {
                jsonarg = (JSONObject) JSONObject.toJSON(arg);
            }

            if (StringUtils.isEmpty(keyName)) {
                if (ExpKeys != null && ExpKeys.length > 0) {
                    jsonarg = (JSONObject) jsonarg.clone();

                    for (String expKey : ExpKeys) {
                        if (jsonarg.containsKey( expKey )) {
                            jsonarg.remove(expKey);
                        }
                    }

                    sb.append("_").append(JSONObject.toJSON(jsonarg));
                }
                else {
                    sb.append("_").append(JSONObject.toJSON(arg));
                }
            }
            else {
                String[] keys = keyName.split(",");
                StringBuffer sbkey = new StringBuffer();

                for (String key : keys) {
                    if (key != null) {
                        Object value = jsonarg.get(key);

                        if (value != null) {
                            sbkey.append("-").append(key).append(":").append(value.toString());
                        }
                    }
                }

                if (sbkey.length() > 0) {
                    sb.append("_").append(sbkey.toString());
                }
                else {
                    sb.append("_").append(jsonarg.toJSONString());
                }
            }
        }
        else if (argIndex == 99 && !StringUtils.isEmpty(keyName)) {
            // 常规类型
            String[] keys = keyName.split(",");
            StringBuffer sbkey = new StringBuffer();

            for (String key : keys) {
                String keyVal = null;

                if (ExpKeys != null && ExpKeys.length > 0) {
                    if (args[Integer.valueOf(key)] instanceof Map) {
                        Map dummy = (Map) args[Integer.valueOf(key)];

                        for (String expKey : ExpKeys) {
                            dummy.remove(expKey);
                        }

                        keyVal = dummy.toString();
                    }
                    else {
                        keyVal = args[Integer.valueOf(key)].toString();
                    }
                }
                else {
                    keyVal = args[Integer.valueOf(key)].toString();
                }

                if (sbkey.length() > 0) {
                    sb.append("_").append(args[Integer.valueOf(key)].toString());
                }
                else {
                    sb.append(args[Integer.valueOf(key)].toString());
                }
            }
        }
        else if (argIndex == 100) {
            //nothing
            sb.append( "0" );
        }
        else {
            for (Object arg : args) {
                if (arg != null) {
                    sb.append("_").append(JSONObject.toJSON(arg));
                }
            }
        }

        return sb.toString();
    }

    @Override
    public String getCacheKey(ProceedingJoinPoint point, AutoCache around)
    {
        String Service = around.Service();
        String className = point.getTarget().getClass().getSimpleName();
        String methodName = point.getSignature().getName();

        String genArgKey = genKeyByNormal(around.KeyArgIndex(), around.KeyName(), around.ExpKeys(), point.getArgs());

        return Service.concat(":").concat(className).concat(":").concat(methodName).concat(":").concat( MD5Utils.MD5(genArgKey));
    }

    @Override
    public String getCacheKey(ProceedingJoinPoint point, AutoCacheEvict around)
    {
        String Service = around.Service();
        String className = DataUtils.nvl(around.ClassName(), point.getTarget().getClass().getSimpleName());
        String methodName = around.MethodName();

        if (StringUtils.isEmpty( methodName ) || "ALL".equalsIgnoreCase( methodName )) {
            return Service.concat(":").concat(className).concat(":");
        }
        else if (around.KeyArgIndex() == -100) {
            return Service.concat(":").concat(className).concat(":").concat( methodName ).concat(":");
        }
        else {
            String genArgKey = genKeyByNormal(around.KeyArgIndex(), around.KeyName(), around.ExpKeys(), point.getArgs());

            return Service.concat(":").concat(className).concat(":").concat(methodName).concat(":").concat( MD5Utils.MD5(genArgKey));
        }
    }
}
