/**
 * Copyright (C), 2007-2018, eFuture 北京富基融通科技有限公司
 * FileName:	FileServiceImpl.java
 * Author:		田
 * Date:		2018-1-22 下午2:55:15
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 *
 */
package com.efuture.ocp.common.billservice;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import org.apache.ibatis.session.RowBounds;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.BeanConstant;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.ExcelUtils;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FMybatisTemplate;
import com.github.pagehelper.Page;

@SuppressWarnings({"unused", "rawtypes", "unchecked"})
public class FileServiceImpl extends BasicComponent
{
    private static int rowMaxCount = 60000;

    private SXSSFWorkbook xlsx = null;
    private HSSFWorkbook xls = null;;
    final String ResouceBean = "amp.resource";
    private static final String STATIC_XLS = "XLS";
    private static final String STATIC_XLSX = "XLSX";
    private static final String STATIC_LEFT = "left";
    private static final String STATIC_CENTER = "center";
    private static final String STATIC_RIGHT = "right";
    private String head = "";
    private String filePath = "";

    private List<String> creatFileList = new ArrayList<String>();
    private List<CellStyle> stylelist = new ArrayList<CellStyle>();
    private Map<String, Integer> fldstyle = new HashMap<String, Integer>();

    SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");

    protected Map<String, String> dbMap;

    public FileServiceImpl()
    {
    }

    public FileServiceImpl(Map<String, String> dbMap)
    {
        this.dbMap = dbMap;
    }

    public void addFile(String file)
    {
        this.creatFileList.add(file);
    }

    public void setHead(String temp)
    {
        head = temp;
    }

    public String getFilePath()
    {
        return filePath;
    }

    public void setFilePath(String filePath)
    {
        this.filePath = filePath;
    }
    private String getPath()
    {
        if (filePath == null || "".equals(filePath)) {
            return head;
        }
        else {
            return filePath;
        }
    }


    class MultTreadClass extends Thread
    {
        private int maxDataNum = 0;
        private int maxRowNum = 0;
        private List<String> fldlst = null;
        private Map<String, String> fmts = null;
        private String exceltype = "";
        private int page = 1;
        private int endPage = 1;
        private String queryid = "";
        private Map<String, Object> search = null;
        private String fileName = "";
        private Map<String, String> disps = null;

        MultTreadClass(String fileName, String queryid, Map<String, Object> search, int page, int endPage,
                       int maxDataNum, int maxRowNum, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts,
                       String exceltype)
        {
            this.maxDataNum = maxDataNum;
            this.maxRowNum = maxRowNum;
            this.fldlst = fldlst;
            this.disps = disps;
            this.fmts = fmts;
            this.exceltype = exceltype;
            this.page = page;
            this.queryid = queryid;
            this.search = search;
            this.fileName = fileName;
            this.endPage = endPage;
        }

        @Override
        public void run()
        {
            RowBounds rowBounds = new RowBounds((this.page - 1) * this.maxDataNum, this.maxDataNum);
            int startRowIndex = 1 + (this.page - 1) * this.maxDataNum;
            long searchTimeS = System.currentTimeMillis();
            List<Map<String, Object>> list = doQuery(this.queryid, this.search, rowBounds, null);
            long searchTimeE = System.currentTimeMillis();
            int size = list.size();
            System.out
            .println("SQL(queryid:" + this.queryid + ")查询获取行数(" + size + ")时间:" + (searchTimeE - searchTimeS));

            if (size > 0) {
                try {
                    makeExcelFile(this.fileName, list, startRowIndex, this.maxRowNum, this.fldlst, this.disps,
                                  this.fmts, this.exceltype);
                }
                catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        }
    }

    class queryMakeFile extends Thread
    {
        private Map<String, Object> para = null;
        private List<String> fldlst = null;
        private Map<String, String> fmts = null;
        private String exceltype = "";
        private String fileName = "";
        private Map<String, String> disps = null;
        private RowBounds rowBounds = null;

        queryMakeFile(String fileName, Map<String, Object> para, RowBounds rowBounds, List<String> fldlst,
                      Map<String, String> disps, Map<String, String> fmts, String exceltype)
        {
            this.para = para;
            this.rowBounds = rowBounds;
            this.fileName = fileName;
            this.fldlst = fldlst;
            this.fmts = fmts;
            this.disps = disps;
            this.exceltype = exceltype;
        }

        @Override
        public void run()
        {
            try {
                StringBuffer total = new StringBuffer();
                List<Map<String, Object>> list = doQuery(para.get("queryid").toString(), para, rowBounds, total);
                String file = createExcel(list, this.fileName, this.fldlst, this.disps, this.fmts, this.exceltype);
                addFile(file);
                System.out.println("文件:" + file);
            }
            catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    class writeFileClass extends Thread
    {
        private List<Map<String, Object>> list = null;
        private List<String> fldlst = null;
        private Map<String, String> fmts = null;
        private String exceltype = "";
        private String fileName = "";
        private Map<String, String> disps = null;

        writeFileClass(String fileName, List<Map<String, Object>> list, List<String> fldlst, Map<String, String> disps,
                       Map<String, String> fmts, String exceltype)
        {
            this.list = list;
            this.fileName = fileName;
            this.fldlst = fldlst;
            this.fmts = fmts;
            this.disps = disps;
            this.exceltype = exceltype;
        }

        @Override
        public void run()
        {
            try {
                String file = createExcel(list, this.fileName, this.fldlst, this.disps, this.fmts, this.exceltype);
                addFile(file);
                System.out.println("文件:" + file);
            }
            catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }
    private void exportDataToExcel(List<Map<String, Object>> list, List<String> fldlst, Map<String, String> disps,
                                   Map<String, String> fmts, SXSSFWorkbook xlsx, HSSFWorkbook xls, String exceltype)
    {
        Sheet sheet = null;
        CellStyle columnHeadStyle = null;
        CellStyle cellString = null;
        Font f = null;

        if (fldlst == null) {
            fldlst = new ArrayList<String>();
        }

        if (disps == null) {
            disps = new HashMap<String, String>();
        }

        if (fmts == null) {
            fmts = new HashMap<String, String>();
        }

        if (STATIC_XLSX.equals(exceltype)) {
            columnHeadStyle = xlsx.createCellStyle();
            cellString = xlsx.createCellStyle();
            f = xlsx.createFont();// 字体
            sheet = xlsx.createSheet("sheet");
        }
        else {
            columnHeadStyle = xls.createCellStyle();
            cellString = xls.createCellStyle();
            f = xls.createFont();// 字体
            sheet = xls.createSheet("sheet");
        }

        columnHeadStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);// 上边框
        columnHeadStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);// 下边框
        columnHeadStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);// 左边框
        columnHeadStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);// 右边框
        columnHeadStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        columnHeadStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);

        if ("XLSX".equals(exceltype)) {
            columnHeadStyle.setDataFormat(xlsx.createDataFormat().getFormat("@"));
        }
        else {
            columnHeadStyle.setDataFormat(xls.createDataFormat().getFormat("@"));
        }

        columnHeadStyle.setWrapText(true);
        f.setFontHeightInPoints((short) 9);// 字号
        f.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);// BOLDWEIGHT_BOLD);// 加粗
        columnHeadStyle.setFont(f);
        cellString.setBorderBottom(HSSFCellStyle.BORDER_THIN);// 下边框
        cellString.setBorderLeft(HSSFCellStyle.BORDER_THIN);// 左边框
        cellString.setBorderRight(HSSFCellStyle.BORDER_THIN);// 右边框
        cellString.setBorderTop(HSSFCellStyle.BORDER_THIN);// 上边框
        cellString.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);

        if (STATIC_XLSX.equals(exceltype)) {
            cellString.setDataFormat(xlsx.createDataFormat().getFormat("@"));
        }
        else {
            cellString.setDataFormat(xls.createDataFormat().getFormat("@"));
        }

        cellString.setAlignment(HSSFCellStyle.ALIGN_LEFT);
        cellString.setWrapText(true);
        stylelist.add(cellString);
        Row row;
        Cell cell;
        row = sheet.createRow(0);
        sheet.createFreezePane(0, 1, 0, 1);
        int i = 0;

        for (String s : fldlst) {
            cell = row.createCell(i);
            cell.setCellStyle(columnHeadStyle);
            cell.setCellValue(disps.get(s));
            sheet.setColumnWidth(i, (int) 7000);
            i++;
        }

        Map cellstyle = new HashMap();

        for (String s : fldlst) {
            String style = (String) fmts.get(s);
            cellstyle.put(s, getCellStyle(s, style, xlsx, xls, exceltype));
        }

        int rowIndex = 1;
        int index = 0;

        if (list != null) {
            for (int j = 0; j < list.size(); j++) {
                row = sheet.createRow(rowIndex++);
                Map map = (Map) list.get(j);
                index = 0;

                for (String s : fldlst) {
                    cell = row.createCell(index++);
                    Object obj = map.get(s);
                    String style = (String) fmts.get(s);
                    setCellsValueTyle(cellstyle, cell, obj, s, style, xlsx, xls, exceltype);
                }
            }
        }
    }

    protected void setCellsValueTyle(Map<String, Object> map, Cell cell, Object obj, String fld, String style,
                                     SXSSFWorkbook xlsx, HSSFWorkbook xls, String exceltype)
    {
        CellStyle cellStyle = (CellStyle) map.get(fld);

        if (obj != null) {
            if (!StringUtils.isEmpty(style)) {
                if (style.startsWith("d")) {
                    Date date = null;
                    String datestyle = "yyyy-MM-dd";

                    if (obj.toString().length() > 10) {
                        datestyle = "yyyy-MM-dd HH:mm:ss";
                    }

                    SimpleDateFormat sdf = new SimpleDateFormat(datestyle);

                    if (obj instanceof Date) {
                        date = (Date) obj;
                    }
                    else {
                        try {
                            date = sdf.parse(obj.toString());
                        }
                        catch (ParseException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        }
                    }

                    cell.setCellValue(date);
                    cell.setCellStyle(cellStyle);
                }
                else if (style.startsWith("n") || style.startsWith("c") || style.startsWith("p")) {
                    cell.setCellValue(Double.parseDouble(obj.toString()));
                    cell.setCellStyle(cellStyle);
                }
            }
            else {
                cell.setCellValue(obj.toString());
                cell.setCellStyle(cellStyle);
            }

            /*
             * if (obj instanceof Date) { if (StringUtils.isEmpty(style)) style =
             * "yyyy-MM-dd"; SimpleDateFormat sdfymdCard = new SimpleDateFormat(style);
             * cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
             * cell.setCellStyle(cellStyle); cell.setCellValue(sdfymdCard.format(obj)); }
             * else {
             *
             * if (obj instanceof Integer || obj instanceof Long || obj instanceof Short) {
             * cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
             * cell.setCellStyle(cellStyle); DecimalFormat df = (DecimalFormat)
             * NumberFormat.getInstance(); df.setMaximumFractionDigits(0);
             * cell.setCellValue(df.format(obj)); } else if (obj instanceof Double || obj
             * instanceof Float) { cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
             * cell.setCellStyle(cellStyle); DecimalFormat df2 = (DecimalFormat)
             * DecimalFormat.getInstance(); if (StringUtils.isEmpty(style)) style = "n2"; if
             * (style.startsWith("n")) { Integer p =
             * Integer.valueOf(style.substring(style.length() - 1, style.length()));
             * StringBuffer sb = new StringBuffer(); if (p == 0) { sb.append("0"); } else {
             * sb.append("0."); for (int j = 0; j < p; j++) { sb.append("0"); } }
             *
             * df2.setGroupingSize(3); df2.applyPattern(sb.toString());
             * cell.setCellValue(df2.format(obj)); } else if (style.startsWith("p")) {
             * DecimalFormat df3 = (DecimalFormat) DecimalFormat.getInstance();
             * df3.applyPattern("##.##%"); cell.setCellValue(df3.format(obj)); }
             *
             * } else { cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);
             * cellStyle.setWrapText(true); cell.setCellStyle(cellStyle);
             * cell.setCellValue(obj.toString()); } }
             */
        }
        else {
            cell.setCellStyle(cellStyle);
        }
    }


    protected CellStyle getCellStyle(String fld, String style, SXSSFWorkbook xlsx, HSSFWorkbook xls, String exceltype)
    {
        CellStyle cellStyle = null;

        if (STATIC_XLSX.equals(exceltype)) {
            cellStyle = xlsx.createCellStyle();
        }
        else {
            cellStyle = xls.createCellStyle();
        }

        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);// 下边框
        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);// 左边框
        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);// 右边框
        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);// 上边框
        int cellcul = -1;
        CreationHelper creationHelper = null;

        if (fldstyle.containsKey(fld)) {
            cellcul = fldstyle.get(fld);
        }

        if (cellcul == -1) {
            if (!StringUtils.isEmpty(style)) {
                String excelstyle = "";
                String[] dformat = style.split("=");
                short align = 0;

                if (style.startsWith("d")) {
                    align = HSSFCellStyle.ALIGN_CENTER;
                    excelstyle = "yyyy年m月d日";
                }
                else if (style.startsWith("n") || style.startsWith("c") || style.startsWith("p")) {
                    align = HSSFCellStyle.ALIGN_RIGHT;
                    String numStyle = "";

                    if (dformat[0].length() > 1) {
                        numStyle = dformat[0].substring(1, dformat[0].length());
                    }

                    if (!StringUtils.isEmpty(numStyle)) {
                        if (style.startsWith("n")) {
                            excelstyle = "0";
                        }
                        else if (style.startsWith("c")) {
                            excelstyle = "¥#,##0";
                        }
                        else if (style.startsWith("p")) {
                            excelstyle = "0";
                        }

                        int count = Integer.valueOf(numStyle);
                        String tempStyle = "";

                        if (count > 0) {
                            for (int i = 0; i < count; i++) {
                                tempStyle = tempStyle + "0";
                            }
                        }

                        if (!StringUtils.isEmpty(tempStyle)) {
                            excelstyle = excelstyle + "." + tempStyle;
                        }

                        if (style.startsWith("p")) {
                            excelstyle = excelstyle + '%';
                        }
                    }
                    else {
                        if (style.startsWith("n")) {
                            excelstyle = "0.00";
                        }
                        else if (style.startsWith("c")) {
                            excelstyle = "¥#,##0.00";
                        }
                        else if (style.startsWith("p")) {
                            excelstyle = "0.00%";
                        }
                    }
                }
                else {
                    align = HSSFCellStyle.ALIGN_LEFT;
                    excelstyle = "@";
                }

                if (dformat.length > 1) {
                    if (!StringUtils.isEmpty(dformat[1])) {
                        excelstyle = dformat[1];
                    }
                }

                if (dformat.length > 2) {
                    if (!StringUtils.isEmpty(dformat[2])) {
                        if (STATIC_LEFT.equals(dformat[2].toLowerCase())) {
                            align = HSSFCellStyle.ALIGN_LEFT;
                        }
                        else if (STATIC_CENTER.equals(dformat[2].toLowerCase())) {
                            align = HSSFCellStyle.ALIGN_CENTER;
                        }
                        else if (STATIC_RIGHT.equals(dformat[2].toLowerCase())) {
                            align = HSSFCellStyle.ALIGN_RIGHT;
                        }
                    }
                }

                if (STATIC_XLSX.equals(exceltype)) {
                    if (excelstyle.equals("yyyy-MM-dd") || excelstyle.equals("yyyy-MM-dd HH:mm:ss")) {
                        creationHelper = xlsx.getCreationHelper();
                        cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(excelstyle));
                    }
                    else {
                        cellStyle.setDataFormat(xlsx.createDataFormat().getFormat(excelstyle));
                    }
                }
                else {
                    if (excelstyle.equals("yyyy-MM-dd") || excelstyle.equals("yyyy-MM-dd HH:mm:ss")) {
                        creationHelper = xls.getCreationHelper();
                        cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(excelstyle));
                    }
                    else {
                        cellStyle.setDataFormat(xls.createDataFormat().getFormat(excelstyle));
                    }
                }

                cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
                cellStyle.setAlignment(align);
            }
            else {
                if (STATIC_XLSX.equals(exceltype)) {
                    cellStyle.setDataFormat(xlsx.createDataFormat().getFormat("@"));
                }
                else {
                    cellStyle.setDataFormat(xls.createDataFormat().getFormat("@"));
                }

                cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);
                cellStyle.setWrapText(true);
                cellStyle.setVerticalAlignment(HSSFCellStyle.ALIGN_LEFT);
            }
        }
        else {
            if (STATIC_XLSX.equals(exceltype)) {
                cellStyle.setDataFormat(xlsx.createDataFormat().getFormat("@"));
            }
            else {
                cellStyle.setDataFormat(xls.createDataFormat().getFormat("@"));
            }

            cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);
            cellStyle.setWrapText(true);
            cellStyle.setVerticalAlignment(HSSFCellStyle.ALIGN_LEFT);
        }

        return cellStyle;
    }
    protected String createExcel(List<Map<String, Object>> list, String fileName, List<String> fldlst,
                                 Map<String, String> disps, Map<String, String> fmts, String exceltype) throws Exception
    {
        SXSSFWorkbook xlsx = null;
        HSSFWorkbook xls = null;
        String filePath = getPath();
        File dir = new File(filePath);

        if (!dir.exists()) {
            dir.mkdirs();
        }

        String tempExcelFile = "";

        if (STATIC_XLSX.equals(exceltype)) {
            tempExcelFile = filePath + fileName + ".xlsx";
        }
        else {
            tempExcelFile = filePath + fileName + ".xls";
        }

        int rowMemory = 1024;
        FileOutputStream fos = new FileOutputStream(tempExcelFile);

        if (STATIC_XLSX.equals(exceltype)) {
            try {
                xlsx = new SXSSFWorkbook(rowMemory);
                exportDataToExcel(list, fldlst, disps, fmts,  xlsx, null, STATIC_XLSX);
                xlsx.write(fos);
                fos.flush();
                fos.close();
            }
            finally {
                fos.flush();
                fos.close();

                // 手动清除list
                if (list != null) {
                    list.clear();
                }
            }
        }
        else {
            try {
                xls = new HSSFWorkbook();
                exportDataToExcel(list, fldlst, disps, fmts,  null, xls, STATIC_XLS);
                xls.write(fos);
                fos.flush();
                fos.close();
            }
            finally {
                fos.flush();
                fos.close();
                // 手动清除list
                list.clear();
            }
        }

        // 返回
        return tempExcelFile;
    }

    public String export(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        // 参数检查
        if (session == null) {
            throw new ServiceException(ResponseCode.Exception.SESSION_IS_EMPTY, "session is empty");
        }

        if (StringUtils.isEmpty(jsonparam)) {
            throw new ServiceException(ResponseCode.Exception.PARAM_IS_EMPTY, "param is empty");
        }

        // 导出必须指定字段
        if (StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_FIELDS)))
            throw new ServiceException(ResponseCode.EXCEPTION, "{0} {1} is empty", "",
                                       BeanConstant.QueryField.PARAMKEY_FIELDS);

        // 解析字段名
        // fields="fld1:XXXX:fmt,fld2:XXXXX:fmt,fld3:XXXXX:fmt";
        StringBuffer flds = new StringBuffer();
        List<String> fldlst = new ArrayList<String>();
        Map<String, String> disps = new HashMap<String, String>();
        Map<String, String> fmts = new HashMap<String, String>();
        analyzeExportFields(jsonparam.getString(BeanConstant.QueryField.PARAMKEY_FIELDS), flds, fldlst, disps, fmts);
        jsonparam.put(BeanConstant.QueryField.PARAMKEY_FIELDS, flds.toString());
        // 查询全部数据导出
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("queryid", jsonparam.getString("queryid"));
        map.put("ent_id", session.getEnt_id());

        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get(key));
        }

        RowBounds rowBounds = new RowBounds(0, rowMaxCount);
        List<String> filelist = new ArrayList<String>();
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = sdfymdCard.format(new Date());
        String exceltype = null;

        if (StringUtils.isEmpty(map.get("filetype"))) {
            exceltype = STATIC_XLSX;
        }
        else {
            String excel = map.get("filetype").toString();

            if ("1".equals(excel)) {
                exceltype = STATIC_XLS;
            }
            else {
                exceltype = STATIC_XLSX;
            }
        }

        boolean flag = true;
        int row = 1;

        do {
            String tempfileName = fileName;
            List<Map<String, Object>> list = doQuery(jsonparam.getString("queryid"), map, rowBounds, null);

            if (list.size() < rowMaxCount) {
                if (row != 1) {
                    tempfileName = tempfileName + "(" + row + ")";
                }

                String file = createExcel(list, tempfileName, fldlst, disps, fmts, exceltype);
                filelist.add(file);
                flag = false;
            }
            else {
                tempfileName = tempfileName + "(" + row + ")";
                row++;
                String file = createExcel(list, tempfileName, fldlst, disps, fmts, exceltype);
                filelist.add(file);
                rowBounds = new RowBounds((row - 1) * rowMaxCount, rowMaxCount);
            }
        } while (flag);

        String reFile = "";

        if (filelist.size() > 1) {
            reFile = makezip(filelist, null);
        }
        else {
            reFile = filelist.get(0);
        }

        return reFile;
    }

    public String exportComplex(ServiceSession session, JSONObject jsonparam, List<Map<String, Object>> list)
    throws Exception
    {
        // 参数检查
        if (session == null) {
            throw new ServiceException(ResponseCode.Exception.SESSION_IS_EMPTY, "session is empty");
        }

        if (StringUtils.isEmpty(jsonparam)) {
            throw new ServiceException(ResponseCode.Exception.PARAM_IS_EMPTY, "param is empty");
        }

        // 导出必须指定字段
        if (StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_FIELDS)))
            throw new ServiceException(ResponseCode.EXCEPTION, "{0} {1} is empty", "",
                                       BeanConstant.QueryField.PARAMKEY_FIELDS);

        // 解析字段名
        // fields="fld1:XXXX:fmt,fld2:XXXXX:fmt,fld3:XXXXX:fmt";
        StringBuffer flds = new StringBuffer();
        List<String> fldlst = new ArrayList<String>();
        Map<String, String> disps = new HashMap<String, String>();
        Map<String, String> fmts = new HashMap<String, String>();
        analyzeExportFields(jsonparam.getString(BeanConstant.QueryField.PARAMKEY_FIELDS), flds, fldlst, disps, fmts);
        jsonparam.put(BeanConstant.QueryField.PARAMKEY_FIELDS, flds.toString());
        int maxRowNum = rowMaxCount;
        int maxDataNum = rowMaxCount;

        if (!StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_MAXROWNUM))) {
            maxRowNum = Integer.valueOf(jsonparam.getString(BeanConstant.QueryField.PARAMKEY_MAXROWNUM));
        }

        if (!StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_MAXDATANUM))) {
            maxDataNum = Integer.valueOf(jsonparam.getString(BeanConstant.QueryField.PARAMKEY_MAXDATANUM));
        }

        if (maxDataNum > rowMaxCount) {
            maxDataNum = rowMaxCount;
        }

        if (maxRowNum > maxDataNum) {
            maxRowNum = maxDataNum;
        }

        // 查询全部数据导出
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", session.getEnt_id());

        for (String key : jsonparam.keySet()) {
            if (!BeanConstant.QueryField.PARAMKEY_MAXROWNUM.equals(key)
                && !BeanConstant.QueryField.PARAMKEY_MAXDATANUM.equals(key)) {
                map.put(key, jsonparam.get(key));
            }
        }

        long sumNum = 0;
        sumNum = Long.valueOf(list.size());

        if (!StringUtils.isEmpty(disps.get("totalCount"))) {
            disps.remove("totalCount");
        }

        String modulecode = "";

        if (!StringUtils.isEmpty(disps.get("modulecode"))) {
            modulecode = disps.get("modulecode");
            disps.remove("modulecode");
        }

        creatFileList.clear();
        String fileName = sdfymdCard.format(new Date());

        if (!StringUtils.isEmpty(modulecode)) {
            fileName = modulecode + "_" + fileName;
        }

        String exceltype = null;

        if (StringUtils.isEmpty(map.get("filetype"))) {
            exceltype = STATIC_XLSX;
        }
        else {
            String excel = map.get("filetype").toString();

            if ("1".equals(excel)) {
                exceltype = STATIC_XLS;
            }
            else {
                exceltype = STATIC_XLSX;
            }
        }

        long startTime = System.currentTimeMillis();

        if (sumNum <= maxRowNum) {
            String filename = fileName + "(合计" + sumNum + "条)";
            String file = createExcel(list, filename, fldlst, disps, fmts, exceltype);
            addFile(file);
        }
        else {
            makeExcelFile(fileName, list, 1, maxRowNum, fldlst, disps, fmts, exceltype);
        }

        String reFile = "";

        if (creatFileList.size() > 1) {
            reFile = makezip(creatFileList, String.valueOf(sumNum));
        }
        else {
            reFile = creatFileList.get(0);
        }

        long endTime = System.currentTimeMillis();
        System.out.println("文件(" + reFile + ")生成完成时间:" + (endTime - startTime));
        String[] temp = reFile.split("\\\\");
        String tempFileName = temp[temp.length - 1];
        createExportLog(session, jsonparam.toJSONString(), jsonparam.getString("modulecode"), tempFileName, sumNum);
        return reFile;
    }

    private void makeExcelFile(String tempfileName, List<Map<String, Object>> list, int startRowIndex, int maxRowNum,
                               List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, String exceltype)
    throws Exception
    {
        int size = list.size();
        int row = size % maxRowNum;
        int fileNum = (size - row) / maxRowNum;
        long startTime = System.currentTimeMillis();
        List<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>();
        int fileNumS = 0;
        int fileNumE = 0;
        int thread = fileNum;

        for (int i = 0; i < fileNum; i++) {
            Map<String, Object> map = new HashMap<String, Object>();
            List<Map<String, Object>> tempList1 = new ArrayList<Map<String, Object>>();
            fileNumS = startRowIndex + i * maxRowNum;

            for (int j = maxRowNum * i; j < maxRowNum * (i + 1); j++) {
                tempList1.add(list.get(j));
            }

            fileNumE = startRowIndex + maxRowNum * (i + 1) - 1;
            map.put("filename", tempfileName + "(" + fileNumS + '-' + fileNumE + ")");
            map.put("data", tempList1);
            tempList.add(map);
        }

        if (row > 0) {
            Map<String, Object> map = new HashMap<String, Object>();
            List<Map<String, Object>> tempList1 = new ArrayList<Map<String, Object>>();
            fileNumS = startRowIndex + maxRowNum * fileNum;

            for (int j = maxRowNum * fileNum; j < size; j++) {
                tempList1.add(list.get(j));
            }

            fileNumE = startRowIndex + size - 1;
            map.put("filename", tempfileName + "(" + fileNumS + '-' + fileNumE + ")");
            map.put("data", tempList1);
            tempList.add(map);
            thread++;
        }

        ExecutorService exe = Executors.newFixedThreadPool(thread);

        for (int x = 0; x < tempList.size(); x++) {
            exe.execute(new writeFileClass((String) tempList.get(x).get("filename"),
                                           (List<Map<String, Object>>) tempList.get(x).get("data"), fldlst, disps, fmts, exceltype));
        }

        exe.shutdown();

        while (true) {
            if (exe.isTerminated()) {
                break;
            }

            Thread.sleep(50);
        }

        long endTime = System.currentTimeMillis();
        System.out.println(size + "行数据写入文件完成时间:" + (endTime - startTime));
    }

    protected List<Map<String, Object>> doQuery(String queryid, Object param, RowBounds rowBounds, StringBuffer total)
    {
        FMybatisTemplate storage = null;
        List<Map<String, Object>> list = null;

        try {
            // 得到数据源
            if (this.dbMap != null && param instanceof Map && ((Map)param).containsKey("business")) {
                String dbkey = this.dbMap.get(((Map)param).get("business").toString());
                storage = getStorageOperations(dbkey, FMybatisTemplate.class);
            }
            else {
                storage = getStorageOperations(FMybatisTemplate.class);
            }

            SqlSessionTemplate db = storage.getSqlSessionTemplate();

            // 查询
            if (rowBounds == null) {
                list = db.selectList(queryid, param);
                return list;
            }
            else {
                list = db.selectList(queryid, param, rowBounds);

                if (total != null) {
                    total.append(((Page) list).getTotal());
                }

                return list;
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    public String makezip(List<String> filelist, String sumNum) throws IOException
    {
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        String trackkey = sdfymdCard.format(new Date());
        String filename = trackkey;

        if (!StringUtils.isEmpty(sumNum)) {
            filename = filename + "(合计" + sumNum + "条)";
        }

        List<File> files = new ArrayList<File>();

        for (int i = 0; i < filelist.size(); i++) {
            File file = new File(filelist.get(i));
            files.add(file);
        }

        String head = getPath();
        String name = head + filename + ".rar";
        File file = new File(name);

        if (!file.exists()) {
            file.createNewFile();
        }

        FileOutputStream fous = new FileOutputStream(file);
        /**
         * 打包的方法我们会用到ZipOutputStream这样一个输出流, 所以这里我们把输出流转换一下
         */
        ZipOutputStream zipOut = new ZipOutputStream(fous);
        /**
         * 这个方法接受的就是一个所要打包文件的集合， 还有一个ZipOutputStream
         */
        zipFile(files, zipOut);
        zipOut.close();
        fous.close();

        // 删除文件
        for (File temp : files) {
            if (temp.isFile() && temp.exists()) {
                temp.delete();
            }
        }

        return name;
    }

    /**
     * 把接受的全部文件打成压缩包
     *
     * @param List
     *            <File>;
     * @param org
     *            .apache.tools.zip.ZipOutputStream
     */
    private void zipFile(List files, ZipOutputStream outputStream)
    {
        int size = files.size();

        for (int i = 0; i < size; i++) {
            File file = (File) files.get(i);
            zipFile(file, outputStream);
        }
    }

    /**
     * 根据输入的文件与输出流对文件进行打包
     *
     * @param File
     * @param org
     *            .apache.tools.zip.ZipOutputStream
     */
    private void zipFile(File inputFile, ZipOutputStream ouputStream)
    {
        try {
            if (inputFile.exists()) {
                /**
                 * 如果是目录的话这里是不采取操作的， 至于目录的打包正在研究中
                 */
                if (inputFile.isFile()) {
                    FileInputStream IN = new FileInputStream(inputFile);
                    BufferedInputStream bins = new BufferedInputStream(IN, 512);
                    // org.apache.tools.zip.ZipEntry
                    ZipEntry entry = new ZipEntry(inputFile.getName());
                    ouputStream.putNextEntry(entry);
                    // 向压缩文件中输出数据
                    int nNumber;
                    byte[] buffer = new byte[512];

                    while ((nNumber = bins.read(buffer)) != -1) {
                        ouputStream.write(buffer, 0, nNumber);
                    }

                    // 关闭创建的流对象
                    bins.close();
                    IN.close();
                }
                else {
                    try {
                        File[] files = inputFile.listFiles();

                        for (int i = 0; i < files.length; i++) {
                            zipFile(files[i], ouputStream);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    // 导出下载模版
    public String exportTemplate(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        // 参数检查
        if (session == null) {
            throw new ServiceException(ResponseCode.Exception.SESSION_IS_EMPTY, "session is empty");
        }

        if (StringUtils.isEmpty(jsonparam)) {
            throw new ServiceException(ResponseCode.Exception.PARAM_IS_EMPTY, "param is empty");
        }

        String billmoduleid = jsonparam.getString("billmoduleid");
        Map<String, String> config = ExcelUtils.getimpconfig(billmoduleid);
        String filename = config.get("file");
        String head = config.get("head");
        List<String> fldlst = new ArrayList<String>();
        String[] headfield = head.split(",");
        Map<String, String> disps = new HashMap<String, String>();
        int i = 0;

        for (String s : headfield) {
            fldlst.add(String.valueOf(i));
            disps.put(String.valueOf(i), s);
            i++;
        }

        String exceltype = null;

        if (StringUtils.isEmpty(jsonparam.getString("filetype"))) {
            exceltype = STATIC_XLSX;
        }
        else {
            String excel = jsonparam.getString("filetype");

            if ("1".equals(excel)) {
                exceltype = STATIC_XLS;
            }
            else {
                exceltype = STATIC_XLSX;
            }
        }

        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        filename = filename + sdfymdCard.format(new Date());
        return createExcel(null, filename, fldlst, disps, null, exceltype);
    }

    public String exportTxt(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        // 参数检查
        if (session == null) {
            throw new ServiceException(ResponseCode.Exception.SESSION_IS_EMPTY, "session is empty");
        }

        if (StringUtils.isEmpty(jsonparam)) {
            throw new ServiceException(ResponseCode.Exception.PARAM_IS_EMPTY, "param is empty");
        }

        String queryid = jsonparam.getString("queryid");
        List<Map<String, Object>> list = doQuery(queryid, jsonparam, null, null);
        return createTxt(list, jsonparam.getString("filename"), jsonparam.getString("fields"));
    }

    private String createTxt(List<Map<String, Object>> list, String fileName, String fields) throws Exception
    {
        String filePath = getPath();
        File dir = new File(filePath);

        if (!dir.exists()) {
            dir.mkdirs();
        }

        StringBuffer sb = new StringBuffer("");
        String tempTxtFile = "";
        tempTxtFile = fileName + ".txt";
        getFileContext(list, fields, sb);
        saveAsFileWriterGbk(sb.toString(), tempTxtFile);
        return tempTxtFile;
    }

    private void saveAsFileWriterGbk(String content, String filename)
    {
        Writer out = null;

        try {
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename), "GBK"));
            out.write(content);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void saveAsFileWriterUtf(String content, String filename)
    {
        Writer out = null;

        try {
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename), "UTF-8"));
            out.write(content);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private Object getValue(Object value)
    {
        return StringUtils.isEmpty(value) ? "" : value;
    }

    private String getFileContext(List<Map<String, Object>> map, String fields, StringBuffer sb)
    {
        sb.setLength(0);
        String[] list = fields.split(",");

        for (Map<String, Object> temp : map) {
            for (int i = 0; i < list.length; i++) {
                if (i + 1 == list.length) {
                    sb.append(getValue(temp.get(list[i])));
                }
                else {
                    sb.append(getValue(temp.get(list[i]))).append("\t");
                }
            }

            sb.append("\r\n");
        }

        return sb.toString();
    }

    public String exportLC(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        if (session == null) {
            throw new ServiceException(ResponseCode.Exception.SESSION_IS_EMPTY, "session is empty");
        }

        if (jsonparam == null || jsonparam.isEmpty()) {
            throw new ServiceException(ResponseCode.Exception.PARAM_IS_EMPTY, "param is empty");
        }

        if (jsonparam.get("files") == null || jsonparam.get("files").equals("")) {
            throw new ServiceException(ResponseCode.EXCEPTION, "{0} {1} is empty", "", "files");
        }

        JSONArray files = jsonparam.getJSONArray("files");
        List<String> filelist =  new ArrayList<String>();

        for (int i = 0; i < files.size(); i++) {
            JSONObject json = files.getJSONObject(i);
            Iterator<String> iterator = jsonparam.keySet().iterator();

            while (iterator.hasNext()) {
                String key = iterator.next();

                if ("files".equals(key)) {
                    continue;
                }
                else {
                    json.put(key, jsonparam.getString(key));
                }
            }

            json.put("ent_id", session.getEnt_id());
            String  tempfilepath = exportTxt(session, json);
            filelist.add(tempfilepath);
        }

        return makezip(filelist, null);
    }

    public String exportNC(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        if (session == null) {
            throw new ServiceException(ResponseCode.Exception.SESSION_IS_EMPTY, "session is empty");
        }

        if (jsonparam == null || jsonparam.isEmpty()) {
            throw new ServiceException(ResponseCode.Exception.PARAM_IS_EMPTY, "param is empty");
        }

        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        String name = sdfymdCard.format(new Date());
        String billno = jsonparam.getString("billno");
        String info = null;

        if (billno != null && !"".equals(billno)) {
            info = name = billno;
        }

        Map<String, Object> param = new HashMap<String, Object>();
        Map<String, Object> param2 = new HashMap<String, Object>();
        Iterator<String> iterator = jsonparam.keySet().iterator();
        int i = 1;

        while (iterator.hasNext()) {
            String key = iterator.next();
            param.put(key, jsonparam.getString(key));
            param2.put(key, jsonparam.getString(key));

            if (i == 1 && !StringUtils.isEmpty(jsonparam.getString(key)) && info == null) {
                info = jsonparam.getString(key);
                i++;
            }
        }

        //param.put("billno", billno);
        param.put("o_filecontext", "");
        doQuery("select_ncdate", param, null, null);

        if ("1".equals(param.get("o_filecontext").toString())) {
            throw new ServiceException(ResponseCode.FAILURE, "[{0}]凭证数据生成失败，请检查!", info);
        }

        //param2.put("billno", billno);
        List<Map<String, Object>> list = doQuery("select_filecontext", param2, null, null);
        Map<String, Object> filecontext = null;

        if (list.size() == 0) {
            throw new ServiceException(ResponseCode.FAILURE, "[{0}]没有凭证数据，请检查!", info);
        }
        else {
            filecontext =  list.get(0);

            if (filecontext.get("xmldata") == null || filecontext.get("xmldata").equals("")) {
                throw new ServiceException(ResponseCode.FAILURE, "[{0}]没有凭证数据，请检查!", info);
            }
        }

        String head = getPath();
        String filename = head + name + ".xml";
        saveAsFileWriterUtf(filecontext.get("xmldata").toString(), filename);
        return filename;
    }



    private int rowIndex = 0; //行索引
    private int cellIndex = 0; //单元格索引
    private int ROW_MAX = 20000; //行最大2万行
    private int COLUMN_MAX = 106; //单元格最大格数为106
    private double defaultWidth = 0.67; //默认的单元格的宽度0.5
    private int defaultHigh = 25;
    private double defaultRangCell = 0.30; //默认合并单元格数
    private double defaulttextCell = 0.1; //默认合并单元格数
    private int defaultGreadCell = 0;
    interface PageSize
    {
        interface A4
        {
            /*
             * 横向列总数
             * */
            int crosswiseColumnCnt = 23;
            /*
             * 纵向列总数
             * */
            int lengthwaysColumnCnt = 15;
            double defaultWidth = 4;		//默认最小的列的宽度
            int defaultHigh = 25;			//默认的每行的高度
        }
    }
    /*
     * 纸张页面设置
     * */
    @SuppressWarnings("deprecation")
    private HSSFSheet setSheetPaper(HSSFSheet sheet, String a4, String orientation)
    {
        sheet.setDisplayGridlines(false);//默认是不显示网格的

        if ("a4".equalsIgnoreCase(a4)) {
            defaultHigh = PageSize.A4.defaultHigh;
            defaultWidth = PageSize.A4.defaultWidth;
            sheet.setDefaultColumnWidth((short)defaultWidth);//设置缺省列宽
            sheet.setDefaultRowHeightInPoints(defaultHigh);// 设置缺省列高
            PrintSetup printSetup = sheet.getPrintSetup();
            printSetup.setPaperSize(HSSFPrintSetup.A4_PAPERSIZE);

            if ("横向".equalsIgnoreCase(orientation)) {
                printSetup.setLandscape(true); // 打印方向，true：横向，false：纵向(默认)
                COLUMN_MAX = PageSize.A4.crosswiseColumnCnt;
            }
            else {//纵向
                printSetup.setLandscape(false); // 打印方向，true：横向，false：纵向(默认)
                COLUMN_MAX = PageSize.A4.lengthwaysColumnCnt;
            }
        }
        else {
        }

        return sheet;
    }
    /*
     * 换行操作行所以增加，单元格索引归零
     * */
    private void changeRow(HSSFSheet sheet, int gread)
    {
        Row r = sheet.getRow(rowIndex);

        if (r != null) {
            r.setHeightInPoints(defaultHigh);
        }

        rowIndex++;
        cellIndex = defaultGreadCell * gread;
        defaultHigh = 25; //设置默认的行高
    }
    private HSSFRow getRow(HSSFSheet sheet)
    {
        HSSFRow row = sheet.getRow(rowIndex);

        if (row == null) { //新的一行为空行，那就新建一行
            row = sheet.createRow(rowIndex);
        }

        return row;
    }
    /*
     * 0级标题样式，字体设置
     * */
    private HSSFCellStyle title0Style(HSSFWorkbook xls, HSSFCellStyle cellStyle)
    {
        //----------------标题样式---------------------
        //HSSFCellStyle cellStyle = xls.createCellStyle();        //标题样式
        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        Font ztFont = xls.createFont();
        ztFont.setItalic(false);                     // 设置字体为斜体字
        ztFont.setColor(Font.COLOR_NORMAL);            // 将字体设置为“红色”
        ztFont.setFontHeightInPoints((short)20);    // 将字体大小设置为18px
        ztFont.setFontName("宋体");                  // 将“宋体”字体应用到当前单元格上
        ztFont.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);    //加粗
        //         ztFont.setUnderline(Font.U_DOUBLE);         // 添加（Font.U_SINGLE单条下划线/Font.U_DOUBLE双条下划线）
        //          ztFont.setStrikeout(true);                  // 是否添加删除线
        cellStyle.setFont(ztFont);
        return cellStyle;
    }
    /*
     * 1级标题样式，字体设置
     * */
    private HSSFCellStyle title1Style(HSSFWorkbook xls, HSSFCellStyle cellStyle)
    {
        //----------------标题样式---------------------
        //HSSFCellStyle cellStyle = xls.createCellStyle();        //标题样式
        cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);
        cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        Font ztFont = xls.createFont();
        ztFont.setItalic(false);                     // 设置字体为斜体字
        ztFont.setColor(Font.COLOR_NORMAL);            // 将字体设置为“红色”
        ztFont.setFontHeightInPoints((short)12);    // 将字体大小设置为18px
        ztFont.setFontName("宋体");                  // 将“宋体”字体应用到当前单元格上
        ztFont.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);    //加粗
        ztFont.setUnderline(Font.U_SINGLE);         // 添加（Font.U_SINGLE单条下划线/Font.U_DOUBLE双条下划线）
        //          ztFont.setStrikeout(true);                  // 是否添加删除线
        cellStyle.setFont(ztFont);
        return cellStyle;
    }
    /*
     * 设置字体
     * */
    private Font setFont(HSSFWorkbook xls, String s)
    {
        Font ztFont = xls.createFont();

        switch (s) {
            case "default"://默认的字体
                ztFont.setItalic(false);                     	// 设置字体为非斜体字
                ztFont.setColor(Font.COLOR_NORMAL);            	// 将字体设置为正常的黑色
                ztFont.setFontHeightInPoints((short)10);    	// 将字体大小设置为10px
                ztFont.setFontName("宋体");                  		// 将“宋体”字体应用到当前单元格上
                ztFont.setBoldweight(HSSFFont.BOLDWEIGHT_NORMAL);    //正常不加粗
                break;

            case "title1"://1.级标题字体
                ztFont.setItalic(false);                     // 设置字体为斜体字
                ztFont.setColor(Font.COLOR_NORMAL);            // 将字体设置为“红色”
                ztFont.setFontHeightInPoints((short)18);    // 将字体大小设置为18px
                ztFont.setFontName("宋体");                  // 将“宋体”字体应用到当前单元格上
                ztFont.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);    //加粗
                break;

            case "title2"://2.级标题字体
                ztFont.setItalic(false);                     			// 设置字体为非斜体字
                ztFont.setColor(Font.COLOR_NORMAL);           			// 将字体设置为正常的黑色
                ztFont.setFontHeightInPoints((short)16);    			// 将字体大小设置为16px
                ztFont.setFontName("宋体");                  				// 将“宋体”字体应用到当前单元格上
                ztFont.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);    		//正常不加粗
                break;

            case "title3"://3.级标题字体
                ztFont.setItalic(false);                     			// 设置字体为非斜体字
                ztFont.setColor(Font.COLOR_NORMAL);           			// 将字体设置为正常的黑色
                ztFont.setFontHeightInPoints((short)14);    			// 将字体大小设置为10px
                ztFont.setFontName("宋体");                  				// 将“宋体”字体应用到当前单元格上
                ztFont.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);    		//正常不加粗
                break;

            case "required":
                ztFont.setItalic(false);                     			// 设置字体为非斜体字
                ztFont.setColor((short)HSSFColor.BLUE.index);           // 将字体设置为正常的黑色
                ztFont.setFontHeightInPoints((short)10);    			// 将字体大小设置为10px
                ztFont.setFontName("宋体");                  				// 将“宋体”字体应用到当前单元格上
                ztFont.setBoldweight(HSSFFont.BOLDWEIGHT_NORMAL);    	//正常不加粗
                break;

            default:
                break;
        }

        return ztFont;
    }
    /*
     * 设置标题
     * */
    private HSSFSheet setTilte(HSSFWorkbook xls, HSSFSheet sheet, String title, int gread)
    {
        //设置标题
        HSSFRow row = null;
        HSSFCell cell = null;

        if (gread == 0) { //大标题
            // ----------------------创建第一行---------------
            // 在sheet里创建第一行，参数为行索引(excel的行)，可以是0～65535之间的任何一个
            row = sheet.createRow(rowIndex);
            // 创建单元格（excel的单元格，参数为列索引，可以是0～255之间的任何一个
            cell = row.createCell(0);
            // 合并单元格CellRangeAddress构造参数依次表示起始行，截至行，起始列， 截至列
            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, COLUMN_MAX));
            cell = row.getCell(cellIndex);
            // 设置单元格内容
            cell.setCellValue(title);
            cell.setCellStyle(title0Style(xls, xls.createCellStyle()));
        }
        else if (gread == 1) { //一级标题
            // ----------------------创建第一行---------------
            // 在sheet里创建第一行，参数为行索引(excel的行)，可以是0～65535之间的任何一个
            row = sheet.createRow(rowIndex);
            // 创建单元格（excel的单元格，参数为列索引，可以是0～255之间的任何一个
            cell = row.createCell(cellIndex);
            // 合并单元格CellRangeAddress构造参数依次表示起始行，截至行，起始列， 截至列
            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, cellIndex, COLUMN_MAX));
            cell = row.getCell(cellIndex);
            // 设置单元格内容
            cell.setCellValue(title);
            cell.setCellStyle(title1Style(xls, xls.createCellStyle()));
        }

        return sheet;
    }
    private HSSFCellStyle setCellDataFormate(HSSFWorkbook xls, HSSFCellStyle cellStyle, String s, String formate)
    {
        HSSFDataFormat format = xls.createDataFormat();

        switch (s) {
            case "文本":
                //设置单元格格式为文本格式
                cellStyle.setDataFormat(format.getFormat("@"));
                break;

            case "货币":
                cellStyle.setDataFormat(format.getFormat("¥#,##0.00"));
                break;

            case "日期":
                cellStyle.setDataFormat(format.getFormat(formate));
                break;

            case "百分比":
                cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat(formate));
                break;

            default:
                break;
        }

        return cellStyle;
    }
    public float getregex(String charStr)
    {
        if (charStr == " ") {
            return 0.5f;
        }

        // 判断是否为字母或字符
        if (Pattern.compile("^[A-Za-z0-9]+$").matcher(charStr).matches()) {
            return 0.5f;
        }

        // 判断是否为全角

        if (Pattern.compile("[\u4e00-\u9fa5]+$").matcher(charStr).matches()) {
            return 1.00f;
        }

        //全角符号 及中文
        if (Pattern.compile("[^x00-xff]").matcher(charStr).matches()) {
            return 1.00f;
        }

        return 0.5f;
    }
    private HSSFSheet autoSetHeight(HSSFSheet sheet, Cell c, int length)
    {
        //换行之前先遍历本行中所有的单元格，查看单元格中是否有换行的，如果有高度应该增加
        Row row = sheet.getRow(rowIndex);
        float fontCountInline = length * 5; //默认是每个单元格显示5个英文字符
        float defaultRowHeight = 25.00f;//每一行的高度指定
        float defaultCount = 0.00f;
        String str = c.toString();

        for (int i = 0; i < str.length(); i++) {
            float ff = getregex(str.substring(i, i + 1));
            defaultCount = defaultCount + ff;
        }

        int rwsTemp = (int) (((int) (defaultCount / fontCountInline)) * defaultRowHeight); //计算

        if (defaultHigh < rwsTemp) {
            defaultHigh = rwsTemp;
            row.setHeight((short)(rwsTemp * 25));
        }

        return sheet;
    }
    private HSSFSheet setFormCell(HSSFWorkbook xls, HSSFSheet sheet, String type, JSONObject column, int length) throws ParseException
    {
        HSSFCell cell = getRow(sheet).createCell(cellIndex);//创建单元格

        if (length > 0) { //需要合并单元格数
            // 合并单元格CellRangeAddress构造参数依次表示起始行，截至行，起始列， 截至列
            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, cellIndex, cellIndex + length));
            cell = getRow(sheet).getCell(cellIndex); //合并单元格后重新赋值
            cellIndex += length;
        }

        // 设置单元格样式
        HSSFCellStyle cellStyle = xls.createCellStyle();        //单元格样式
        cellStyle.setWrapText(true);//单元格强制换行
        cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);//垂直居中

        if ("text".equals(type)) { //当前单元格式文字填充
            //单元格字体颜色
            String required = column.getString("required");

            if (required == null || required.equalsIgnoreCase("false")) {
                cellStyle.setFont(setFont(xls, "default"));
            }
            else {
                cellStyle.setFont(setFont(xls, "required"));
            }

            //单元格 是否居中等
            String labelAlign = column.getString("labelAlign"); //headerAlign : "center"

            if (labelAlign == null || labelAlign.equalsIgnoreCase("right")) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);//水平居右
            }
            else if (labelAlign.equalsIgnoreCase("left")) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);//水平居
            }
            else if (labelAlign.equalsIgnoreCase("center")) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);//水平居
            }
            else {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);//水平居右
            }

            cellStyle = setCellDataFormate(xls, cellStyle, "文本", null);
            //cell.setCellStyle(cellStyle);
            // 设置单元格内容
            cell.setCellValue(column.getString("label"));
        }
        else if ("value".equals(type)) { //值填充
            cellStyle.setFont(setFont(xls, "default"));
            String dataAlign = column.getString("dataAlign"); //headerAlign : "center"

            if (dataAlign == null || dataAlign.equalsIgnoreCase("left")) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);//水平居右
            }
            else if (dataAlign.equalsIgnoreCase("rigth")) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);//水平居右
            }
            else if (dataAlign.equalsIgnoreCase("center")) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);//水平居右
            }

            cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);//垂直居中
            String fmt = column.getString("format");
            String datatype = column.getString("datatype");

            if (datatype.startsWith("s")) { //文本
                cellStyle = setCellDataFormate(xls, cellStyle, "文本", null);
                // 设置单元格内容
                cell.setCellValue(column.getString("data"));
            }
            else if (datatype.startsWith("d")) { //时间类型
                Date date = null;
                String datestyle = "yyyy-MM-dd";

                if (fmt.length() > 10) {
                    datestyle = "yyyy-MM-dd HH:mm:ss";
                }

                HSSFDataFormat format = xls.createDataFormat();
                cellStyle.setDataFormat(format.getFormat(datestyle));
                SimpleDateFormat sdf =   new SimpleDateFormat(datestyle);

                if (column.getString("data") != null) {
                    date = sdf.parse(column.getString("data"));
                    cell.setCellValue(date);
                }
            }
        }

        cell.setCellStyle(cellStyle);
        //设置行高度
        sheet = autoSetHeight(sheet, cell, length + 1);
        cellIndex ++;//单元格自动加1
        return sheet;
    }
    private HSSFSheet setGridCell(HSSFWorkbook xls, HSSFSheet sheet, String type, JSONObject column, JSONObject data, int length) throws ParseException
    {
        HSSFCell cell = getRow(sheet).createCell(cellIndex);//创建单元格

        if (length > 0) { //需要合并单元格数
            // 合并单元格CellRangeAddress构造参数依次表示起始行，截至行，起始列， 截至列
            CellRangeAddress cra = new CellRangeAddress(rowIndex, rowIndex, cellIndex, cellIndex + length);
            sheet.addMergedRegion(cra);
            int border = 1;
            RegionUtil.setBorderBottom(border, cra, sheet, xls); //下边框
            RegionUtil.setBorderLeft(border, cra, sheet, xls); //左边框
            RegionUtil.setBorderTop(border, cra, sheet, xls); //上边框
            RegionUtil.setBorderRight(border, cra, sheet, xls); //右边框
            cell = getRow(sheet).getCell(cellIndex); //合并单元格后重新赋值
            cellIndex += length;
        }

        // 设置单元格内容
        HSSFCellStyle cellStyle = xls.createCellStyle();        //单元格样式
        cellStyle.setWrapText(true);//单元格强制换行
        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN); //下边框
        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);//左边框
        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);//上边框
        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);//右边框
        cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);//垂直居中

        if ("text".equals(type)) { //当前单元格式文字填充
            String required = column.getString("required");

            if (required == null || required.equalsIgnoreCase("false")) {
                cellStyle.setFont(setFont(xls, "default"));
            }
            else {
                cellStyle.setFont(setFont(xls, "required"));
            }

            String labelAlign = column.getString("labelAlign"); //headerAlign : "center"

            if (labelAlign == null || labelAlign.equalsIgnoreCase("right")) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);//水平居右
            }
            else if (labelAlign.equalsIgnoreCase("left")) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);//水平居右
            }
            else if (labelAlign.equalsIgnoreCase("center")) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);//水平居右
            }

            cell.setCellValue(column.getString("label"));
            cellStyle = setCellDataFormate(xls, cellStyle, "文本", null);
        }
        else if ("value".equals(type)) { //值填充
            cellStyle.setFont(setFont(xls, "default"));
            String dataAlign = column.getString("dataAlign"); //headerAlign : "center"

            if (dataAlign == null || dataAlign.equalsIgnoreCase("left")) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);//水平居右
            }
            else if (dataAlign.equalsIgnoreCase("rigth")) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_RIGHT);//水平居右
            }
            else if (dataAlign.equalsIgnoreCase("center")) {
                cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);//水平居右
            }

            String tp = column.getString("type"); //type : "TextBox"
            String datatype = column.getString("datatype");

            if (datatype.startsWith("s")) { //文本
                cellStyle = setCellDataFormate(xls, cellStyle, "文本", null);

                // 设置单元格内容
                if ("comboboxcolumn".equalsIgnoreCase(tp)) {
                    String s = null;
                    JSONArray j = column.getJSONArray("data");

                    for (int i = 0; i < j.size(); i++) {
                        String ss = data.getString(column.getString("name"));

                        if (ss.equals(j.getJSONObject(i).get("code"))) {
                            s = "[" + j.getJSONObject(i).get("code") + "]" + j.getJSONObject(i).get("name");
                        }
                    }

                    cell.setCellValue(s);
                }
                else {
                    cell.setCellValue(data.getString(column.getString("name")));
                }
            }
            else if (datatype.startsWith("d")) { //时间类型
                String fmt = column.getString("format");
                cellStyle = setCellDataFormate(xls, cellStyle, "日期", fmt.toLowerCase());
                SimpleDateFormat dateFormat = new SimpleDateFormat(fmt.toLowerCase());

                if (data.getString(column.getString("name")) != null) {
                    Date date = dateFormat.parse(data.getString(column.getString("name")));
                    cell.setCellValue(date);
                }
            }
            else if (datatype.startsWith("c")) { //货币格式
                String fmt = column.getString("format");
                cellStyle = setCellDataFormate(xls, cellStyle, "货币", fmt);
                // 设置单元格内容
                cell.setCellValue(data.getDouble(column.getString("name")));
            }
            else if (datatype.startsWith("p")) { //百分比
                String fmt = column.getString("format");

                if ("p2".equalsIgnoreCase(datatype)) {
                    fmt = "0.00%";
                }
                else if ("p4".equalsIgnoreCase(datatype)) {
                    fmt = "0.0000%";
                }

                cellStyle = setCellDataFormate(xls, cellStyle, "百分比", fmt);
                // 设置单元格内容
                cell.setCellValue(data.getDouble(column.getString("name")));
            }
        }

        cell.setCellStyle(cellStyle);
        //设置行高度
        sheet = autoSetHeight(sheet, cell, length + 1);
        cellIndex ++;//单元格自动加1
        return sheet;
    }
    /*
     * 参数说明：
     * jsonparam：必须包含以下几个字段
     * title：...打印的大标题
     * pagesize:A4,A3(打印的纸张)
     * orientation:横向，纵向 (纸张方向)
     * items：数据集
     * ---------type：formgrid，gridbox
     * ---------title：
     * ---------columns：字段列
     * */
    public String exportExcelPrint(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        // 参数检查
        if (session == null) {
            throw new ServiceException(ResponseCode.Exception.SESSION_IS_EMPTY, "session is empty");
        }

        if (StringUtils.isEmpty(jsonparam)) {
            throw new ServiceException(ResponseCode.Exception.PARAM_IS_EMPTY, "param is empty");
        }

        //初始化参数
        rowIndex = 0; //行索引
        cellIndex = 0; //单元格索引
        String a4 = jsonparam.getString("pagesize") == null ? "A4" : jsonparam.getString("pagesize");
        String orientation = jsonparam.getString("orientation") == null ? "横向" : jsonparam.getString("orientation");
        // 创建HSSFWorkbook对象(excel的文档对象)
        HSSFWorkbook xls = new HSSFWorkbook();
        //新建sheet页
        HSSFSheet sheet = xls.createSheet("默认");
        //页面基本设置
        sheet = setSheetPaper(sheet, a4, orientation);
        //设置大标题，也可以不设置
        String bigtitle = jsonparam.getString("title");

        if (bigtitle != null && bigtitle != "") {
            sheet = setTilte(xls, sheet, bigtitle, 0);
            changeRow(sheet, 1);
        }

        JSONArray jsona = jsonparam.getJSONArray("items");

        if (jsona != null && jsona.size() > 0) {
            //判读是否有grid列
            for (int i = 0; i < jsona.size(); i++) {
                JSONObject jsono = jsona.getJSONObject(i);

                if (jsono != null) {
                    String type = jsono.getString("type");

                    if ("formgrid".equalsIgnoreCase(type)) {
                        JSONArray ja = jsono.getJSONArray("items");

                        for (int j = 0; j < ja.size(); j++) {
                            //第一步设置标题：
                            String title = ja.getJSONObject(j).getString("title");

                            if (title != null && title != "") {
                                sheet = setTilte( xls, sheet, title, 1);
                                //标题设置完，必须要换行，换行不需要变更标题级次
                                changeRow(sheet, 1);
                            }

                            //第二部设置表单：
                            JSONArray columns = ja.getJSONObject(j).getJSONArray("columns");

                            if (columns != null && columns.size() > 0) {
                                //填充表单字段项
                                for (int k = 0; k < columns.size(); k++) {
                                    JSONObject col = columns.getJSONObject(k);
                                    String visible = col.getString("visible");

                                    if (visible != null && visible.equalsIgnoreCase("false")) {
                                        continue;
                                    }
                                    else {
                                        //显示文本项
                                        int textcnt = (int)((int)COLUMN_MAX * defaulttextCell);
                                        //显示值项
                                        int valuecnt = (int)((int)COLUMN_MAX * (defaultRangCell - defaulttextCell));

                                        //需要判断这个字段是否超出边界，超过了就要另起一行
                                        if (COLUMN_MAX - cellIndex - textcnt - valuecnt < 0) {
                                            changeRow(sheet, 1);
                                        }

                                        sheet = setFormCell(xls, sheet, "text", col, textcnt);
                                        sheet = setFormCell(xls, sheet, "value", col, valuecnt);

                                        //检查宽度是否为100，换行用
                                        if ("100".equalsIgnoreCase(col.getString("width"))) { //
                                            changeRow(sheet, 1);
                                        }
                                    }
                                }

                                changeRow(sheet, 1);
                            }
                        }
                    }
                    else if ("gridbox".equalsIgnoreCase(type)) {
                        JSONArray ja = jsono.getJSONArray("items");
                        //第一步设置标题：
                        String title = jsono.getString("title");

                        if (title != null && title != "") {
                            sheet = setTilte(xls, sheet, title, 1);
                            //标题设置完，必须要换行，换行不需要变更标题级次
                            changeRow(sheet, 1);
                        }

                        for (int j = 0; j < ja.size(); j++) {
                            //第二部设置表头：如果表头没有，那数据列也不显示
                            JSONArray columns = ja.getJSONObject(j).getJSONArray("columns");

                            if (columns != null && columns.size() > 0) {
                                //填充表单字段项
                                for (int k = 0; k < columns.size(); k++) {
                                    JSONObject col = columns.getJSONObject(k);
                                    String visible = col.getString("visible");
                                    String name = col.getString("label");

                                    if (visible != null && visible.equalsIgnoreCase("false")) {
                                        continue;
                                    }
                                    else {
                                        if (name != null) {
                                            //显示文本项
                                            //int textcnt =(int)((int)(COLUMN_MAX-1*defaultGreadCell)/columns.size());
                                            int textcnt = 2;
                                            sheet = setGridCell(xls, sheet, "text", col, null, textcnt);
                                        }
                                    }
                                }

                                changeRow(sheet, 1);
                                //设置数据列
                                JSONArray data = ja.getJSONObject(j).getJSONArray("data");

                                if (data != null && data.size() > 0) {
                                    //填充表单字段项
                                    for (int k = 0; k < data.size(); k++) { //行
                                        //根据表头，填充列数据
                                        for (int m = 0; m < columns.size(); m++) { //列
                                            JSONObject col = columns.getJSONObject(m);
                                            String visible = col.getString("visible");

                                            if (visible != null && visible.equalsIgnoreCase("false")) {
                                                continue;
                                            }
                                            else {
                                                String name = col.getString("label");

                                                if (name != null) {
                                                    //显示文本项
                                                    //int textcnt =(int)((int)(COLUMN_MAX-1*defaultGreadCell)/columns.size());
                                                    int textcnt = 2;
                                                    sheet = setGridCell(xls, sheet, "value", col, data.getJSONObject(k), textcnt);
                                                }
                                            }
                                        }

                                        changeRow(sheet, 1);
                                    }
                                }
                            }

                            changeRow(sheet, 1);
                        }
                    }
                    else {
                        throw new Exception("type 没有定义，请检查");
                    }
                }
            }
        }

        //		String osname = System.getProperties().getProperty("os.name");
        //		String head = "//opt//file//";
        //		if (osname.startsWith("Windows")) {
        //			head = "D:\\";
        //		}
        String tempExcelFilename = getPath() + UniqueID.getUniqueID() + ".xls";
        FileOutputStream fos = new FileOutputStream(tempExcelFilename);
        xls.write(fos);
        fos.flush();
        fos.close();
        return tempExcelFilename;
    }

    // 导出日志
    public void createExportLog(ServiceSession session, String param, String modulecode, String fileName, long dataNum)
    throws Exception
    {
        String token = session.getToken();
        String userid = "";
        String usercode = "";
        String postid = "";

        if (!StringUtils.isEmpty(token)) {
            try {
                if (!StringUtils.isEmpty(Long.toString(session.getUser_id()))) {
                    userid = Long.toString(session.getUser_id());
                }

                if (!StringUtils.isEmpty(session.getUser_code())) {
                    usercode = session.getUser_code();
                }

                if (!StringUtils.isEmpty(session.getPostid())) {
                    postid = session.getPostid();
                }

                Map<String, Object> exportlog = new HashMap<String, Object>();
                exportlog.put("opdate", new Date());
                exportlog.put("userid", userid);
                exportlog.put("usercode", usercode);
                exportlog.put("postid", postid);
                exportlog.put("moduleid", modulecode);
                exportlog.put("param", param);
                exportlog.put("total", dataNum);
                exportlog.put("expfilename", fileName);
                logger.info(exportlog.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
