
package com.efuture.ocp.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

import com.efuture.ocp.common.component.BasicComponent;

/**
 * 获取全局参数
 * 
 * @author zhouwudong
 *
 */

public class GlobParaEnt extends BasicComponent {

	private Map<String, String> globpara = new HashMap<String, String>();
	private Map<String, Map<String, String>> globparabytype = new HashMap<String, Map<String, String>>();
	private boolean ibinit = false;

	// 取数据
	public static String getvalue(long ent_id, String paraname) {
		return SpringBeanFactory.getBean("globpara", GlobParaEnt.class).get(ent_id, paraname);
	}

	public static String getvalue(long ent_id, String paraname, String defaultvalue) {
		String value = SpringBeanFactory.getBean("globpara", GlobParaEnt.class).get(ent_id, paraname);
		if (StringUtils.isEmpty(value)) {
			return defaultvalue;
		} else {
			return value;
		}
	}

	// 初始化数据，第一次使用时初始化。
	public String get(long ent_id, String paraname) {
		if (!ibinit) {
			init();
		}
		String rtn = globpara.get(Long.toString(ent_id) + paraname);
		// 如果按企业取不到，则取0企业的参数
		if (StringUtils.isEmpty(rtn)) {
			return globpara.get("0" + paraname);
		} else {
			return rtn;
		}
	}
	
	
	// 使用synchronized 作为同步锁，保证只有一个进程读取初始化的数据。
	private synchronized void init() {
		if (!ibinit) {
			Criteria criteria = Criteria.where("1").is("1");
			Query query = new Query(criteria);
			List<Map<String, Object>> list = this.getStorageOperations().select(query, "globpara");
			globpara.clear();
			for (int i = 0; i < list.size(); i++) {
				String glid = (String) list.get(i).get("id");
				String glvalue = (String) list.get(i).get("value");
				String ent_id = (String) list.get(i).get("ent_id");
				globpara.put(ent_id.concat(glid), glvalue);
			}
			ibinit = true;
		}
	}

	// 初始化指定参数
	private synchronized void init(String id) {
		if (!ibinit) {
			Criteria criteria = Criteria.where("1").is("1").and("id").is(id);
			Query query = new Query(criteria);
			List<Map<String, Object>> list = this.getStorageOperations().select(query, "globpara");
			for (int i = 0; i < list.size(); i++) {
				String glvalue = (String) list.get(i).get("value");
				String ent_id = (String) list.get(i).get("ent_id");
				globpara.put(ent_id.concat(id), glvalue);
				if (list.get(i).containsKey("paratype") && list.get(i).get("paratype") != null) {
					String typestr = list.get(i).get("paratype").toString();
					Map<String, String> typemap = globparabytype.get(typestr);
					if (typemap != null) {
						typemap = new HashMap<String, String>();
					}
					typemap.put(ent_id.concat(id), glvalue);
				}
			}
			ibinit = true;
		}
	}

	/**
	 * 刷新全局参数
	 */
	public void doreflush() {
		ibinit = false;
		init();
	}

	/**
	 * 刷新全局参数,指定参数
	 */
	public void doreflush(String id) {
		ibinit = false;
		init(id);
	}

	/**
	 * 刷新全局参数
	 * 
	 * @return
	 */
	public static String reflush() {
		SpringBeanFactory.getBean("globpara", GlobParaEnt.class).doreflush();
		return "OK";
	}

	// 刷新全局参数,指定参数
	public static String reflush(String id) {
		SpringBeanFactory.getBean("globpara", GlobParaEnt.class).doreflush(id);
		return "OK";

	}

}
