/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.annotation;

import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.annotation.AutoCacheKeyHandle;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.distributedLock.DistributedLockHandle;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class AutoCacheAspect {
    private static final Logger logger = Logger.getLogger(AutoCacheAspect.class);
    @Autowired
    DistributedLockHandle dLockSrv;
    @Autowired
    AutoCacheKeyHandle keyHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="@annotation(around)")
    public Object round(ProceedingJoinPoint point, AutoCache around) throws Throwable {
        String lockKey;
        String className = point.getTarget().getClass().getSimpleName();
        String methodName = point.getSignature().getName();
        long starttime = System.currentTimeMillis();
        String cacheKey = this.keyHandle.getCacheKey(point, around);
        Object result = CacheUtils.getCacheUtils(around.CacheLevel()).getData(cacheKey);
        if (!StringUtils.isEmpty((Object)result)) {
            if (!"NULL".equals(result)) return result;
            return null;
        }
        String string = lockKey = cacheKey.concat("-LOCK");
        synchronized (string) {
            try {
                if (!"MEM".equalsIgnoreCase(around.CacheLevel())) {
                    this.dLockSrv.tryLock(lockKey, 60, 1000);
                    result = com.efuture.ocp.common.util.CacheUtils.getCacheUtils(around.CacheLevel()).getData(cacheKey);
                    if (!StringUtils.isEmpty((Object)result)) {
                        if ("NULL".equals(result)) {
                            result = null;
                        }
                        Object object = result;
                        return object;
                    }
                }
                if (StringUtils.isEmpty((Object)(result = point.proceed()))) {
                    CacheUtils.getCacheUtils(around.CacheLevel()).putData(cacheKey, "NULL", 3600);
                } else {
                    int timeout = around.TimeOut() + (int)Math.round(Math.random() * 360.0);
                    CacheUtils.getCacheUtils(around.CacheLevel()).putData(cacheKey, result, timeout);
                    if (!around.Readable()) return result;
                    String readKey = cacheKey.concat("-READABLE");
                    CacheUtils.getCacheUtils(around.CacheLevel()).putDataText(readKey, result.toString(), timeout);
                }
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                if (!"MEM".equalsIgnoreCase(around.CacheLevel())) {
                    this.dLockSrv.unlock(lockKey);
                }
            }
            return result;
        }
    }
}

