/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.rest;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.DateUtils;
import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.NetworkUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class ServiceVersion {
    Logger logger = Logger.getLogger(ServiceVersion.class);
    boolean logstatus;
    String logformat;
    String ver;
    String sinceTime = DateUtils.getNowStr();
    Map<String, JSONObject> elapsed = new TreeMap<String, JSONObject>();
    long[] elapsedStep = new long[]{200L, 300L, 500L, 1000L, 3000L, 5000L};
    String[] elapsedKeys = new String[]{"<=200", "200-300", "300-500", "500-1000", "1000-3000", "3000-5000", ">5000"};
    DecimalFormat df = new DecimalFormat(",###");

    public String getLogFormat() {
        if (this.logformat == null) {
            return "default";
        }
        return this.logformat;
    }

    public void setLogFormat(String logFormat) {
        this.logformat = logFormat;
    }

    public ServiceVersion(String version, String openlog) {
        this.ver = version;
        this.logstatus = openlog.equalsIgnoreCase("y");
        this.setLogFormat("default");
    }

    public ServiceVersion(String version, String openlog, String logformat) {
        this.ver = version;
        this.logstatus = openlog.equalsIgnoreCase("y");
        this.setLogFormat(logformat);
    }

    public ServiceVersion(String version) {
        this.ver = version;
    }

    public String getVer() {
        return this.ver;
    }

    public boolean isLogstatus() {
        return this.logstatus;
    }

    public void setLogstatus(boolean logstatus) {
        this.logstatus = logstatus;
    }

    public void debugLog(Object message) {
        if (this.logstatus) {
            this.logger.info(message);
        }
    }

    public Map<String, JSONObject> getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(Map<String, JSONObject> elapsed) {
        this.elapsed = elapsed;
    }

    private String formatNumber(String num) {
        if (StringUtils.isEmpty((Object)num)) {
            return "&nbsp;";
        }
        return this.df.format(new BigDecimal(num));
    }

    private String getHostPort() {
        String result = "";
        try {
            result = result.concat(NetworkUtils.getLocalIP());
        }
        catch (Exception ex) {
            result = result.concat("0.0.0.0");
        }
        try {
            result = result.concat(":").concat(NetworkUtils.getLocalPort());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String printElapsed() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<style>");
        sb.append("table{border:1px solid #cad9ea;text-align:center;cellspacing:0px;cellpadding:50px} ");
        sb.append("table th{border:1px solid #cad9ea;text-align:center;cellspacing:0px;cellpadding:50px} ");
        sb.append("table tr td{border:1px solid #cad9ea;text-align:center;cellspacing:0px;cellpadding:50px} ");
        sb.append(".title{position:absolute;width:80;text-align: right;text-align-last: right;}");
        sb.append(".value{padding-left: 100;}");
        sb.append("</style>");
        sb.append("<br>");
        String[] active = EnviromentUtil.getEnv().getActiveProfiles();
        if (active != null && active.length > 0) {
            sb.append("<div class='title'>Active :</div><div class='value'>").append(active[0]).append("</div>");
        }
        sb.append("<div class='title'>IPAddr :</div><div class='value'>").append(this.getHostPort()).append("</div>");
        sb.append("<div class='title'>Since :</div><div class='value'>").append(this.sinceTime).append("</div>");
        sb.append("<TABLE>");
        boolean printHeader = false;
        for (Map.Entry<String, JSONObject> entry : this.elapsed.entrySet()) {
            if (!printHeader) {
                sb.append("<tr style='background-color: #CCE8EB;'>");
                sb.append("<td rowspan=2>\u65b9\u6cd5</td>");
                sb.append("<td rowspan=2>\u8c03\u7528\u6b21\u6570</td>");
                sb.append("<td rowspan=2>\u7d2f\u8ba1\u8017\u65f6<br>(ms)</td>");
                sb.append("<td rowspan=2>\u5e73\u5747\u8017\u65f6<br>(ms)</td>");
                sb.append("<td rowspan=2>\u6700\u4f4e\u8017\u65f6<br>(ms)</td>");
                sb.append("<td rowspan=2>\u6700\u9ad8\u8017\u65f6<br>(ms)</td>");
                sb.append("<td colspan=" + String.valueOf(this.elapsedKeys.length) + ">\u5206\u6bb5\u7edf\u8ba1(\u6b21\u6570)</td>");
                sb.append("</tr><tr style='background-color: #CCE8EB'>");
                for (String s : this.elapsedKeys) {
                    sb.append("<td>");
                    sb.append(s);
                    sb.append("</td>");
                }
                sb.append("</tr><tr>");
                printHeader = true;
            } else {
                sb.append("<tr>");
            }
            sb.append("<td style='text-align:left'>" + entry.getKey() + "</td>");
            sb.append("<td>" + this.formatNumber(DataUtils.getJsonData(entry.getValue(), "num", false, "0")) + "</td>");
            sb.append("<td>" + this.formatNumber(DataUtils.getJsonData(entry.getValue(), "tot", false, "0")) + "</td>");
            sb.append("<td>" + this.formatNumber(DataUtils.getJsonData(entry.getValue(), "avg", false, "0")) + "</td>");
            sb.append("<td>" + this.formatNumber(DataUtils.getJsonData(entry.getValue(), "min", false, "0")) + "</td>");
            sb.append("<td>" + this.formatNumber(DataUtils.getJsonData(entry.getValue(), "max", false, "0")) + "</td>");
            for (String s : this.elapsedKeys) {
                sb.append("<td>");
                sb.append(this.formatNumber(DataUtils.getJsonData(entry.getValue(), s, false, "")));
                sb.append("</td>");
            }
            sb.append("</tr>");
        }
        sb.append("<TABLE>");
        return sb.toString();
    }

    public synchronized void writeElapsed(String key, long time) {
        try {
            if (time <= 0L) {
                return;
            }
            JSONObject json = this.elapsed.get(key);
            if (json == null) {
                json = new JSONObject();
                json.put("num", (Object)1);
                json.put("tot", (Object)time);
                json.put("avg", (Object)time);
                json.put("min", (Object)time);
                json.put("max", (Object)time);
                this.elapsed.put(key, json);
            } else {
                json.put("num", (Object)(json.getLong("num") + 1L));
                json.put("tot", (Object)(json.getLong("tot") + time));
                json.put("avg", (Object)(json.getLong("tot") / json.getLong("num")));
                json.put("min", (Object)Math.min(json.getLong("min"), time));
                json.put("max", (Object)Math.max(json.getLong("max"), time));
            }
            boolean exist = false;
            for (int i = 0; i < this.elapsedStep.length; ++i) {
                String str;
                if (time > this.elapsedStep[i]) continue;
                String string = str = i > 0 ? this.elapsedStep[i - 1] + "-" + this.elapsedStep[i] : "<=" + this.elapsedStep[i];
                if (json.containsKey((Object)str)) {
                    json.put(str, (Object)(json.getLong(str) + 1L));
                } else {
                    json.put(str, (Object)1);
                }
                exist = true;
                break;
            }
            if (!exist) {
                String str = ">" + this.elapsedStep[this.elapsedStep.length - 1];
                if (json.containsKey((Object)str)) {
                    json.put(str, (Object)(json.getLong(str) + 1L));
                } else {
                    json.put(str, (Object)1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void cleanElapsed() throws Exception {
        this.elapsed.clear();
    }

    public static ServiceVersion getInstance() {
        ServiceVersion sv = SpringBeanFactory.getBean("ServiceVersion", ServiceVersion.class);
        return sv;
    }

    public static String getVersion() {
        return ServiceVersion.getInstance().getVer();
    }
}

