/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UUID {
    private static Map<String, String> IPS = new HashMap<String, String>();
    private static String port = "";
    private static String ipAddr0 = "000";
    private static String ipAddr1 = "000";
    private static String ip = "";
    private static long twepoch = 1451577600000L;
    private static int splitStart = 2010;
    private static int splitEnd = 2020;
    private static long workerIdBits = 8L;
    private static long processIdBits = 8L;
    private static long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)workerIdBits;
    private static long maxProcessId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)processIdBits;
    private static long sequenceBits;
    private static long workerIdShift;
    private static long processIdShift;
    private static long timestampLeftShift;
    private static long sequenceMask;
    private static final long MAX_BACKWARD_MILLS = 5L;
    private static Long workerId;
    private static Long processId;
    private static List<Long> BACKWARD;
    private static int BACKWARD_SIZE;
    private static Map<String, WorkerId> allIds;
    private static List<String> ENV_APPID;
    private static List<String> ENV_PREFIX;
    private static List<String> ENV_START;
    private static final int INADDR4SZ = 4;
    public static Logger logger;

    public static UUID getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static String getEnv(String key) {
        String val = System.getProperty(key);
        if (val == null) {
            val = System.getenv(key);
        }
        if (val == null) {
            val = "";
        }
        val = val.trim();
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getId(String key) {
        WorkerId workerId = allIds.get(key);
        if (workerId == null) {
            Map<String, WorkerId> map = allIds;
            synchronized (map) {
                workerId = allIds.get(key);
                if (workerId == null) {
                    UUID.initId();
                    workerId = UUID.getInstance().getWorkerId();
                    allIds.put(key, workerId);
                }
            }
        }
        return workerId.value();
    }

    private static void initId() {
        String key;
        Object val;
        if (workerId != null) {
            return;
        }
        for (String key2 : ENV_APPID) {
            val = UUID.getEnv(key2);
            if (((String)val).isEmpty()) continue;
            if (((String)val).length() > 3) {
                val = ((String)val).substring(((String)val).length() - 3);
            }
            workerId = Long.valueOf((String)val);
            processId = 0L;
            return;
        }
        String port = UUID.parsePath();
        String prefixId = "";
        val = ENV_PREFIX.iterator();
        while (val.hasNext() && (prefixId = UUID.getEnv(key = (String)val.next())).isEmpty()) {
        }
        String[] addr = UUID.getIpAddr(prefixId);
        if (port == null || "".equals(port)) {
            workerId = Long.valueOf(addr[2]);
            processId = Long.valueOf(addr[1]);
        } else {
            if (port.length() > 2) {
                port = port.substring(port.length() - 2);
            }
            workerId = Long.valueOf(addr[2]);
            processId = Long.valueOf(port);
        }
        logger.warn("workerId:[" + workerId + "], processId:[" + processId + "]");
    }

    private static String parsePath() {
        String path = UUID.getPath();
        String regex = "\\d+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(path);
        while (matcher.find()) {
            String s = matcher.group();
            if (s.length() <= 3) continue;
            port = matcher.group();
        }
        port = port != null && port.length() > 3 ? port.substring(port.length() - 4) : null;
        logger.warn("port:[" + port + "]");
        return port;
    }

    public static String getPath() {
        String cpath = null;
        ClassLoader cl = UUID.getDefaultClassLoader();
        URL url = cl != null ? cl.getResource("") : ClassLoader.getSystemResource("");
        File sp = UUID.getFile(url);
        File fp = new File(sp.getAbsolutePath());
        while (!fp.exists() || !fp.isDirectory()) {
            fp = fp.getParentFile();
        }
        cpath = fp.getPath();
        cpath = cpath.replace('\\', '/').toLowerCase();
        logger.warn("path:[" + cpath + "]");
        return cpath;
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = UUID.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static File getFile(URL resourceUrl) {
        try {
            return new File(UUID.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    private static URI toURI(URL url) throws URISyntaxException {
        return new URI(url.toString().replace(" ", "%20"));
    }

    public static String getHostname() {
        try {
            InetAddress netAddress = InetAddress.getLocalHost();
            return netAddress.getHostName();
        }
        catch (UnknownHostException e) {
            logger.warn("\u8b66\u544a:getLocalHost\u7cfb\u7edf\u83b7\u53d6hostname\u5f02\u5e38:" + UUID.getTrace(e));
            return null;
        }
    }

    public static String[] getIpAddr(String prefix) {
        try {
            InetAddress lo = InetAddress.getLocalHost();
            if (!lo.isAnyLocalAddress() && !lo.isLoopbackAddress() && lo instanceof Inet4Address) {
                String key = lo.getHostAddress();
                IPS.put(key, lo.getHostName());
                if (key.startsWith(prefix)) {
                    ip = key;
                }
            }
        }
        catch (UnknownHostException e) {
            logger.warn("\u8b66\u544a:getLocalHost\u7cfb\u7edf\u83b7\u53d6IP\u5730\u5740\u5f02\u5e38:" + UUID.getTrace(e));
        }
        if ("".equals(ip)) {
            try {
                Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
                block4: for (NetworkInterface netint : Collections.list(nets)) {
                    if (netint.isLoopback() || !netint.isUp() || netint.isVirtual() || netint.isPointToPoint()) continue;
                    List<InterfaceAddress> netips = netint.getInterfaceAddresses();
                    for (InterfaceAddress addr : netips) {
                        InetAddress ia = addr.getAddress();
                        if (!(ia instanceof Inet4Address)) continue;
                        String key = ia.getHostAddress();
                        IPS.put(key, ia.getHostName());
                        if (!UUID.isInternalIp(key) || !key.startsWith(prefix)) continue;
                        ip = key;
                        continue block4;
                    }
                }
            }
            catch (SocketException e) {
                logger.warn("\u8b66\u544a:\u7cfb\u7edf\u83b7\u53d6IP\u5730\u5740\u5f02\u5e38," + UUID.getTrace(e));
            }
        }
        String[] rtn = null;
        String[] address = null;
        if ("".equals(ip)) {
            IPS.put("127.0.0.1", "localhost");
            IPS.put("0.0.0.0", "localhost");
            for (String key : IPS.keySet()) {
                if (!UUID.isIpv4(key) || !UUID.isInternalIp(key) || !key.startsWith(prefix)) continue;
                ip = key;
                break;
            }
            if ("".equals(ip) || "0.0.0.0".equals(ip)) {
                for (String key : IPS.keySet()) {
                    if (!UUID.isIpv4(key) || !key.startsWith(prefix)) continue;
                    ip = key;
                    break;
                }
            }
            if ("".equals(ip)) {
                ip = "127.0.0.1";
            }
        }
        address = ip.split("\\.");
        ipAddr0 = address[3];
        ipAddr1 = address[2];
        rtn = new String[]{ip, String.format("%03d", Integer.parseInt(ipAddr1)), String.format("%03d", Integer.parseInt(ipAddr0))};
        logger.warn("ip \u5730\u5740[" + rtn[0] + "], [" + rtn[1] + "], [" + rtn[2] + "]");
        return rtn;
    }

    private static boolean isIpv4(String ip) {
        return ip.indexOf(46) != -1;
    }

    private static boolean isInternalIp(String ip) {
        byte[] addr = UUID.textToNumericFormatV4(ip);
        return UUID.isInternalIp(addr);
    }

    private static boolean isInternalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static byte[] textToNumericFormatV4(String src) {
        if (src.length() == 0) {
            return null;
        }
        byte[] res = new byte[4];
        String[] s = src.split("\\.", -1);
        try {
            switch (s.length) {
                case 1: {
                    long val = Long.parseLong(s[0]);
                    if (val < 0L || val > 0xFFFFFFFFL) {
                        return null;
                    }
                    res[0] = (byte)(val >> 24 & 0xFFL);
                    res[1] = (byte)((val & 0xFFFFFFL) >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 2: {
                    long val = Integer.parseInt(s[0]);
                    if (val < 0L || val > 255L) {
                        return null;
                    }
                    res[0] = (byte)(val & 0xFFL);
                    val = Integer.parseInt(s[1]);
                    if (val < 0L || val > 0xFFFFFFL) {
                        return null;
                    }
                    res[1] = (byte)(val >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 3: {
                    long val;
                    for (int i = 0; i < 2; ++i) {
                        val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    val = Integer.parseInt(s[2]);
                    if (val < 0L || val > 65535L) {
                        return null;
                    }
                    res[2] = (byte)(val >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
        return res;
    }

    public static String getTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    public static Logger getLogger() {
        return logger;
    }

    public WorkerId getWorkerId() {
        WorkerId b = new WorkerId();
        return b;
    }

    static {
        workerIdShift = sequenceBits = 6L;
        processIdShift = sequenceBits + workerIdBits;
        timestampLeftShift = sequenceBits + workerIdBits + processIdBits;
        sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)sequenceBits;
        BACKWARD = new ArrayList<Long>();
        BACKWARD_SIZE = 0;
        allIds = new HashMap<String, WorkerId>();
        ENV_APPID = new ArrayList<String>();
        ENV_PREFIX = new ArrayList<String>();
        ENV_START = new ArrayList<String>();
        ENV_APPID.add("GLOBAL_APPID");
        ENV_APPID.add("COMMON_APPID");
        ENV_START.add("GLOBAL_TIME_SET");
        ENV_START.add("COMMON_TIME_SET");
        ENV_PREFIX.add("GLOBAL_APPID_PREFIX");
        ENV_PREFIX.add("COMMON_APPID_PREFIX");
        Calendar calendar = Calendar.getInstance();
        calendar.set(splitStart, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        twepoch = calendar.getTimeInMillis();
        for (int i = splitStart; i < splitEnd; ++i) {
            calendar.set(i, 0, 1, 0, 0, 0);
            calendar.set(14, 0);
            BACKWARD.add(calendar.getTimeInMillis());
        }
        BACKWARD_SIZE = BACKWARD.size();
        logger = new Logger();
    }

    class WorkerId {
        private long sequence = 0L;
        private long lastTimestamp = -1L;
        private int backupStep = 0;

        WorkerId() {
        }

        public synchronized long value() {
            long curTimestamp = this.timeGen();
            boolean isBackup = false;
            if (curTimestamp < this.lastTimestamp) {
                long offset = this.lastTimestamp - curTimestamp;
                while (offset > 0L && offset <= 5L) {
                    try {
                        Thread.sleep(offset);
                        curTimestamp = this.timeGen();
                        offset = this.lastTimestamp - curTimestamp;
                        if (offset <= 5L && offset >= 0L) continue;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
                if (offset > 5L) {
                    isBackup = true;
                }
            }
            if (this.lastTimestamp == curTimestamp) {
                this.sequence = this.sequence + 1L & sequenceMask;
                if (this.sequence == 0L) {
                    curTimestamp = this.tilNextMillis(this.lastTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            if (isBackup) {
                this.backupStep %= BACKWARD.size();
                curTimestamp = this.tilMoveMillis(curTimestamp);
            } else {
                this.lastTimestamp = curTimestamp;
            }
            return curTimestamp - twepoch << (int)timestampLeftShift | processId << (int)processIdShift | workerId << (int)workerIdShift | this.sequence;
        }

        protected long tilNextMillis(long lastTimestamp) {
            long timestamp = this.timeGen();
            while (timestamp <= lastTimestamp) {
                timestamp = this.timeGen();
            }
            return timestamp;
        }

        protected long timeGen() {
            return System.currentTimeMillis();
        }

        protected long tilMoveMillis(long curTimestamp) {
            Calendar r = Calendar.getInstance();
            r.setTimeInMillis(curTimestamp);
            r.set(r.get(1), 0, 1, 0, 0, 0);
            r.set(14, 0);
            long subMills = curTimestamp - r.getTimeInMillis();
            this.backupStep %= BACKWARD.size();
            curTimestamp = (Long)BACKWARD.get(this.backupStep) + subMills;
            ++this.backupStep;
            return curTimestamp;
        }
    }

    private static class Logger {
        private Logger() {
        }

        public void info(String msg) {
            int level = 1;
            StackTraceElement[] stacks = new Throwable().getStackTrace();
            int line = stacks[level].getLineNumber();
            System.out.println(String.format("%4d-%s", line, msg));
        }

        public void warn(String msg) {
            int level = 1;
            StackTraceElement[] stacks = new Throwable().getStackTrace();
            int line = stacks[level].getLineNumber();
            System.out.println(String.format("%4d-%s", line, msg));
        }
    }

    private static class LazyHolder {
        private static final UUID INSTANCE = new UUID();

        private LazyHolder() {
        }
    }
}

