package com.efuture.ocp.common.annotation;

import java.util.Map;

import com.efuture.ocp.common.distributedLock.DistributedLockHandle;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONObject;
//import com.efuture.ocp.common.redis.DistributedRedisLock;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.util.MD5Utils;

@Aspect
@Component
public class AutoCacheAspect
{
    private static final Logger logger = Logger.getLogger(AutoCacheAspect.class);
    @Autowired
    DistributedLockHandle dLockSrv;
    @Autowired
    AutoCacheKeyHandle keyHandle;

    @Around("@annotation(around)")
    public Object round(ProceedingJoinPoint point, AutoCache around) throws Throwable
    {
        String className = point.getTarget().getClass().getSimpleName();
        String methodName = point.getSignature().getName();
        long starttime = System.currentTimeMillis();
        String cacheKey = keyHandle.getCacheKey(point, around);
        Object result = CacheUtils.getCacheUtils(around.CacheLevel()).getData(cacheKey);

        if (!StringUtils.isEmpty(result)) {
            if ("NULL".equals(result)) {
                result = null;
            }

            return result;
        }

        String lockKey = cacheKey.concat( "-LOCK" );

        // 2020.8.16 兼容内存级别缓存
        synchronized (lockKey) {
            try {
                // 2020.4.30 开启缓存后的读取全局锁，避免缓存击穿
                if (!CacheUtils.CacheLevel.Memory.equalsIgnoreCase( around.CacheLevel() )) {
                    dLockSrv.tryLock( lockKey, 60, 1000 );
                    result = com.efuture.ocp.common.util.CacheUtils.getCacheUtils( around.CacheLevel() ).getData( cacheKey );

                    if (!StringUtils.isEmpty( result )) {
                        if ("NULL".equals( result )) {
                            result = null;
                        }

                        return result;
                    }
                }

                result = point.proceed();

                if (StringUtils.isEmpty( result )) {
                    CacheUtils.getCacheUtils( around.CacheLevel() ).putData( cacheKey, "NULL", CacheUtils.CacheTimeOut.Hour );
                }
                else {
                    int timeout = around.TimeOut() + (int) Math.round( Math.random() * 360 );
                    CacheUtils.getCacheUtils( around.CacheLevel() ).putData( cacheKey, result, timeout );

                    if (around.Readable()) {
                        String readKey = cacheKey.concat( "-READABLE" );
                        CacheUtils.getCacheUtils( around.CacheLevel() ).putDataText( readKey, result.toString(), timeout );
                    }
                }
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                if (!CacheUtils.CacheLevel.Memory.equalsIgnoreCase( around.CacheLevel() )) {
                    dLockSrv.unlock( lockKey );
                }
            }
        }

        return result;
    }

}
