package com.efuture.ocp.common.annotation;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.MD5Utils;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Map;

//import com.efuture.ocp.common.redis.DistributedRedisLock;

@Aspect
@Component
public class AutoCacheEvictAspect
{
    private static final Logger logger = Logger.getLogger( AutoCacheEvictAspect.class);

    @Autowired
    AutoCacheKeyHandle keyHandle;

    @Around("@annotation(around)")
    public Object round(ProceedingJoinPoint point, AutoCacheEvict around) throws Throwable
    {
        String cacheKey = keyHandle.getCacheKey(point, around);

        try {
            int result = CacheUtils.getCacheUtils(around.CacheLevel()).deleteBatch( cacheKey );
            return point.proceed();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {

        }
    }

}
