/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	ExampleComponent.java
 * Author:		亮
 * Date:		2014-3-27 上午10:24:07
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.BeanConstant;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FStorageOperations;

/**
 * @author		亮
 * @description	服务组件示例
 * 
 */
public class ExampleComponent extends BasicComponent
{
    // 该方法为API方法的通用模板,可参考BrandServiceImpl的add方法
    public ServiceResponse serviceTemplate(ServiceSession session,JSONObject jsonparam) throws Exception
    {
        try
        {
            // 参数检查
            if (session == null) return ServiceResponse.buildFailure(session,ResponseCode.Exception.SESSION_IS_EMPTY);
            if (StringUtils.isEmpty(jsonparam)) return ServiceResponse.buildFailure(session,ResponseCode.Exception.PARAM_IS_EMPTY); 
            
            // 在这里加入实际业务处理
            doServiceTemplate(jsonparam);
            
            // 返回应答对象
            JSONObject respdata = new JSONObject();
            return ServiceResponse.buildSuccess(respdata);
        }
        catch(ServiceException ex)
        {
            this.getLogger().error(ex.getMessage(),ex);
            return ServiceResponse.buildFailure(session,ex.getErrorCode(),ex.getMessage(),ex.getErrorArgs());
        }
    }
        
    // 服务分层,方便内部API之间进行调用
    public Object doServiceTemplate(Object param) throws Exception
    {
        FStorageOperations storage = null;
        try
        {
            // 参数验证
            AbstractEntityBean.validateBean(param);
            
            // 得到数据源
            storage = getStorageOperations();           
            
            // 加入业务处理
            throw new ServiceException(ResponseCode.FAILURE, "error");
        }
        finally
        {
            if (storage != null) storage.destroy();
        }
    }
    
	/* 以下四种为服务组件方法的反射顺序,可以选择以下任意一种方式作为服务方法的入口  */
	public Object exampleService(ServiceSession session,JSONObject jsonparam) throws Exception
	{
		try
		{
			// 在这里加入业务处理
			StringBuffer sb = new StringBuffer();
			sb.append(this.getClass().getName()+"(ServiceSession,JSONObject)\n");
			sb.append("\nsession:\n");
			sb.append(JSON.toJSONString(session)+"\n");
			sb.append("\njsonparam:\n");
			sb.append(jsonparam.toJSONString()+"\n");
			if (jsonparam.containsKey("locale") && jsonparam.containsKey("code"))
			{
				sb.append("\nmsg:\n");			
				sb.append(MessageSourceHelper.getDefault().getMessage(jsonparam.getString("code"), null, null, new Locale(jsonparam.getString("locale")))+"\n");
			}
			
			// 返回应答对象
			return ServiceResponse.buildSuccess(sb.toString());
		}
		catch(Exception ex)
		{
			this.getLogger().error(ex.getMessage(),ex);
			return Utils.getLastExceptionMessage(ex);
		}
	}
	
	public Object exampleService(ServiceSession session,String param) throws Exception
	{
		try
		{
			StringBuffer sb = new StringBuffer();
			sb.append(this.getClass().getName()+"(ServiceSession,String)\n");
			sb.append("\nsession:\n");
			sb.append(JSON.toJSONString(session)+"\n");
			sb.append("\nparam:\n");
			sb.append(param+"\n");
			return sb.toString();
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw ex;
		}
	}
	
	public Object exampleService(String param) throws Exception
	{
		try
		{
			StringBuffer sb = new StringBuffer();
			sb.append(this.getClass().getName()+"(String)\n");
			sb.append("\nparam:\n");
			sb.append(param+"\n");
			sb.append("\nmsg:\n");
			sb.append(MessageSourceHelper.getDefault().getMessage(param, null, null, null)+"\n");
			return sb.toString();
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw ex;
		}
	}
	
	public Object exampleService() throws Exception
	{
		try
		{
			StringBuffer sb = new StringBuffer();
			sb.append(this.getClass().getName()+"(void)\n");
			return sb.toString();
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw ex;
		}
	}
	
    public Object exampleImport(ServiceSession session, String param, List<FileImportObject> list) throws Exception
    {
        System.out.println("param: " + param);
        for (FileImportObject fio : list)
        {
            System.out.println("filename: " + fio.getFilename());
            byte[] b = new byte[100];
            fio.getStream().read(b, 0, 100);
            System.out.println("fileline: " + new String(b));
        }
        return list.size();
    }
	    	   
    public String exampleExport(ServiceSession session,JSONObject jsonparam) throws Exception
    {
        // 参数检查
        if (session == null) throw new ServiceException(ResponseCode.Exception.SESSION_IS_EMPTY,"session is empty");
        if (StringUtils.isEmpty(jsonparam)) throw new ServiceException(ResponseCode.Exception.PARAM_IS_EMPTY,"param is empty"); 
        
        // 导出必须指定字段
        if (StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_FIELDS))) throw new ServiceException(ResponseCode.EXCEPTION,"{0} {1} is empty","",BeanConstant.QueryField.PARAMKEY_FIELDS);

        // 解析字段名
        // fields="fld1:XXXX:fmt,fld2:XXXXX:fmt,fld3:XXXXX:fmt";
        StringBuffer flds = new StringBuffer();
        List<String> fldlst = new ArrayList<String>();
        Map<String,String> disps = new HashMap<String,String>();
        Map<String,String> fmts = new HashMap<String,String>();
        analyzeExportFields(jsonparam.getString(BeanConstant.QueryField.PARAMKEY_FIELDS),flds,fldlst,disps,fmts);
        jsonparam.put(BeanConstant.QueryField.PARAMKEY_FIELDS,flds.toString());
        
        // 查询数据            
        List<Map<String,Object>> list = null;
                
        // 生成XLS文件的XML
        return createExportXLS(list,fldlst,disps,fmts);
    }
}
