package com.efuture.ocp.common.rest.taobao;

import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.util.MD5Utils;
import com.efuture.ocp.common.util.Utils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;


public class SpiUtils {

    public static CheckResult checkSign(HttpServletRequest request, String secret, String body, String datafmt) throws IOException {
        CheckResult result = new CheckResult();

        String sm = request.getParameter("sign_method");
        if (!StringUtils.isEmpty(sm) && sm.equals("DEMO"))
        {
            result.setSuccess(true);
            return result;
        }
        String ctype = request.getContentType();
        String charset = Utils.getResponseCharset(ctype);

        //DEBUG
        //ServiceVersion.getInstance().debugLog("ContentType=".concat(ctype));
        //ServiceVersion.getInstance().debugLog("CharSet=".concat(charset));
        //ServiceVersion.getInstance().debugLog("DataFmt=".concat(datafmt));
        //DEBUG END

        if ((ctype.startsWith("application/json")) || (ctype.startsWith("text/xml")) || (ctype.startsWith("text/plain"))) {
            //String body = Utils.getStreamAsString(request.getInputStream(), charset);
            //改成终端传入
            boolean valid;
            if (datafmt.equalsIgnoreCase("FORM"))
            {
                Map<String, String> form = Utils.UrlToMap(body);
                //ServiceVersion.getInstance().debugLog("checkSign FORM Mode: body=" + body + ", formStr=" + getParamStrFromMap(form));
                valid = checkSignInternal(request, form, null, secret, charset);
            }
            else
            {
                //ServiceVersion.getInstance().debugLog("checkSign JSON Mode: body=" + body);
                valid = checkSignInternal(request, null, body, secret, charset);
            }
            result.setSuccess(valid);
            result.setRequestBody(body);
        } else if (ctype.startsWith("application/x-www-form-urlencoded")) {
            //boolean valid = checkSignInternal(request, null, null, secret, charset);
            boolean valid;
            if (datafmt.equalsIgnoreCase("FORM"))
            {
                Map<String, String> form = Utils.UrlToMap(body);
                //ServiceVersion.getInstance().debugLog("checkSign FORM/urlencoded Mode: body=" + body + ", formStr=" + getParamStrFromMap(form));
                valid = checkSignInternal(request, form, null, secret, charset);
            }
            else
            {
                //ServiceVersion.getInstance().debugLog("checkSign JSON/urlencoded Mode: body=" + body);
                valid = checkSignInternal(request, null, null, secret, charset);
            }
            result.setSuccess(valid);
        } else {
            throw new RuntimeException("Unspported SPI request");
        }
        return result;
    }

    private static boolean checkSignInternal(HttpServletRequest request, Map<String, String> form, String body,
                                             String secret, String charset) throws IOException {
        Map params = new HashMap();

        Map headerMap = getHeaderMap(request, charset);
        params.putAll(headerMap);

        Map queryMap = getQueryMap(request, charset);
        params.putAll(queryMap);

        if ((form == null) && (body == null)) {
            Map formMap = getFormMap(request, queryMap);
            params.putAll(formMap);
        } else if (form != null) {
            params.putAll(form);
        }

        String remoteSign = (String) queryMap.get("sign");
        String localSign = sign(params, body, secret, charset);
        if (localSign.equals(remoteSign)) {
            return true;
        }
        String paramStr = getParamStrFromMap(params);
        ServiceVersion.getInstance().debugLog("checkTopSign error^_^remoteSign=" + remoteSign + "^_^localSign=" + localSign + "^_^paramStr="+ paramStr + "^_^body=" + body);
        return false;
    }

    public static Map<String, String> getHeaderMap(HttpServletRequest request, String charset) throws IOException {
        Map headerMap = new HashMap();
        String signList = request.getHeader("top-sign-list");
        if (!StringUtils.isEmpty(signList)) {
            String[] keys = signList.split(",");
            for (String key : keys) {
                String value = request.getHeader(key);
                if (StringUtils.isEmpty(value))
                    headerMap.put(key, "");
                else {
                    headerMap.put(key, URLDecoder.decode(value, charset));
                }
            }
        }
        return headerMap;
    }

    public static Map<String, String> getQueryMap(HttpServletRequest request, String charset) throws IOException {
        Map queryMap = new HashMap();
        String queryString = request.getQueryString();
        String[] params = queryString.split("&");
        for (int i = 0; i < params.length; i++) {
            String[] kv = params[i].split("=");
            if (kv.length == 2) {
                String key = URLDecoder.decode(kv[0], charset);
                String value = URLDecoder.decode(kv[1], charset);
                queryMap.put(key, value);
            } else if (kv.length == 1) {
                String key = URLDecoder.decode(kv[0], charset);
                queryMap.put(key, "");
            }
        }
        return queryMap;
    }

    public static Map<String, String> getFormMap(HttpServletRequest request, Map<String, String> queryMap)
            throws IOException {
        Map formMap = new HashMap();
        Set keys = request.getParameterMap().keySet();
        for (Iterator i$ = keys.iterator(); i$.hasNext();) {
            Object tmp = i$.next();
            String key = String.valueOf(tmp);
            if (!queryMap.containsKey(key)) {
                String value = request.getParameter(key);
                if (StringUtils.isEmpty(value))
                    formMap.put(key, "");
                else {
                    formMap.put(key, value);
                }
            }
        }
        return formMap;
    }

    private static String getParamStrFromMap(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        if ((params != null) && (!params.isEmpty())) {
            String[] keys = (String[]) params.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; i++) {
                String name = keys[i];
                if (!"sign".equals(name)) {
                    sb.append(name);
                    sb.append((String) params.get(name));
                }
            }
        }
        return sb.toString();
    }

    private static String sign(Map<String, String> params, String body, String secret, String charset)
            throws IOException {
        StringBuilder sb = new StringBuilder(secret);
        sb.append(getParamStrFromMap(params));
        if (body != null) {
            sb.append(body);
        }
        sb.append(secret);
        byte[] bytes = MD5Utils.encryptMD5(sb.toString().getBytes(charset));
        String signKey = MD5Utils.byte2hex(bytes);

        //ServiceVersion.getInstance().debugLog("SignStr=".concat(sb.toString()));
        //ServiceVersion.getInstance().debugLog("SignKey=".concat(signKey));

        return signKey;
    }
}