/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	CacheUtilsMemcached.java
 * Author:		亮
 * Date:		2014-9-16 下午4:50:31
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 *
 */
package com.efuture.ocp.common.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Set;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;

import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.common.util.WebPathUtils;
import net.rubyeye.xmemcached.GetsResponse;
import redis.clients.jedis.*;

import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

import com.efuture.ocp.common.SerializeUtil.SerializeUtil;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.cache.CacheUtils.CacheType;

/**
 * @author 亮
 * @description
 *
 */

public class CacheUtilsRedisSentinel extends CacheUtilsRediscached implements Serializable
{
    private JedisSentinelPool jedispool;
    private String cfgFile = null;
    private int cachetime = -1;
    private boolean debug = false;
    public Logger logger = Logger.getLogger(CacheUtilsRedisSentinel.class);

    public CacheUtilsRedisSentinel()
    {
        this(null);
    }

    public CacheUtilsRedisSentinel(String config)
    {
        this(config, -1);
    }

    public CacheUtilsRedisSentinel(String config, int cachetime)
    {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    /**
     * 往缓存赋值
     *
     * @param key
     *            键值
     * @param object
     *            值对象
     * @param timeout
     *            超时：毫秒
     * @return
     */
    private Jedis getJedis()
    {
        try {
            if (jedispool == null) {
                try {
                    jedispool = CreateJedisPool();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }


            return jedispool.getResource();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /**
     *  返回释放Jedis
     * @param jedis
     */
    private void returnJedis(Jedis jedis)
    {
        if (jedis != null) {
            try {
                jedis.close();
            }
            catch (Exception ex) {
                //do Nothing
            }
        }
    }

    /**
     * 创建redis缓存客户端
     *
     * @return Memcached客户端对象
     * @throws InvalidFileFormatException
     * @throws FileNotFoundException
     * @throws IOException
     */
    private synchronized JedisSentinelPool CreateJedisPool() throws FileNotFoundException, IOException
    {
        if (jedispool != null) {
            return jedispool;
        }

        if (this.config != null) {
            logger.info("Redis client is creating with configuration.");
            JedisPoolConfig poolConfig = new JedisPoolConfig();
//            poolConfig.setTestOnBorrow(this.config.isRedisTestOnBorrow());
            poolConfig.setMaxTotal(this.config.getRedisMaxActive());
            poolConfig.setMaxIdle(this.config.getRedisMaxIdle());
            poolConfig.setMinIdle(this.config.getRedisMinIdle());
            poolConfig.setMaxWaitMillis(this.config.getRedisMaxWait());
            Set sentinels = new HashSet<String>();
            String[] str_nodes = this.config.getRedisNodes().split( "," );

            for (String str : str_nodes) {
                sentinels.add( str );
            }
            jedispool = new JedisSentinelPool( this.config.getRedisMaster(), sentinels, poolConfig, this.config.getRedisTimeout());
//            jedispool = new JedisSentinelPool( this.config.getRedisMaster(), sentinels, poolConfig, this.config.getRedisTimeout(), this.config.getRedisPassword(),
//                                               this.config.getRedisDatabase());
        }
        else {
            // 取redis.ini中的redis服务器配置
            String ini = null, ini0 = null;

            if (StringUtils.isEmpty( cfgFile )) {
                String p = WebPathUtils.getWebRootClassPath();
                ini = p + "/redisCluster.ini"; // （原来的）
                ini0 = p + "/conf/redisCluster.ini";
                // *****************解决有的配置文件存储在/WEB-INF/classes/conf 下***********//
            }
            else {
                if (cfgFile.startsWith( "\\" ) || cfgFile.startsWith( "/" )) {
                    String p = WebPathUtils.getWebRootClassPath();
                    ini = p + cfgFile;
                    ini0 = p + "/conf" + cfgFile;
                }
                else {
                    ini = cfgFile;
                }
            }

            int maxActive = 100;
            int timeout = 5000;
            int maxIdle = 30;
            int minIdle = 10;
            boolean testOnBorrow = true;
            String nodes = "";
            String host = "localhost";
            int port = 6379;
            int database = Protocol.DEFAULT_DATABASE;
            int maxWait = 5000;
            File input = new File( ini );

            // 如果classes目录下没有查找classes/conf目录
            if (ini0 != null && !input.exists()) {
                input = new File( ini0 );
            }

            logger.info( "redisCluster.ini path:" + ini );

            if (input.exists()) {
                InputStream is = new FileInputStream( input );
                Properties p = new Properties();
                p.load( is );
                is.close();
                String sNodes = Utils.getEnvValue( p.getProperty( "redis.nodes" ) );

                if (sNodes != null) {
                    nodes = sNodes.trim();
                }

                String smaxActive = p.getProperty( "redis.maxActive" );

                if (smaxActive != null) {
                    maxActive = Integer.parseInt( smaxActive );
                }

                String stimeout = p.getProperty( "redis.timeout" );

                if (stimeout != null) {
                    timeout = Integer.parseInt( stimeout );
                }

                String smaxIdle = p.getProperty( "redis.maxIdle" );

                if (smaxIdle != null) {
                    maxIdle = Integer.parseInt( smaxIdle );
                }

                String sminIdle = p.getProperty( "redis.minIdle" );

                if (sminIdle != null) {
                    minIdle = Integer.parseInt( sminIdle );
                }

                String stestOnBorrow = p.getProperty( "redis.testOnBorrow" );

                if (stestOnBorrow != null) {
                    testOnBorrow = ((stestOnBorrow != null && stestOnBorrow.equalsIgnoreCase( "false" )) ? false : true);
                }

                String smaxWait = p.getProperty( "redis.maxWait" );

                if (smaxWait != null) {
                    maxWait = Integer.parseInt( smaxWait );
                }

                String password_prop = p.getProperty( "redis.password" );
                String password = Utils.getEnvValue( password_prop );

                if (password != null) {
                    password = password.trim();
                }

                String master = Utils.getEnvValue( p.getProperty( "redis.master" ) );
                String sdatabase = Utils.getEnvValue( p.getProperty( "redis.database" ) );

                if (sdatabase != null) {
                    database = Integer.parseInt( sdatabase );
                }

                // logger.info("rediscached server:" + host + ":" +sport + "(" + sdatabase + "):" + Utils.nvl(password_prop, "N/A") + "/" + Utils.nvl(password,"N/A"));
                logger.info( "redisSentinel server:" + sNodes );
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow( true );
                config.setMaxTotal( maxActive );
                config.setMaxIdle( maxIdle );
                config.setMinIdle( minIdle );
                config.setMaxWaitMillis( maxWait );
                Set sentinels = new HashSet<String>();
                String[] str_nodes = nodes.split( "," );

                for (String str : str_nodes) {
                    sentinels.add( str );
                }

                jedispool = new JedisSentinelPool( master, sentinels, config, timeout, password, database );
            }
            else {
                logger.warn( "redis.ini not exits!" );
                throw new FileNotFoundException();
            }
        }

        return jedispool;
    }


    @Override
    public String putData(String key, Object object, int timeout)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return null;
        }
        jedis.auth("123456");

        // set
        try {
            if (timeout < 0) {
                timeout = (cachetime > 0 ? cachetime : 0);
            }

            jedis.setex( key.getBytes(), timeout, SerializeUtil.serialize( object ) );
            return key;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            returnJedis(jedis);
        }
    }

    /**
     * 缓存取值
     *
     * @param key
     *            键值
     * @return
     */
    @Override
    public Object getData(String key)
    {
        Jedis jedis = getJedis();

        if (jedis == null) {
            return null;
        }
        jedis.auth("123456");

        // get
        Object result = null;

        try {
            byte[] obj = jedis.get((key).getBytes());
            result = SerializeUtil.unserialize(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            returnJedis(jedis);
        }

        return result;
    }

}
