package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.proxy.EnterpriseProxy;
import com.efuture.ocp.common.util.MD5Utils;
import com.efuture.ocp.common.util.RestClientUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @title: RestClientUtils_MSS
 * @description: TODO
 * @author: wangf
 * @date: 2020/04/23
 */

@Lazy(true)
@Component("RestClientUtils_MSS")
public class RestClientUtils_MSS extends RestClientUtils
{

    /**
     * 按照openapi的要求加上签名
     *
     * @param session 企业会话
     * @param method  请求方法
     * @param url     请求地址
     * @param param   输入参数
     */
    @Override
    public Map<String, Object> doOverWrite(Object session, String method, String url, Object param) throws Exception
    {
        if (!method.startsWith("http")) {
            return super.doOverWrite(session, method, url, param);
        }
        else {
            long entId = 0L;

            if (session != null && session instanceof ServiceSession) {
                entId = ((ServiceSession) session).getEnt_id();
            }
            else if (session != null && session instanceof Long) {
                entId = (Long) session;
            }
            else {
                throw new ServiceException(ResponseCode.EXCEPTION, "未传入企业编号");
            }

            String token = getEntToken(entId);

            if (StringUtils.isEmpty(token)) {
                throw new ServiceException(ResponseCode.EXCEPTION, "无法获取企业认证Token");
            }

            String signStr = String.format("%s=%s", EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_app_key", true, ""), EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_Secret", true, "")) +
                             String.format("&body=%s", param.toString()) +
                             String.format("&token=%s", token);
            String sign = MD5Utils.MD5(signStr);
            url = url.concat("&app_key=").concat(EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_app_key", true, ""))
                  .concat("&token=").concat(token)
                  .concat("&sign=").concat(sign);
            // 重写返回
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("method", method);
            map.put("url", url);
            map.put("param", param);
            return map;
        }
    }

    @AutoCache(Service = "HGO", KeyArgIndex = 0)
    private String getEntToken(Long entId) throws Exception
    {
        ServiceSession session = new ServiceSession();
        session.setEnt_id(entId);
        String token_Url = EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_AuthUrl", true, "");
        JSONObject param = new JSONObject();
        param.put("tag", EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_tag", true, ""));
        param.put("userCode", EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_userCode", true, ""));
        param.put("password", EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_password", true, ""));
        ServiceResponse response = RestClientUtils.getRestUtils().sendRequest(session, token_Url, param);

        if (response.getReturncode().equals(ResponseCode.SUCCESS)) {
            Object data = response.getData();

            if (data instanceof JSONObject && ((JSONObject) data).containsKey("access_token")) {
                return ((JSONObject) data).getString("access_token");
            }
        }

        return null;
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param) throws Exception
    {
        return sendRequest(session, method, param, "");
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception
    {
        String url;
        ServiceSession ss = null;

        if (session instanceof ServiceSession) {
            ss = (ServiceSession) session;
        }

        // 根据method找到URL
        if (method.toLowerCase().startsWith("http")) {
            url = method;
        }
        else {
            url = queryServiceURI(ss.getEnt_id(), method);

            if (org.springframework.util.StringUtils.isEmpty(url)) {
                throw new Exception("can't find method service url:" + method);
            }
        }

        Map<String, Object> map = doOverWrite(session, method, url, param);
        method = map.get("method").toString();
        url = map.get("url").toString();
        param = map.get("param");
        Object result = RestClientUtils.getRestUtils().sendRequest(session, url, param,
                        new RestClientUtils.defaultRequestCallback(), traceprex);
        ServiceResponse response = null;

        if (result != null) {
            JSONObject json;

            try {
                json = JSON.parseObject((String) result);
            }
            catch (Exception ex) {
                json = new JSONObject();
                json.put("returncode", ResponseCode.EXCEPTION);
                json.put("data", result);
            }

            response = JSON.toJavaObject(json, ServiceResponse.class);
        }

        if (response == null) {
            throw new ServiceException(ResponseCode.EXCEPTION, (String) result);
        }

        return response;
    }
}
