package com.efuture.ocp.common.slice.filter;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.*;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.UniqueID;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.text.DateFormat;
import java.util.*;

@Intercepts(
        {
                @org.apache.ibatis.plugin.Signature
                        (
                                type = org.apache.ibatis.executor.Executor.class,
                                method = "query",
                                args = {MappedStatement.class, Object.class, org.apache.ibatis.session.RowBounds.class, org.apache.ibatis.session.ResultHandler.class, org.apache.ibatis.cache.CacheKey.class, BoundSql.class}
                        ),
                @org.apache.ibatis.plugin.Signature
                        (
                                type = org.apache.ibatis.executor.Executor.class,
                                method = "query",
                                args = {MappedStatement.class, Object.class, org.apache.ibatis.session.RowBounds.class, org.apache.ibatis.session.ResultHandler.class}
                        ),
                @org.apache.ibatis.plugin.Signature
                        (
                                type = org.apache.ibatis.executor.Executor.class,
                                method = "update",
                                args = {MappedStatement.class, Object.class}
                        )
        })
public class ExecutorSliceWrapper extends CollectionInsertWrapper implements Interceptor
{
    public static final Logger logger = LoggerFactory.getLogger( "sliceLogger" );

    private static String getParameterValue(Object obj)
    {
        String value = null;
        if ((obj instanceof String))
        {
            value = "'" + obj.toString() + "'";
        }
        else if ((obj instanceof Date))
        {
            DateFormat formatter = DateFormat.getDateTimeInstance( 2, 2, Locale.CHINA );
            value = "'" + formatter.format( obj ) + "'";
        }
        else if (obj != null)
        {
            value = obj.toString();
        }
        else
        {
            value = "";
        }

        return value;
    }

    public static String showSql(Configuration configuration, BoundSql boundSql)
    {
        Object parameterObject = boundSql.getParameterObject();
        List<ParameterMapping> parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll( "[\\s]+", " " );
        MetaObject metaObject;
        if ((parameterMappings.size() > 0) && (parameterObject != null))
        {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler( parameterObject.getClass() ))
            {
                sql = sql.replaceFirst( "\\?", getParameterValue( parameterObject ) );
            }
            else
            {
                metaObject = configuration.newMetaObject( parameterObject );
                for (ParameterMapping parameterMapping : parameterMappings)
                {
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter( propertyName ))
                    {
                        Object obj = metaObject.getValue( propertyName );
                        sql = sql.replaceFirst( "\\?", getParameterValue( obj ) );
                    }
                    else if (boundSql.hasAdditionalParameter( propertyName ))
                    {
                        Object obj = boundSql.getAdditionalParameter( propertyName );
                        sql = sql.replaceFirst( "\\?", getParameterValue( obj ) );
                    }
                }
            }
        }
        return sql;
    }

    public static String getSql(Configuration configuration, BoundSql boundSql, String sqlId, long time)
    {
        String sql = showSql( configuration, boundSql );
        StringBuilder str = new StringBuilder( 100 );
        str.append( sqlId );
        str.append( ":" );
        str.append( sql );
        str.append( ": 执行耗时" );
        str.append( time );
        str.append( "ms" );
        return str.toString();
    }

    @Override
    public Object intercept(Invocation invocation) throws Throwable
    {
        if (!isEnableSlice())
        {
            sliceFilterLog("efuture.slice.enable is false!");
            return invocation.proceed();
        }


        final long interceptID = UniqueID.getUniqueID();

        long startTime = System.currentTimeMillis();

        MappedStatement mappedStatement = (MappedStatement) invocation.getArgs()[MAPPED_STATEMENT_INDEX];
        String sqlStatement = "";

        Object parameter = null;
        if (invocation.getArgs().length > 1)
        {
            parameter = invocation.getArgs()[1];
        }

        BoundSql boundSql = mappedStatement.getBoundSql( parameter );
        String sqlId = mappedStatement.getId();
        Configuration configuration = mappedStatement.getConfiguration();

        if (invocation.getArgs().length == 6)
        {
            boundSql = (BoundSql) invocation.getArgs()[BOUNDSQL_INDEX];
        }
        sqlStatement = boundSql.getSql();
        if (isParaTable(sqlStatement))
        {
            return invocation.proceed();
        }

        sliceFilterLog( String.format( "intercept(%1$d)--->1--->%2$s--->%3$s", new Object[]{Long.valueOf( interceptID ), "进入分片拦截器", sqlStatement.replaceAll( "[\\s]+", " " )} ) );

        String organizationCode = getCurrentEntMarket();
        String slice = null;
        JSONObject logJson = new JSONObject();
        if (StringUtils.isEmpty( organizationCode ))
        {
            slice = getCurrentSlice();
            if (StringUtils.isEmpty( slice ))
            {
                sliceFilterLog( String.format( "intercept(%1$d)--->1--->%2$s--->%3$s", new Object[]{Long.valueOf( interceptID ), "未传入分片信息", sqlStatement.replaceAll( "[\\s]+", " " )} ) );
                return invocation.proceed();
            }
        }

        //Object paramsValue = boundSql.getParameterObject();
        //if ((paramsValue instanceof Map))
        //所有SQL都进入检查
        if (true)
        {
            sliceFilterLog( String.format( "intercept(%1$d)--->2--->参数为Map", new Object[]{Long.valueOf( interceptID )} ) );

            //Map paramsMap = (Map) paramsValue;
            //if (paramsMap.containsKey( "@datakey" ))
            //不依赖@datakey配置，门店通过session传入
            if (true)
            {
//                organizationCode = paramsMap.get( "@datakey" ).toString();

                sliceFilterLog( String.format( "intercept(%1$d)--->3--->organizationCode--->%2$s", new Object[]{Long.valueOf( interceptID ), organizationCode} ) );

                boolean isexec = false;

                if (isWrapper( sqlStatement, organizationCode, slice))
                {
                    isexec = true;
                    sliceFilterLog(
                            String.format( "intercept(%1$d)--->4--->isWrapper--->%2$b", new Object[]{
                                    Long.valueOf( interceptID ),
                                    Boolean.valueOf( isexec )} ) );
                }

                if (!isexec)
                {
//                    long start = System.currentTimeMillis();
//                    Object returnValue = invocation.proceed();
//                    long end = System.currentTimeMillis();
//                    long time = end - start;
//                    if (time > 1L)
//                    {
//                        String sql = getSql( configuration, boundSql, sqlId, time );
//                        sliceFilterLog( sql );
//                    }
//                    return returnValue;
                    return invocation.proceed();
                }

                sliceFilterLog( String.format( "intercept(%1$d)--->5--->organizationCode--->%2$s", new Object[]{Long.valueOf( interceptID ), organizationCode} ) );

                final String partionKey = organizationCode;
                final String sliceKey   = slice;
                ExecutorCallback callback = new ExecutorCallback()
                {
                    @Override
                    public void onAction(SQLSelectQueryBlock query, String collectionName, String collectionAlias)
                    {
                        SQLExpr newWhereExpr = new SQLBinaryOpExpr();

                        String authWhereSql = ExecutorSliceWrapper.this.getPartionWhere( collectionName, collectionAlias, partionKey, sliceKey );

                        if (!StringUtils.isEmpty( authWhereSql ))
                        {
                            ExecutorSliceWrapper.sliceFilterLog( String.format( "intercept(%1$d)--->6--->partionKey authWhereSql--->1--->%2$s", new Object[]{Long.valueOf( interceptID ), authWhereSql} ) );

                            SQLExpr authWhereExpr = ExecutorSliceWrapper.this.getWhereInfo( authWhereSql );
                            if ((query.getWhere() != null) && ((query.getWhere() instanceof SQLBinaryOpExpr)))
                            {
                                SQLBinaryOpExpr whereExpr = (SQLBinaryOpExpr) query.getWhere();
                                if (whereExpr != null)
                                {
                                    ((SQLBinaryOpExpr) newWhereExpr).setOperator( SQLBinaryOperator.BooleanAnd );

                                    ((SQLBinaryOpExpr) newWhereExpr).setLeft( authWhereExpr );
                                    ((SQLBinaryOpExpr) newWhereExpr).setRight( whereExpr );
                                }
                            }
                            else
                            {
                                newWhereExpr = authWhereExpr;
                            }
                            query.setWhere( newWhereExpr );
                        }
                    }
                };
                try
                {
                    List<SQLStatement> statementList = SQLUtils.toStatementList( sqlStatement, getDbType() );

                    for (SQLStatement stmt : statementList)
                    {
                        logJson.put( "selectSql", sqlStatement );
                        if ((stmt instanceof SQLSelectStatement))
                        {
                            sliceFilterLog( String.format( "intercept(%1$d)--->7--->SqlType--->1--->%2$s", new Object[]{
                                    Long.valueOf( interceptID ),
                                    "SQLSelectStatement"} ) );
                            onSelectStatement( logger, sqlStatement, logJson, invocation, mappedStatement, boundSql, stmt, callback );
                        }
                        else if ((stmt instanceof SQLUpdateStatement))
                        {
                            sliceFilterLog( String.format( "intercept(%1$d)--->8--->SqlType--->1--->%2$s", new Object[]{
                                    Long.valueOf( interceptID ),
                                    "SQLUpdateStatement"} ) );
                            onUpdateStatement( logger, logJson, invocation, mappedStatement, boundSql, stmt, partionKey, sliceKey );
                        }
                        else if ((stmt instanceof SQLDeleteStatement))
                        {
                            sliceFilterLog( String.format( "intercept(%1$d)--->9--->SqlType--->1--->%2$s", new Object[]{
                                    Long.valueOf( interceptID ),
                                    "SQLDeleteStatement"} ) );
                            onDeleteStatement( logger, logJson, invocation, mappedStatement, boundSql, stmt, partionKey, sliceKey );
                        }
                        else if ((stmt instanceof SQLInsertStatement))
                        {
                            sliceFilterLog( String.format( "intercept(%1$d)--->10--->SqlType--->1--->%2$s", new Object[]{
                                    Long.valueOf( interceptID ),
                                    "SQLInsertStatement"} ) );
                            onInsertStatement( logger, logJson, invocation, mappedStatement, boundSql, stmt, partionKey, sliceKey );
                        }
                    }
                    sliceFilterLog( logJson.toJSONString() );
                } catch (Exception e)
                {
                    invocation.getArgs()[0] = mappedStatement;
                    sliceFilterLog( String.format( "intercept(%1$d)--->11--->newSQL --->Faiure:%2$s ---> %3$s", new Object[]{
                            Long.valueOf( interceptID ),
                            e.getMessage() + "", sqlStatement} ) );

                    JSONObject errorJson = new JSONObject();
                    errorJson.put( "unresolved sql", sqlStatement );
                }
            }
        }

        long endTime = System.currentTimeMillis();
        sliceFilterLog("mybatis分片组装耗费时间:----{} --->{}", interceptID, Long.valueOf(startTime - endTime));

//        long start = System.currentTimeMillis();
//        Object response = invocation.proceed();
//        long end = System.currentTimeMillis();
//        long time = end - start;
//        if (time > 1L)
//        {
//            String sql = getSql( configuration, boundSql, sqlId, time );
//            sliceFilterLog( sql );
//        }
//        return response;
        try
        {
            return invocation.proceed();
        }
        finally
        {
            //ServiceLogs.debuglog( ServiceLogs.LOGTYPE.DBSUCC, DataUtils.getJsonData(logJson, "newSql", false, sqlStatement), startTime );
            String logSql = showSql( configuration, ((MappedStatement) invocation.getArgs()[MAPPED_STATEMENT_INDEX]).getBoundSql( parameter ));
            ServiceLogs.debuglog( ServiceLogs.LOGTYPE.DBSUCC, logSql, startTime );
        }
    }

    @Override
    public Object plugin(Object target)
    {
        return Plugin.wrap( target, this );
    }

    @Override
    public void setProperties(Properties properties)
    {
        String dbType = properties.getProperty( "dbType" );
        if ((dbType == null) || (dbType.equals( "" )))
        {
            setDbType( "mysql" );
        }
        else
        {
            setDbType( dbType );
        }
    }

//    protected static void sliceFilterLog(String logmsg, Object... args)
//    {
//        if (isDebugLog())
//        {
//            logger.info( logmsg, args );
//        }
//    }
}