package com.efuture.ocp.common.sysevent;

abstract public class SystemEventData
{
    protected String msgTopic;
    protected Object msgData;
    protected String msgTag = "DEFAULT";
    protected String msgId;

    public SystemEventData()
    {
    }

    public SystemEventData(String msgTopic)
    {
        setMsgTopic(msgTopic);
    }

    public SystemEventData(String msgTopic, Object data)
    {
        setMsgTopic(msgTopic);
        setData(data);
    }

    public String getMsgTopic()
    {
        return msgTopic;
    }

    public void setMsgTopic(String topic)
    {
        this.msgTopic = topic;
    }

    public void setData(Object data)
    {
        this.msgData = data;
    }

    public Object getData()
    {
        return msgData;
    }

    @SuppressWarnings("unchecked")
    public <T> T getData(Class<T> clazz)
    {
        return (T) msgData;
    }

    public String getMsgTag()
    {
        return msgTag;
    }

    public void setMsgTag(String tag)
    {
        this.msgTag = tag;
    }

    public String getMsgId()
    {
        return msgId;
    }

    public void setMsgId(String id)
    {
        this.msgId = id;
    }
}