package com.efuture.ocp.common.user;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.component.BaseService;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.user.DataRange;
import com.efuture.ocp.user.UserService;
import com.efuture.ocp.user.UserTokenInfo;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 给新的portal的用户和数据范围接口
 * 1.目前只有数据范围接口
 * 2.传入的token实际上是entid-数据范围ID,暂时先这样，只处理数据范围，不处理其他用户信息
 * @author zhouwd
 *
 */
//@Component("UserServerSrv_cloud")
public class UserServiceCloudPortal extends BaseService implements UserService
{

	//public String DATA_RANGE_URL ="com.efuture.ocm.system.datarange.get";
	//@Value("${efuture.portal.rangeurl:SystemDatarange.get}")
	//public String DATA_RANGE_URL = "SystemDatarange.get";
	private String serviceUrl;
	private static final String DATARANGE_KEY = "OCP:DR:";

	public String getServiceUrl()
	{
		return serviceUrl;
	}

	public void setServiceUrl(String serviceUrl)
	{
		this.serviceUrl = serviceUrl;
	}


	@Override
	public UserTokenInfo getuserinfo(String token) {
		UserTokenInfo useInfo = new UserTokenInfo();
		useInfo.setDatarange(getDataRangeBytoken(token));
		useInfo.setToken(token);
		return useInfo;
	}

	@Override
	public List<DataRange> getDataRangeBytoken(String token) {
		return getDataRangeBypostid(token);
	}

	private String genDataRangeKey(String ent_id, String post_id)
	{
		return DATARANGE_KEY.concat(ent_id).concat( ":" ).concat( post_id );
	}

	@Override
	public List<DataRange> getDataRangeBypostid(String postid) {
		String[] para = postid.split("-");
		if(para.length != 2){
			throw new ServiceException("50000", "获取用户数据范围信息时参数错误:[{0}]", postid);
		}
		this.getLogger().info("postid:".concat(postid));
		String ent_id  =  para[0];
		String post_id = para[1];

		// 先从缓存获取
		Object obj = CacheUtils.getCacheUtils().getData( genDataRangeKey(ent_id, post_id) );
		if (null != obj)
		{
			return (List<DataRange>) obj;
		}
		else
		{
			ServiceSession session = new ServiceSession();
			session.setEnt_id( Long.valueOf( ent_id ) );
			session.setPostid( post_id );
			ServiceResponse sr;
			JSONObject jsonparam = new JSONObject();
			try
			{
				this.getLogger().info( "session:".concat( JSONObject.toJSONString( session ) ) );
				sr = RestClientUtils.getRestUtils().sendRequest( session, serviceUrl, jsonparam.toJSONString() );
			} catch (Exception e)
			{
				throw new ServiceException( "50000", "获取用户数据范围信息时错误:[{0}]-[{1}]", postid, e.getMessage() );
			}
			List<DataRange> rtn = new ArrayList<DataRange>();
			if (sr.getReturncode().equalsIgnoreCase( ResponseCode.SUCCESS ))
			{
				if (sr.getData() != null && sr.getData() instanceof JSONArray)
				{
					for (Object data : (JSONArray) sr.getData())
					{
						JSONObject jo = (JSONObject) data;
						DataRange dr = JSONObject.toJavaObject( jo, DataRange.class );
						rtn.add( dr );
					}
				}
			}
			return rtn;
		}
	}

	@Override
	public UserTokenInfo gettoken(String userid, Object entid) {
		// 不支持
		return null;
	}

}
