package com.efuture.ocp.common.annotation;

import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONObject;
//import com.efuture.ocp.common.redis.DistributedRedisLock;
import com.efuture.ocp.common.rest.ServiceLogs;

@Aspect
@Component
public class CallTimeAspect {
	private static final Logger logger = Logger.getLogger(CallTimeAspect.class);

	private String getKey(ProceedingJoinPoint point, CallTime around) {
		String serviceName = around.Service();
		String keyname = around.KeyName();
		int argindex = around.KeyArgIndex();
		String className = point.getTarget().getClass().getSimpleName();
		String methodName = point.getSignature().getName();
		Object[] args = point.getArgs();
		StringBuffer sb = new StringBuffer();
		if (argindex != -1 && args.length > argindex) {
			Object arg = args[argindex];
			JSONObject jsonarg;
			if (arg instanceof JSONObject) 
			{
				jsonarg = (JSONObject) arg;
			} 
			else if (arg instanceof String) 
			{
			    jsonarg = new JSONObject();
			    jsonarg.put(String.valueOf(argindex), arg);
			}
			else 
			{
				jsonarg = (JSONObject) JSONObject.toJSON(arg);
			}
			if (StringUtils.isEmpty(keyname)) {
				sb.append("_").append(JSONObject.toJSON(arg));
			} else {
				String[] keys = keyname.split(",");
				StringBuffer sbkey = new StringBuffer();
				for (String key : keys) {
					if (key != null) {
						Object value = jsonarg.get(key);
						if (value != null) {
							sbkey.append("-").append(key).append(":").append(value.toString());
						}
					}
				}
				if (sbkey.length() > 0) {
					sb.append("_").append(sbkey.toString());
				} else {
					sb.append("_").append(jsonarg.toJSONString());
				}
			}
		}
		//else if (argindex == 99 && !StringUtils.isEmpty(keyname))
		else if (argindex == 99)
		{
		    // 常规类型
            String[] keys = keyname.split(",");
            StringBuffer sbkey = new StringBuffer();
            if (keys != null && keys.length > 0)
            {
	            for (String key : keys) {
	            	if (!StringUtils.isEmpty(key))
	            	{
		            	String keyVal =  args[Integer.valueOf(key)].toString();
		                if (sbkey.length() > 0) {
		                    sb.append("_").append(args[Integer.valueOf(key)].toString());
		                } else {
		                    sb.append(args[Integer.valueOf(key)].toString());
		                }
	            	}
	            }
            }
		}		
		else {
			for (Object arg : args) {
				if (arg != null) {
					sb.append("_").append(JSONObject.toJSON(arg));
				}
			}
		}
		if (sb.length() > 0)
		{
			return serviceName.concat("-").concat(className).concat("-").concat(methodName).concat("-").concat(sb.toString());
		}
		else
		{
			return serviceName.concat("-").concat(className).concat("-").concat(methodName);
		}
	}
	
	@Around("@annotation(around)")
	public Object round(ProceedingJoinPoint point, CallTime around) throws Throwable
	{
		long starttime = System.currentTimeMillis();
		
		try {
			return point.proceed();
		} catch (Throwable e) {
			throw e;
		} finally {
			//String info = serviceName.concat("-").concat(className).concat("-").concat(methodName);
			ServiceLogs.debuglog(ServiceLogs.LOGTYPE.INFO, getKey(point, around), starttime);
		}
	}

}
