package com.efuture.ocp.common.cache.redis;

import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.EnviromentUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import redis.clients.jedis.HostAndPort;

import java.util.HashSet;
import java.util.Set;

/**
 * 读取缓存配置文件
 *
 * @author zwt
 *
 */
public class RedisConfig {

	/**
	 * redis配置key
	 */
	public static final String REDIS_POOL = "portal.properties";
	private static Configuration config = null;
	/**
	 * 配置文件名称
	 */
	private static String configfile = "/conf/portal.properties";

	public static String getString(String key) {
		if (config != null)
		{
			return DataUtils.nvl( config.getString( key ), EnviromentUtil.getProperty( key ) );
		}
		else
		{
			return EnviromentUtil.getProperty( key );
		}
	}

	public static String[] getStringArray(String key) {
		if (config != null)
		{
		return config.getStringArray(key);
		}
		else
		{
			return EnviromentUtil.getProperty( key ).split( "," );
		}
	}
	public static String[] getRedisArray()
	{
		String[] hosts = getString( "efuture.cache.redisHost" ).split( "," );
		String[] ports = getString( "efuture.cache.redisPort" ).split( "," );
		for (int i = 0; i < hosts.length; i++)
		{
			hosts[i] = hosts[i].concat( ":" ).concat( ports[i] );
		}
		return hosts;
	}

	public static Set<HostAndPort> getRedisClusterNodes()
	{
		Set<HostAndPort> jedisClusterNodes = new HashSet<HostAndPort>();
		String[] hosts = getString( "efuture.cache.redisHost" ).split( "," );
		for (String host : hosts) {
			//10.0.137.135:26379,10.0.137.136:26379,10.0.137.137:26379
			String[] kv = host.split(":");
			jedisClusterNodes.add(new HostAndPort(kv[0], Integer.parseInt(kv[1])));
		}
		return jedisClusterNodes;
	}

	public static void setPropertiesConfig(PropertiesConfiguration prop) {
		config = prop;
	}

	static {
		try {
			config = new PropertiesConfiguration(configfile);
		} catch (ConfigurationException e) {
		}
	}
}
