package com.efuture.ocp.common.component.ruleimpl;

import com.efuture.ocp.common.component.INORule;
import com.efuture.ocp.common.exception.ServiceException;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Map;

@Component
public class MappedRuleImpl implements INORule {

    @Override
    public String getRuleCode() {
        return "MAP";
    }

    @Override
    public String getCodeStr(String ruleCode, Map<String, Object> fields) {
        String rtn = getCodeFromMap(ruleCode, fields);
        if (StringUtils.isEmpty(rtn)) {
            throw new ServiceException("10011", "[{0}] 的属性值无效", ruleCode);
        }
        return rtn;
    }

    @Override
    public boolean isDateRule() {
        return false;
    }
}

