package com.efuture.ocp.common.proxy;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class EnterpriseProxy
{
    // 业务Key
    private String bizKey;
    public String getBizKey()
    {
        return bizKey;
    }
    public void setBizKey(String bizKey)
    {
        this.bizKey = bizKey;
    }
    private String bizpara1;
    private String bizpara2;
    private String bizpara3;
    private String bizpara4;
    private String bizpara5;


    // Spring Bean
    private final static String BEAN_NAME = "entconfig";
    public static EnterpriseProxy getInstance()
    {
        if (!SpringBeanFactory.containsBean(BEAN_NAME)) {
            return null;
        }

        EnterpriseProxy eas = SpringBeanFactory.getBean(BEAN_NAME, EnterpriseProxy.class);

        if (eas == null) {
            return null;
        }

        return eas;
    }

    // 数据访问连接
    public FStorageOperations getStorageOperations()
    {
        return SpringBeanFactory.getBean("GlobalStorageOperation", FStorageOperations.class);
    }
    // 企业配置加载
    private ConcurrentHashMap<Long, EnterpriseConfigBean> list_enterprise = new ConcurrentHashMap<Long, EnterpriseConfigBean>();
    public int initEnterpriseConfig() throws Exception
    {
        FMybatisTemplate storage = null;

        try {
            list_enterprise.clear();
            storage = (FMybatisTemplate) getStorageOperations();
            Query query = new Query();
            List<EnterpriseConfigBean> list = storage.select(query, EnterpriseConfigBean.class);

            for (EnterpriseConfigBean ent : list) {
                list_enterprise.put(ent.getEnt_id(), ent);
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }

        return list_enterprise.size();
    }

    public JSONObject printEnterpriseConfig(long ent_id) throws Exception
    {
        JSONObject ret = new JSONObject();

        if (StringUtils.isEmpty(list_enterprise) || list_enterprise.size() <= 0) {
            initEnterpriseConfig();
        }

        if (ent_id == 0L) {
            ret.put("ents", JSONObject.toJSONString(list_enterprise));
        }
        else {
            ret.put(String.valueOf(ent_id), JSONObject.toJSONString(list_enterprise.get(ent_id)));
        }

        return ret;
    }

    private EnterpriseConfigBean getEnterpriseConfig(long ent_id) throws Exception
    {
        EnterpriseConfigBean ent = list_enterprise.get(ent_id);

        if (StringUtils.isEmpty(ent)) {
            initEnterpriseConfig();

            if (list_enterprise == null || list_enterprise.size() <= 0) {
                return ent;
            }
        }

        return list_enterprise.get(ent_id);
    }

    public Object getServiceProxy(ServiceSession session) throws Exception
    {
        this.setBizKey(bizKey);
        return getServiceProxy(session, bizKey, null);
    }
    public Object getServiceProxy(ServiceSession session, String mktid) throws Exception
    {
        this.setBizKey(bizKey);
        return getServiceProxy(session, bizKey, mktid);
    }
    public Object getServiceProxy(ServiceSession session, String bizKey, String mktid) throws Exception
    {
        return getServiceProxy(session, bizKey, true, mktid);
    }
    public Object getServiceProxy(ServiceSession session, String bizKey, boolean isCheck) throws Exception
    {
        return getServiceProxy(session, bizKey, isCheck, null);
    }
    public Object getServiceProxy(ServiceSession session, String bizKey, boolean isCheck, String mktid) throws Exception
    {
        return getServiceProxy(session, bizKey, isCheck, false, mktid);
    }
    public Object getServiceProxy(ServiceSession session, String bizKey, boolean isCheck, boolean isSaveBizKey, String mktid) throws Exception
    {
        try {
            long ent_id = session.getEnt_id();
            EnterpriseConfigBean ent = null;

            try {
                ent = getEnterpriseConfig(ent_id);
            }
            catch (Exception Ex) {
                throw new ServiceException(ResponseCode.EXCEPTION, "加载代理配置失败:" + Ex.getMessage());
            }

            if (StringUtils.isEmpty(ent)) {
                throw new ServiceException(ResponseCode.EXCEPTION, "未找到企业[" + String.valueOf(ent_id) + "]对应的代理配置！");
            }

            String proxyObject = ent.getProxyObject(bizKey);

            if (StringUtils.isEmpty(proxyObject)) {
                throw new ServiceException(ResponseCode.EXCEPTION, "未配置代理对象[" + bizKey + "]!");
            }

            EnterpriseProxyBase eas;
            boolean skipMkt = false;

            if (!StringUtils.isEmpty(mktid)) {
                try {
                    JSONObject mktproxyObjs = JSONObject.parseObject(proxyObject);

                    if (!mktproxyObjs.containsKey(mktid)) {
                        throw new ServiceException(ResponseCode.EXCEPTION, "未包含门店代理对象[" + mktproxyObjs.toJSONString() + "]!");
                    }

                    String mktProxyObj = mktproxyObjs.getString(mktid);

                    if (!SpringBeanFactory.containsBean(mktProxyObj)) {
                        throw new ServiceException(ResponseCode.EXCEPTION, "未包含门店代理对象[" + mktProxyObj + "]!");
                    }

                    eas = (EnterpriseProxyBase) SpringBeanFactory.getBean(mktProxyObj);
                }
                catch (JSONException e) {
                    //兼容老版本
                    if (!SpringBeanFactory.containsBean(proxyObject)) {
                        throw new ServiceException(ResponseCode.EXCEPTION, "未包含代理对象[" + proxyObject + "]!");
                    }

                    skipMkt = true;
                    eas = (EnterpriseProxyBase) SpringBeanFactory.getBean(proxyObject);
                }
            }
            else {
                if (!SpringBeanFactory.containsBean(proxyObject)) {
                    throw new ServiceException(ResponseCode.EXCEPTION, "未包含代理对象[" + proxyObject + "]!");
                }

                eas = (EnterpriseProxyBase) SpringBeanFactory.getBean(proxyObject);
            }

            if (eas == null) {
                throw new ServiceException(ResponseCode.EXCEPTION, "未定义代理对象[" + proxyObject + "]!");
            }

            if (!StringUtils.isEmpty(mktid) && !skipMkt) {
                eas.setBizKey(bizKey.concat("_").concat(mktid));
            }

            if (isSaveBizKey) {
                eas.setBizKey(bizKey);
            }

            eas.setEnterpise(ent);
            return eas;
        }
        catch (Exception ex) {
            if (isCheck) {
                throw ex;
            }
            else {
                return null;
            }
        }
    }


    public ServiceResponse initconfig(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        return ServiceResponse.buildSuccess(initEnterpriseConfig());
    }

    public ServiceResponse printconfig(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        long ent_id = DataUtils.nvl(session.getEnt_id(), 0L);
        return ServiceResponse.buildSuccess(printEnterpriseConfig(ent_id));
    }

    public String getEnterpriseConfig(long ent_id, String key, boolean checkNull, String defValue) throws Exception
    {
        EnterpriseConfigBean ent = null;

        try {
            ent = getEnterpriseConfig(ent_id);
        }
        catch (Exception Ex) {
            throw new ServiceException(ResponseCode.EXCEPTION, "加载代理配置失败:" + Ex.getMessage());
        }

        if (StringUtils.isEmpty(ent)) {
            throw new ServiceException(ResponseCode.EXCEPTION, "未找到企业[" + String.valueOf(ent_id) + "]对应的代理配置！");
        }

        return ent.getSrvConfig(key, checkNull, defValue);
    }

    public String getEnterpriseConfig(ServiceSession session, String key, boolean checkNull, String defValue) throws Exception
    {
        return getEnterpriseConfig(session.getEnt_id(), key, checkNull, defValue);
    }

    public String getBizpara1()
    {
        return bizpara1;
    }

    public void setBizpara1(String bizpara1)
    {
        this.bizpara1 = bizpara1;
    }

    public String getBizpara2()
    {
        return bizpara2;
    }

    public void setBizpara2(String bizpara2)
    {
        this.bizpara2 = bizpara2;
    }

    public String getBizpara3()
    {
        return bizpara3;
    }

    public void setBizpara3(String bizpara3)
    {
        this.bizpara3 = bizpara3;
    }

    public String getBizpara4()
    {
        return bizpara4;
    }

    public void setBizpara4(String bizpara4)
    {
        this.bizpara4 = bizpara4;
    }

    public String getBizpara5()
    {
        return bizpara5;
    }

    public void setBizpara5(String bizpara5)
    {
        this.bizpara5 = bizpara5;
    }


}
