package com.efuture.ocp.common.util;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

import com.alibaba.fastjson.JSONObject;

@Configuration
public class EnviromentUtil implements EnvironmentAware
{
    private static Environment environment;

    @Override
    public void setEnvironment(Environment environment)
    {
        EnviromentUtil.environment = environment;
    }

    public static String getProperty(String key)
    {
        return EnviromentUtil.environment.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue)
    {
        String propertyValue = EnviromentUtil.environment.getProperty(key);

        if (StringUtils.isEmpty(propertyValue)) {
            return defaultValue;
        }
        else {
            return propertyValue;
        }
    }

    public static Environment getEnv()
    {
        return EnviromentUtil.environment;
    }

    public static JSONObject followEnvironment(Environment env, String... flow)
    {
        String envs = (env != null ? env.getProperty("env.follow") : getProperty("env.follow"));

        JSONObject json = null;

        if ((flow != null && flow.length > 0) || !StringUtils.isEmpty(envs)) {
            json = new JSONObject();
            System.out.println("============ Env properties follow start ===============");

            if (flow != null && flow.length > 0) {
                for (int i = 0; i < flow.length; i++) {
                    String data = (env != null ? env.getProperty(flow[i]) : getProperty(flow[i]));
                    System.out.println(flow[i] + " : " + data);
                    json.put(flow[i], data);
                }
            }

            if (!StringUtils.isEmpty(envs)) {
                String[] keys = envs.split(",");

                for (int i = 0; i < keys.length; i++) {
                    String data = (env != null ? env.getProperty(keys[i]) : getProperty(keys[i]));
                    System.out.println(keys[i] + " : " + data);
                    json.put(keys[i], data);
                }
            }

            System.out.println("============ Env properties follow ends  ===============");
        }

        return json;
    }
}
