
package com.efuture.ocp.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import com.efuture.ocp.common.component.BasicComponent;

/**
 * 获取全局参数
 * 
 * @author zhouwudong
 *
 */

public class GlobPara extends BasicComponent {

	private Map<String, String> globpara = new HashMap<String, String>();
	private boolean ibinit = false;

	// 取数据
	public static String getvalue(String paraname) {
		return SpringBeanFactory.getBean("globpara", GlobPara.class).get(paraname);
	}

	// 初始化数据，第一次使用时初始化。
	public String get(String paraname) {
		if (!ibinit) {
			init();
		}
		return globpara.get(paraname);
	}

	// 使用synchronized 作为同步锁，保证只有一个进程读取初始化的数据。
	private synchronized void init() {
		if (!ibinit) {
			Criteria criteria = Criteria.where("1").is("1");
			Query query = new Query(criteria);
			List<Map<String, Object>> list = this.getStorageOperations().select(query, "dbusrsys.globpara");
			for (int i = 0; i < list.size(); i++) {
				String glid = (String) list.get(i).get("glid");
				String glvalue = (String) list.get(i).get("glvalue");
				globpara.put(glid, glvalue);
			}
			ibinit = true;
		}
	}

	/**
	 * 刷新全局参数
	 */
	public void doreflush() {
		ibinit = false;
		init();
	}

	/**
	 * 刷新全局参数
	 * 
	 * @return
	 */
	public static String reflush() {
		SpringBeanFactory.getBean("globpara", GlobPara.class).doreflush();
		return "OK";
	}

}
