package com.efuture.ocp.common.util;

import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import com.efuture.omd.storage.FStorageOperations;

@Component("restinfogetfromglobpara")
public class RestInfoGetFromGlobpara implements RestInfoGet {

	public Logger logger = Logger.getLogger(RestInfoGetFromGlobpara.class);





	public RestInfoGetFromGlobpara() {
		super();
	}

	@Override
	public void init(String configfile) {

	}

	@Override
	public String queryServiceURI(long ent_id, String method) {
		return GlobParaEnt.getvalue(ent_id, method, "");
	}

	@Override
	public String queryServiceURI(String method) {
		return GlobParaEnt.getvalue(0, method, "");
	}

	@Override
	public String queryServiceURIbymkt(String method, String mktid) throws Exception {
		String servicePath = "";
		String curservice = method;
		if (!StringUtils.isEmpty(curservice)) {
			servicePath = GlobParaEnt.getvalue(0, method + "-" + mktid, "");

			if (servicePath == null) {
				servicePath = GlobParaEnt.getvalue(0, method, "");
			}
			if (servicePath == null) {
				Criteria criteria = Criteria.where("mktid").is(mktid).and("id").is(method);
				Query query = new Query(criteria);
				List<Map<String, Object>> list = SpringBeanFactory.getBean("StorageOperation", FStorageOperations.class)
						.select(query, "restconfig");
				if (list != null && !list.isEmpty() && list.size() > 0) {
					servicePath = (String) list.get(0).get("resturl");

				} else {
					Criteria c2 = Criteria.where("mktid").is("%").and("id").is(method);
					Query q2 = new Query(c2);
					List<Map<String, Object>> list2 = SpringBeanFactory
							.getBean("StorageOperation", FStorageOperations.class).select(q2, "restconfig");
					if (list2 != null && !list2.isEmpty() && list2.size() > 0) {
						servicePath = (String) list2.get(0).get("resturl");
					} else {
						throw new Exception("can't find method service url, please check restconfig !");
					}
				}
			}
		}

		// 返回URL
		return servicePath;
	}

}
