/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.billservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.BillAbstractHeadBean;
import com.efuture.ocp.common.billservice.BillCommonService;
import com.efuture.ocp.common.billservice.BillOperLogService;
import com.efuture.ocp.common.billservice.BillOperLogSrvImpl;
import com.efuture.ocp.common.bpm.BpmService;
import com.efuture.ocp.common.component.GlobRuleSrv;
import com.efuture.ocp.common.component.MasterSlaveComponent;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.StorageUtils;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FMybatisTemplate;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BillCommonServiceImpl<T extends BillAbstractHeadBean>
extends MasterSlaveComponent<T>
implements BillCommonService {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    private Map<String, String> STATUSNAME = new HashMap<String, String>();
    private BillOperLogService operlog;
    @Autowired
    private GlobRuleSrv globrulesrv;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ServiceResponse applybillno(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"moduleid"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "moduleid");
        }
        String ruleid = jsonparam.getString("ruleid");
        if (StringUtils.isEmpty((Object)ruleid)) {
            ruleid = "billno";
        }
        int num = 1;
        if (jsonparam.containsKey((Object)"count")) {
            num = jsonparam.getInteger("count");
        }
        JSONObject json = new JSONObject();
        if (num > 1) {
            json.put(ruleid, this.doApplyBillNoBatch(session.getEnt_id(), ruleid, jsonparam.getString("moduleid"), jsonparam.getString("type"), jsonparam.getString("level"), num));
        } else {
            json.put(ruleid, (Object)this.doApplyBillNo(session.getEnt_id(), ruleid, jsonparam.getString("moduleid"), jsonparam.getString("type"), jsonparam.getString("level")));
        }
        return ServiceResponse.buildSuccess(json);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String doApplyBillNo(long ent_id, String ruleid, String moduleid, String type, String level) {
        List<String> list = this.doApplyBillNoBatch(ent_id, ruleid, moduleid, type, level, 1);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<String> doApplyBillNoBatch(long ent_id, String ruleid, String moduleid, String type, String level, int num) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("MODULEID", moduleid);
        List<String> billnolist = this.globrulesrv.doGenRuleCodeBatch(ent_id, ruleid, null, level, num, fields);
        return billnolist;
    }

    protected String getBillNoRuleID(String billmoduleid) {
        return "billno";
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public long doAdd(AbstractEntityBean bean, String id, String ... uniques) throws Exception {
        if (bean instanceof BillAbstractHeadBean) {
            BillAbstractHeadBean bill = (BillAbstractHeadBean)bean;
            if (StringUtils.isEmpty((Object)bill.getBillno()) && !StringUtils.isEmpty((Object)bill.getBillmoduleid())) {
                String ruleid = this.getBillNoRuleID(bill.getBillmoduleid());
                String billno = this.doApplyBillNo(bill.getEnt_id(), ruleid, bill.getBillmoduleid(), null, null);
                bill.setBillno(billno);
                if (!StringUtils.isEmpty((Object)this.getBillKeyField())) {
                    this.getBillKeyField().set(bean, billno);
                }
            }
            if (StringUtils.isEmpty((Object)bill.getBillsgno())) {
                bill.setBillsgno(bill.getBillno());
            }
            bill.setInputdate(new Date());
            bill.setLastmodby(bill.getInputer());
            bill.setLastmodby_name(bill.getInputer_name());
            ServiceSession session = ServiceRestReflect.getLocale().get();
            this.billOperLog(session, bill, "\u65b0\u589e", "");
        }
        return super.doAdd(bean, id, uniques);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Object doDelete(AbstractEntityBean bean, String id, String ... keys) throws Exception {
        BillAbstractHeadBean bill = (BillAbstractHeadBean)bean;
        BillAbstractHeadBean oribill = this.checkBillStatus(bill);
        this.canDelete(oribill);
        Object rtn = super.doDelete(bean, id, keys);
        this.log(oribill, "\u5220\u9664", "");
        return rtn;
    }

    public void log(BillAbstractHeadBean bill, String type, String memo) {
        ServiceSession session = ServiceRestReflect.getLocale().get();
        this.billOperLog(session, bill, type, memo);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void canDelete(BillAbstractHeadBean bill) throws Exception {
        if (!"N".equalsIgnoreCase(bill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5f55\u5165\u72b6\u6001\u7684\u5355\u636e,\u4e0d\u80fd\u5220\u9664!", bill.getBillno());
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Object doUpdate(AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        if (bean instanceof BillAbstractHeadBean) {
            BillAbstractHeadBean bill = (BillAbstractHeadBean)bean;
            BillAbstractHeadBean oribill = this.checkBillStatus(bill);
            if (!"N".equalsIgnoreCase(oribill.getBillstatus())) {
                throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5f55\u5165\u72b6\u6001\u7684\u5355\u636e,\u4e0d\u80fd\u4fee\u6539!", oribill.getBillno());
            }
            ServiceSession session = ServiceRestReflect.getLocale().get();
            this.billOperLog(session, bill, "\u4fee\u6539", null);
        }
        return super.doUpdate(bean, keys, id, uniques);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    protected BillAbstractHeadBean checkBillStatus(BillAbstractHeadBean bill) throws Exception {
        HashSet<String> keys = new HashSet<String>();
        bill.setPh_timestamp(new Date());
        keys.add("ph_timestamp");
        super.doUpdate(bill, keys, "billno", new String[0]);
        JSONObject json = new JSONObject();
        json.put("fields", (Object)"*");
        json.put("ent_id", (Object)bill.getEnt_id());
        json.put("billno", (Object)bill.getBillno());
        BillAbstractHeadBean oribill = (BillAbstractHeadBean)this.doSearchOne(json, this.getBeanClass());
        if (oribill == null) {
            throw new ServiceException("10003", "{0} {1} [{2}] does not exist", MessageSourceHelper.getMessage(bill.fetchAnnotationTableName(), bill.getLang(), new Object[0]), "billno", bill.getBillno());
        }
        return oribill;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billaudit(ServiceSession session, JSONObject jsonparam) throws Exception {
        UserDataRangeSrv.setlocalisrange(false);
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        boolean force = false;
        if (jsonparam.containsKey((Object)"force")) {
            force = jsonparam.getBoolean("force");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        bean.initUpdateMember(session);
        Object auditdata = this.doBillAudit(bean, session, force);
        JSONObject json = new JSONObject();
        if (!force && auditdata != null) {
            json.put("data", auditdata);
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u5ba1\u6838\u4e0d\u6210\u529f,\u9700\u518d\u6b21\u786e\u8ba4!"));
        } else {
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u5ba1\u6838\u6210\u529f!"));
        }
        return ServiceResponse.buildSuccess(json);
    }

    protected Set<String> beforeBillAudit(BillAbstractHeadBean bill) throws Exception {
        if ("WAITTING".equalsIgnoreCase(bill.getBillsgno())) {
            bill.setBillstatus("W");
        }
        return null;
    }

    protected Set<String> bizBillAudit(BillAbstractHeadBean bill, ServiceSession session) throws Exception {
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object doBillAudit(T bill, ServiceSession session, boolean force) throws Exception {
        Set<String> bizkeys;
        Set<String> keys;
        bill = this.checkBillStatus((BillAbstractHeadBean)bill);
        List<String> BillStatus_CanAudit = Arrays.asList("N", "M");
        if ("Y".equalsIgnoreCase(((BillAbstractHeadBean)bill).getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u5df2\u5ba1\u6838,\u4e0d\u80fd\u91cd\u590d\u5ba1\u6838!", ((BillAbstractHeadBean)bill).getBillno());
        }
        if (!BillStatus_CanAudit.contains(((BillAbstractHeadBean)bill).getBillstatus())) {
            if ("W".equalsIgnoreCase(((BillAbstractHeadBean)bill).getBillstatus()) && !"asyncaudit".equalsIgnoreCase(((BillAbstractHeadBean)bill).getBillsgno())) {
                throw new ServiceException("10000", "[{0}]\u5355\u636e\u5df2\u5ba1\u6838,\u4e0d\u80fd\u91cd\u590d\u5ba1\u6838!", ((BillAbstractHeadBean)bill).getBillno());
            }
            if (!("W".equalsIgnoreCase(((BillAbstractHeadBean)bill).getBillstatus()) && "asyncaudit".equalsIgnoreCase(((BillAbstractHeadBean)bill).getBillsgno()) || "A".equalsIgnoreCase(((BillAbstractHeadBean)bill).getBillstatus()))) {
                throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5f85\u5ba1\u6838\u5355\u636e,\u4e0d\u80fd\u5ba1\u6838!", ((BillAbstractHeadBean)bill).getBillno());
            }
        }
        if (StringUtils.isEmpty((Object)((BillAbstractHeadBean)bill).getBillstatus()) || BillStatus_CanAudit.contains(((BillAbstractHeadBean)bill).getBillstatus())) {
            ((BillAbstractHeadBean)bill).setBillstatus("Y");
        }
        if ((keys = this.beforeBillAudit((BillAbstractHeadBean)bill)) == null) {
            keys = new HashSet<String>();
        }
        if (!StringUtils.isEmpty(bizkeys = this.bizBillAudit((BillAbstractHeadBean)bill, session))) {
            keys.addAll(bizkeys);
        }
        if (StringUtils.isEmpty((Object)((BillAbstractHeadBean)bill).getAuditor()) && session != null && session.getUser_code() != null) {
            ((BillAbstractHeadBean)bill).setAuditor(session.getUser_code());
        }
        if (StringUtils.isEmpty((Object)((BillAbstractHeadBean)bill).getAuditor_name()) && session != null && session.getUser_name() != null) {
            ((BillAbstractHeadBean)bill).setAuditor_name(session.getUsercodename());
        }
        ((BillAbstractHeadBean)bill).setAuditdate(new Date());
        ((BillAbstractHeadBean)bill).setLastmodby(((BillAbstractHeadBean)bill).getAuditor());
        ((BillAbstractHeadBean)bill).setLastmodby_name(((BillAbstractHeadBean)bill).getAuditor_name());
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        keys.add("auditor");
        keys.add("auditor_name");
        keys.add("auditdate");
        super.doUpdate((AbstractEntityBean)bill, keys, "billno", new String[0]);
        this.afterBillAudit((BillAbstractHeadBean)bill);
        if (!force) {
            this.billOperLog(session, (BillAbstractHeadBean)bill, "\u5ba1\u6838", "");
        }
        return null;
    }

    protected void afterBillAudit(BillAbstractHeadBean bill) throws Exception {
    }

    @Override
    public ServiceResponse save(ServiceSession session, String param) throws Exception {
        this.beforeBillSave(session, param);
        return super.save(session, param);
    }

    protected void beforeBillSave(ServiceSession session, String param) throws Exception {
        JSONArray jsonarray = null;
        Object obj = JSON.parse((String)param);
        if (obj instanceof JSONArray) {
            jsonarray = (JSONArray)obj;
        } else if (obj instanceof JSONObject && (jsonarray = ((JSONObject)obj).getJSONArray(this.getBeanTable())) == null) {
            jsonarray = new JSONArray();
            jsonarray.add(obj);
        }
        if (jsonarray == null) {
            throw new ServiceException("50003", "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        for (int i = 0; i < jsonarray.size(); ++i) {
            JSONObject jsonObject = jsonarray.getJSONObject(i);
            if (!jsonObject.containsKey((Object)"flag") || !"U".equalsIgnoreCase(jsonObject.getString("flag")) || !jsonObject.containsKey((Object)"ph_key") || !jsonObject.containsKey((Object)"billstatus")) continue;
            String ph_key = jsonObject.getString("ph_key");
            String billstatus = jsonObject.getString("billstatus");
            JSONObject queryParam = new JSONObject();
            queryParam.put("ph_key", (Object)ph_key);
            BillAbstractHeadBean oribill = (BillAbstractHeadBean)this.doSearchOne(queryParam, this.getBeanClass());
            if (ObjectUtils.isEmpty((Object)oribill)) {
                throw new ServiceException("10003", "{0} {1} [{2}] does not exist", this.getBeanClass(), "ph_key", ph_key);
            }
            if (billstatus.equalsIgnoreCase(oribill.getBillstatus())) continue;
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u72b6\u6001\u4e0e\u6570\u636e\u5e93\u4e2d\u5b58\u5728\u7684\u4e0d\u4e00\u81f4,\u4e0d\u80fd\u4fdd\u5b58!", oribill.getBillno());
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billcancel(ServiceSession session, JSONObject jsonparam) throws Exception {
        UserDataRangeSrv.setlocalisrange(false);
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        boolean force = false;
        if (jsonparam.containsKey((Object)"force")) {
            force = jsonparam.getBoolean("force");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        bean.initUpdateMember(session);
        Object canceldata = this.doBillCancel(bean, session, force);
        JSONObject json = new JSONObject();
        if (!force && canceldata != null) {
            json.put("data", canceldata);
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u53d6\u6d88\u4e0d\u6210\u529f,\u9700\u518d\u6b21\u786e\u8ba4!"));
        } else {
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u53d6\u6d88\u6210\u529f!"));
        }
        return ServiceResponse.buildSuccess(json);
    }

    protected Set<String> beforeBillCancel(BillAbstractHeadBean bill) throws Exception {
        if ("WAITTING".equalsIgnoreCase(bill.getBillsgno())) {
            bill.setBillstatus("W");
        }
        return null;
    }

    public void checkBillCancel(ServiceSession session, BillAbstractHeadBean oribill) {
        if ("C".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u5df2\u53d6\u6d88,\u4e0d\u80fd\u91cd\u590d\u53d6\u6d88!", oribill.getBillno());
        }
        if (!"Y".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5df2\u5ba1\u6838\u5355\u636e,\u4e0d\u80fd\u53d6\u6d88!", oribill.getBillno());
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object doBillCancel(T bill, ServiceSession session, boolean force) throws Exception {
        bill = this.checkBillStatus((BillAbstractHeadBean)bill);
        this.checkBillCancel(session, (BillAbstractHeadBean)bill);
        Set<String> keys = this.beforeBillCancel((BillAbstractHeadBean)bill);
        this.bizBillCancel((BillAbstractHeadBean)bill, session);
        if (StringUtils.isEmpty((Object)((BillAbstractHeadBean)bill).getBillstatus()) || "Y".equalsIgnoreCase(((BillAbstractHeadBean)bill).getBillstatus())) {
            ((BillAbstractHeadBean)bill).setBillstatus("C");
        }
        if (StringUtils.isEmpty((Object)((BillAbstractHeadBean)bill).getCanceler()) && session != null && session.getUser_code() != null) {
            ((BillAbstractHeadBean)bill).setCanceler(session.getUser_code());
        }
        if (StringUtils.isEmpty((Object)((BillAbstractHeadBean)bill).getCanceler_name()) && session != null && session.getUser_name() != null) {
            ((BillAbstractHeadBean)bill).setCanceler_name("[" + session.getUser_code() + "]" + session.getUser_name());
        }
        ((BillAbstractHeadBean)bill).setCanceldate(new Date());
        ((BillAbstractHeadBean)bill).setLastmodby(((BillAbstractHeadBean)bill).getCanceler());
        ((BillAbstractHeadBean)bill).setLastmodby_name(((BillAbstractHeadBean)bill).getCanceler_name());
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        keys.add("canceler");
        keys.add("canceler_name");
        keys.add("canceldate");
        super.doUpdate((AbstractEntityBean)bill, keys, "billno", new String[0]);
        this.billOperLog(session, (BillAbstractHeadBean)bill, "\u53d6\u6d88", "");
        this.afterBillCancel((BillAbstractHeadBean)bill);
        return null;
    }

    protected void bizBillCancel(BillAbstractHeadBean bill, ServiceSession session) throws Exception {
    }

    protected void afterBillCancel(BillAbstractHeadBean bill) throws Exception {
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billvoid(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        boolean force = false;
        if (jsonparam.containsKey((Object)"force")) {
            force = jsonparam.getBoolean("force");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        bean.initUpdateMember(session);
        Object voiddata = this.doBillVoid(bean, session, force);
        JSONObject json = new JSONObject();
        if (!force && voiddata != null) {
            json.put("data", voiddata);
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u4f5c\u5e9f\u4e0d\u6210\u529f,\u9700\u518d\u6b21\u786e\u8ba4!"));
        } else {
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u4f5c\u5e9f\u6210\u529f!"));
        }
        return ServiceResponse.buildSuccess(json);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object doBillVoid(BillAbstractHeadBean bill, ServiceSession session, boolean force) throws Exception {
        BillAbstractHeadBean oribill = this.checkBillStatus(bill);
        if ("C".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u5df2\u4f5c\u5e9f,\u4e0d\u80fd\u91cd\u590d\u4f5c\u5e9f!", oribill.getBillno());
        }
        if (!"Y".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5df2\u5ba1\u6838\u5355\u636e,\u4e0d\u80fd\u4f5c\u5e9f!", oribill.getBillno());
        }
        bill.setBillmoduleid(oribill.getBillmoduleid());
        bill.setBillstatus(null);
        Set<String> keys = this.beforeBillVoid(bill);
        if (StringUtils.isEmpty((Object)bill.getBillstatus()) || "Y".equalsIgnoreCase(bill.getBillstatus())) {
            bill.setBillstatus("C");
        }
        if (StringUtils.isEmpty((Object)bill.getCanceler()) && session != null) {
            bill.setCanceler(session.getUser_code());
        }
        if (StringUtils.isEmpty((Object)bill.getCanceler_name()) && session != null) {
            bill.setCanceler_name("[" + session.getUser_code() + "]" + session.getUser_name());
        }
        bill.setCanceldate(new Date());
        bill.setLastmodby(bill.getCanceler());
        bill.setLastmodby_name(bill.getCanceler_name());
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        keys.add("canceler");
        keys.add("canceler_name");
        keys.add("canceldate");
        super.doUpdate(bill, keys, "billno", new String[0]);
        this.billOperLog(session, bill, "\u4f5c\u5e9f", "");
        return null;
    }

    protected Set<String> beforeBillVoid(BillAbstractHeadBean bill) throws Exception {
        if ("WAITTING".equalsIgnoreCase(bill.getBillsgno())) {
            bill.setBillstatus("W");
        }
        return null;
    }

    @Override
    protected List<?> doGet(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception {
        if (!(jsonparam == null || StringUtils.isEmpty((Object)jsonparam.getString("mktid")) && StringUtils.isEmpty((Object)jsonparam.getString("chid")))) {
            JSONObject json;
            Field mktfld = AbstractEntityBean.fetchDeclaredField(objClass, "billmktdetail");
            Field chlfld = AbstractEntityBean.fetchDeclaredField(objClass, "billchanneldetail");
            if (mktfld != null && !StringUtils.isEmpty((Object)jsonparam.get((Object)"mktid"))) {
                Object mktobj = jsonparam.get((Object)"mktid");
                jsonparam.remove((Object)"mktid");
                if (mktobj instanceof JSONObject) {
                    jsonparam.put("billmktdetail:mktid", mktobj);
                } else {
                    json = new JSONObject();
                    json.put("$in", (Object)(mktobj + ",%"));
                    jsonparam.put("billmktdetail:mktid", (Object)json);
                }
            }
            if (chlfld != null && !StringUtils.isEmpty((Object)jsonparam.get((Object)"chid"))) {
                Object chlobj = jsonparam.get((Object)"chid");
                jsonparam.remove((Object)"chid");
                if (chlobj instanceof JSONObject) {
                    jsonparam.put("billchanneldetail:chid", chlobj);
                } else {
                    json = new JSONObject();
                    json.put("$in", (Object)(chlobj + ",%"));
                    jsonparam.put("billchanneldetail:chid", (Object)json);
                }
            }
        }
        return super.doGet(jsonparam, objClass, total);
    }

    public BillOperLogService getOperlog() {
        if (this.operlog == null) {
            this.operlog = BillOperLogSrvImpl.getLog();
        }
        return this.operlog;
    }

    public void setOperlog(BillOperLogService operlog) {
        this.operlog = operlog;
    }

    protected Field getBillKeyField() throws IllegalArgumentException, IllegalAccessException {
        if (!StringUtils.isEmpty((Object)this.getBillKey())) {
            Field idfld = AbstractEntityBean.fetchDeclaredField(this.getBeanClass(), this.getBillKey());
            return idfld;
        }
        return null;
    }

    protected String getBillKey() throws IllegalArgumentException, IllegalAccessException {
        return this.getBillKey(null);
    }

    protected String getBillKey(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "BILL_KEY");
        if (fld == null) {
            return null;
        }
        return (String)fld.get(null);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billsubmit(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        Object submitdata = this.dobillsubmit(bean, session, StringUtils.isEmpty((Object)jsonparam.get((Object)"cc")) ? null : (List)jsonparam.get((Object)"cc"));
        JSONObject json = new JSONObject();
        json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u63d0\u4ea4\u6210\u529f!"));
        return ServiceResponse.buildSuccess(json);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billapproveforthird(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0}\u4e3a\u7a7a", "", "billno");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        this.dobillthirdbpmexec(bean, "A", session, jsonparam.getString("billislast"));
        JSONObject jsonrtn = new JSONObject();
        jsonrtn.put("msg", (Object)("\u5355\u636e [" + jsonparam.get((Object)"billno") + "] \u5ba1\u6838\u6210\u529f!"));
        return ServiceResponse.buildSuccess(jsonrtn);
    }

    public String getprocessdefkey(ServiceSession session, BillAbstractHeadBean bill) throws Exception {
        Map<String, Object> bpmconfig = this.getModuleBpmConfig(session, bill);
        String processdefkey = "BPM" + bill.getBillmoduleid();
        if (bpmconfig != null && !StringUtils.isEmpty((Object)bpmconfig.get("billisworkflow"))) {
            String[] s = bpmconfig.get("billisworkflow").toString().split("\\|");
            if (StringUtils.isEmpty((Object)s) || s.length == 0 || StringUtils.isEmpty((Object)s[0]) || !"Y".equals(s[0])) {
                throw new ServiceException("10000", "[{0}]\u6a21\u5757\u672a\u542f\u7528\u5ba1\u6279\u6d41\uff0c\u8bf7\u68c0\u67e5!", bill.getBillmoduleid());
            }
            if (s.length > 1) {
                processdefkey = s[1];
            }
        } else {
            throw new ServiceException("10000", "[{0}]\u6a21\u5757\u672a\u542f\u7528\u5ba1\u6279\u6d41\uff0c\u8bf7\u68c0\u67e5!", bill.getBillmoduleid());
        }
        return processdefkey;
    }

    public Map<String, Object> getModuleBpmConfig(ServiceSession session, BillAbstractHeadBean bill) throws Exception {
        JSONObject param = new JSONObject();
        param.put("moduleCode", (Object)bill.getBillmoduleid());
        ServiceResponse resp = RestClientUtils.getRestUtils().sendRequest(session, "efuture.uiconfig.search", param.toString());
        JSONObject rtnjson = (JSONObject)resp.getData();
        return (JSONObject)rtnjson.getJSONArray("uiconfig").get(0);
    }

    public JSONObject getbpmvariable(BillAbstractHeadBean bill, ServiceSession session) {
        JSONObject obj = (JSONObject)Utils.toNormalJSONObject(bill);
        obj.put("rolecode", (Object)session.getRolecode());
        return obj;
    }

    public Object getmuid(BillAbstractHeadBean bill, ServiceSession session) {
        Object muid = null;
        try {
            muid = AbstractEntityBean.fetchDeclaredField(bill.getClass(), "muid").get(bill);
        }
        catch (Exception e) {
            muid = session.getDeptcode();
            e.printStackTrace();
        }
        return muid;
    }

    public Map<String, Object> getbpminfo(BillAbstractHeadBean bill, ServiceSession session, boolean getvariable, String billstatus) throws Exception {
        bill.setBillstatus(billstatus);
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        String processdefkey = this.getprocessdefkey(session, bill);
        rtn.put("processdefkey", processdefkey);
        rtn.put("billid", bill.getBillno());
        rtn.put("billno", bill.getBillno());
        rtn.put("userid", session.getUser_code());
        Object muid = null;
        if (billstatus.equalsIgnoreCase("A") || billstatus.equalsIgnoreCase("R")) {
            muid = session.getDeptcode();
        } else {
            String billsource = null;
            try {
                billsource = AbstractEntityBean.fetchDeclaredField(bill.getClass(), "billsource").get(bill) == null ? "MSS" : AbstractEntityBean.fetchDeclaredField(bill.getClass(), "billsource").get(bill);
            }
            catch (Exception e) {
                billsource = "MSS";
            }
            muid = billsource.toString().equalsIgnoreCase("APP") ? this.getmuid(bill, session) : session.getDeptcode();
        }
        rtn.put("unitcode", muid);
        rtn.put("positionid", session.getPostid());
        rtn.put("billimoduleid", bill.getBillmoduleid());
        System.out.println("\u5ba1\u6279\u6d41\u53c2\u6570:" + ((Object)rtn).toString());
        if (getvariable) {
            JSONObject info = this.getbpmvariable(bill, session);
            info.put("billstatus", (Object)billstatus);
            rtn.put("variable", this.getbpmvariable(bill, session));
        }
        return rtn;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object dobillsubmit(BillAbstractHeadBean bill, ServiceSession session, List<String> cc) throws Exception {
        String status;
        bill.initUpdateMember(session);
        BillAbstractHeadBean oribill = this.checkBillStatus(bill);
        Map<String, Object> bpmconfig = this.getModuleBpmConfig(session, oribill);
        String string = status = StringUtils.isEmpty((Object)bpmconfig.get("billwfstartflag")) ? "N" : bpmconfig.get("billwfstartflag").toString();
        if ("S".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u63d0\u4ea4,\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4!", oribill.getBillno());
        }
        if (!status.equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u672a\u63d0\u4ea4\u72b6\u6001,\u4e0d\u80fd\u63d0\u4ea4!", oribill.getBillno());
        }
        bill.setBillmoduleid(oribill.getBillmoduleid());
        bill.setBillstatus("S");
        bill.setLastmodby(Utils.nvl(session.getUser_code(), oribill.getInputer()));
        bill.setLastmodby_name("[" + Utils.nvl(session.getUser_code(), oribill.getInputer()) + "]" + Utils.nvl(session.getUser_name(), oribill.getInputer_name()));
        Set<String> keys = this.beforeBillsubmit(session, oribill);
        Map<String, Object> bpminfo = this.getbpminfo(oribill, session, true, "S");
        if (!StringUtils.isEmpty(cc) && cc.size() > 0) {
            bpminfo.put("cc", cc);
        }
        BpmService.getBpmService().submit(bpminfo);
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        super.doUpdate(oribill, keys, "billno", new String[0]);
        this.billOperLog(session, bill, "\u63d0\u4ea4", "");
        Set<String> postkeys = this.PostBillsubmit(session, oribill);
        return null;
    }

    public void billOperLog(ServiceSession session, BillAbstractHeadBean bill, String opertype, String memo) {
        if (this.getOperlog() != null) {
            this.getOperlog().log(session, session.getUser_code(), session.getUsercodename(), opertype, memo, bill);
        }
    }

    public Set<String> PostBillsubmit(ServiceSession session, BillAbstractHeadBean bill) {
        return null;
    }

    public Set<String> beforeBillsubmit(ServiceSession session, BillAbstractHeadBean bill) {
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billsaveandsubmit(ServiceSession session, JSONObject jsonparam) throws Exception {
        ServiceResponse sre = this.add(session, jsonparam.toJSONString());
        if (!sre.getReturncode().equals("0")) {
            return sre;
        }
        JSONObject rtn = (JSONObject)sre.getData();
        long id = (Long)rtn.get((Object)this.getIdKey());
        JSONObject json = new JSONObject();
        json.put("fields", (Object)"*");
        json.put("ent_id", (Object)session.getEnt_id());
        json.put(this.getIdKey(), (Object)id);
        BillAbstractHeadBean oribill = (BillAbstractHeadBean)this.doSearchOne(json, this.getBeanClass());
        try {
            this.dobillsubmit(oribill, session, StringUtils.isEmpty((Object)jsonparam.get((Object)"cc")) ? null : (List)jsonparam.get((Object)"cc"));
        }
        catch (Exception e) {
            this.doDelete(oribill, "ph_key", new String[0]);
            return ServiceResponse.buildFailure(session, "10000", "\u63d0\u4ea4\u5ba1\u6279\u9519\u8bef:{0}", e.getMessage());
        }
        JSONObject jsonrtn = new JSONObject();
        jsonrtn.put(this.getIdKey(), (Object)id);
        jsonrtn.put("billno", (Object)oribill.getBillno());
        jsonrtn.put("msg", (Object)"\u5355\u636e\u63d0\u4ea4\u6210\u529f!");
        return ServiceResponse.buildSuccess(jsonrtn);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billapproval(ServiceSession session, JSONObject jsonparam) throws Exception {
        return this.billbpmexec(session, jsonparam, "A");
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billreject(ServiceSession session, JSONObject jsonparam) throws Exception {
        return this.billbpmexec(session, jsonparam, "R");
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billrepeal(ServiceSession session, JSONObject jsonparam) throws Exception {
        return this.billbpmexec(session, jsonparam, "N");
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billbpmexec(ServiceSession session, JSONObject jsonparam, String billstatus) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        this.dobillbpmexec(bean, jsonparam.getString("comment"), jsonparam.getString("taskid"), billstatus, session, jsonparam);
        JSONObject jsonrtn = new JSONObject();
        jsonrtn.put("msg", (Object)("\u5355\u636e [" + jsonparam.get((Object)"billno") + "] " + this.getstatusname(billstatus) + "\u6210\u529f!"));
        return ServiceResponse.buildSuccess(jsonrtn);
    }

    public String getstatusname(String billstatus) {
        if (this.STATUSNAME.size() <= 0) {
            this.STATUSNAME.put("N", "\u64a4\u9500");
            this.STATUSNAME.put("A", "\u5ba1\u6279");
            this.STATUSNAME.put("S", "\u63d0\u4ea4");
            this.STATUSNAME.put("R", "\u9a73\u56de");
            this.STATUSNAME.put("J", "\u52a0\u7b7e");
        }
        return this.STATUSNAME.get(billstatus);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse gettask(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        JSONObject json = new JSONObject();
        json.put("fields", (Object)"*");
        json.put("ent_id", (Object)session.getEnt_id());
        json.put("billno", jsonparam.get((Object)"billno"));
        BillAbstractHeadBean oribill = null;
        try {
            oribill = (BillAbstractHeadBean)this.doSearchOne(json, this.getBeanClass());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Map<String, Object> bpmdata = this.getbpminfo(oribill, session, true, oribill.getBillstatus());
        ServiceResponse resp = BpmService.getBpmService().gettask(bpmdata);
        return resp;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object dobillbpmexec(T bill, String comment, String taskid, String billstatus, ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject json;
        ((BillAbstractHeadBean)bill).initUpdateMember(session);
        String name = this.getstatusname(billstatus);
        bill = this.checkBillStatus((BillAbstractHeadBean)bill);
        if (!(((BillAbstractHeadBean)bill).getBillstatus().equalsIgnoreCase("S") || ((BillAbstractHeadBean)bill).getBillstatus().equalsIgnoreCase("A") || ((BillAbstractHeadBean)bill).getBillstatus().equalsIgnoreCase("R"))) {
            throw new ServiceException("10000", "\u5355\u636e[{0}]\u53ea\u6709\u63d0\u4ea4\u548c\u5ba1\u6279\u4e2d\u72b6\u6001\u65f6\u624d\u80fd\u6267\u884c{1}!", ((BillAbstractHeadBean)bill).getBillno(), name);
        }
        if (((BillAbstractHeadBean)bill).getBillstatus().equalsIgnoreCase("R") && !billstatus.equalsIgnoreCase("N")) {
            throw new ServiceException("10000", "\u5355\u636e[{0}]\u5df2\u88ab\u9a73\u56de,\u4e0d\u80fd\u6267\u884c{1}\u64cd\u4f5c!", ((BillAbstractHeadBean)bill).getBillno(), name);
        }
        ((BillAbstractHeadBean)bill).setLastmodby(Utils.nvl(session.getUser_code(), ((BillAbstractHeadBean)bill).getInputer()));
        ((BillAbstractHeadBean)bill).setLastmodby_name("[" + Utils.nvl(session.getUser_code(), ((BillAbstractHeadBean)bill).getInputer()) + "]" + Utils.nvl(session.getUser_name(), ((BillAbstractHeadBean)bill).getInputer_name()));
        HashSet<String> keys = null;
        Map<String, Object> bpminfo = null;
        bpminfo = this.getbpminfo((BillAbstractHeadBean)bill, session, true, billstatus);
        bpminfo.put("comment", comment);
        if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"addTaskInfo"))) {
            bpminfo.put("addTaskInfo", jsonparam.get((Object)"addTaskInfo"));
        }
        if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"cc"))) {
            bpminfo.put("cc", jsonparam.get((Object)"cc"));
        }
        ServiceResponse resp = null;
        if (billstatus.equalsIgnoreCase("A")) {
            resp = BpmService.getBpmService().approval(bpminfo);
        } else if (billstatus.equalsIgnoreCase("R")) {
            resp = BpmService.getBpmService().reject(bpminfo);
            this.notification((BillAbstractHeadBean)bill, billstatus);
        } else if (billstatus.equalsIgnoreCase("N")) {
            BpmService.getBpmService().repeal(bpminfo);
        } else if (billstatus.equalsIgnoreCase("J")) {
            BpmService.getBpmService().addtask(bpminfo);
        }
        if (!(StringUtils.isEmpty((Object)resp) || StringUtils.isEmpty((Object)resp.getData()) || StringUtils.isEmpty((Object)(json = JSONObject.parseObject((String)resp.getData().toString()))) || StringUtils.isEmpty((Object)json.get((Object)"ismulti")) || !"Y".equals(json.getString("ismulti")))) {
            ((BillAbstractHeadBean)bill).setBillstatus(json.getString("billstatus"));
        }
        if (billstatus.equalsIgnoreCase("J")) {
            ((BillAbstractHeadBean)bill).setBillstatus("A");
        }
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        super.doUpdate((AbstractEntityBean)bill, keys, "billno", new String[0]);
        this.billOperLog(session, (BillAbstractHeadBean)bill, name, comment);
        if (billstatus.equalsIgnoreCase("A")) {
            String islast;
            if (!StringUtils.isEmpty((Object)resp) && !StringUtils.isEmpty((Object)resp.getData()) && (islast = (json = JSONObject.parseObject((String)resp.getData().toString())).getString("islast")).equals("Y")) {
                this.doReturnStatus(session, (BillAbstractHeadBean)bill);
                this.doBillAudit(bill, session, true);
                this.notification((BillAbstractHeadBean)bill, billstatus);
            }
        } else if (billstatus.equalsIgnoreCase("N")) {
            this.doReturnStatus(session, (BillAbstractHeadBean)bill);
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void doReturnStatus(ServiceSession session, BillAbstractHeadBean bill) throws Exception {
        HashSet<String> keys = new HashSet<String>();
        keys.add("billstatus");
        Map<String, Object> bpmConfig = this.getModuleBpmConfig(session, bill);
        String status = StringUtils.isEmpty((Object)bpmConfig.get("billwfstartflag")) ? "N" : bpmConfig.get("billwfstartflag").toString();
        bill.setBillstatus(status);
        super.doUpdate(bill, keys, "billno", new String[0]);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object dobillthirdbpmexec(T bill, String billstatus, ServiceSession session, String lastflag) throws Exception {
        ((BillAbstractHeadBean)bill).initUpdateMember(session);
        String name = this.getstatusname(billstatus);
        BillAbstractHeadBean oribill = this.checkBillStatus((BillAbstractHeadBean)bill);
        if (!(oribill.getBillstatus().equalsIgnoreCase("S") || oribill.getBillstatus().equalsIgnoreCase("A") || oribill.getBillstatus().equalsIgnoreCase("R"))) {
            throw new ServiceException("10000", "\u5355\u636e[{0}]\u53ea\u6709\u63d0\u4ea4\u548c\u5ba1\u6279\u4e2d\u72b6\u6001\u65f6\u624d\u80fd\u6267\u884c{1}!", oribill.getBillno(), name);
        }
        if (oribill.getBillstatus().equalsIgnoreCase("R") && !billstatus.equalsIgnoreCase("N")) {
            throw new ServiceException("10000", "\u5355\u636e[{0}]\u5df2\u88ab\u9a73\u56de,\u4e0d\u80fd\u6267\u884c{1}\u64cd\u4f5c!", oribill.getBillno(), name);
        }
        ((BillAbstractHeadBean)bill).setBillmoduleid(oribill.getBillmoduleid());
        ((BillAbstractHeadBean)bill).setBillstatus(billstatus);
        ((BillAbstractHeadBean)bill).setLastmodby(Utils.nvl(session.getUser_code(), oribill.getInputer()));
        ((BillAbstractHeadBean)bill).setLastmodby_name("[" + Utils.nvl(session.getUser_code(), oribill.getInputer()) + "]" + Utils.nvl(session.getUser_name(), oribill.getInputer_name()));
        HashSet<String> keys = null;
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        super.doUpdate((AbstractEntityBean)bill, (Set<String>)keys, "billno", new String[0]);
        this.billOperLog(session, (BillAbstractHeadBean)bill, name, null);
        if (billstatus.equalsIgnoreCase("A") && lastflag.equalsIgnoreCase("Y")) {
            this.doBillAudit(bill, session, false);
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void notification(BillAbstractHeadBean bill, String billstatus) {
        String postid;
        String userid;
        String Notitype;
        String notiinfo;
        String title;
        String billsource = null;
        try {
            billsource = AbstractEntityBean.fetchDeclaredField(bill.getClass(), "billsource").get(bill) == null ? "MSS" : AbstractEntityBean.fetchDeclaredField(bill.getClass(), "billsource").get(bill).toString();
        }
        catch (Exception e) {
            billsource = "MSS";
        }
        if (billstatus.equalsIgnoreCase("A")) {
            title = "\u5355\u636e\u5ba1\u6279\u63d0\u9192";
            notiinfo = "\u5355\u53f7\u3010" + bill.getBillno() + "\u3011\u5df2\u5ba1\u6279\u901a\u8fc7";
            Notitype = "\u5355\u636e\u5ba1\u6279\u63d0\u9192";
        } else if (billstatus.equalsIgnoreCase("R")) {
            title = "\u5355\u636e\u5ba1\u6279\u63d0\u9192";
            notiinfo = "\u5355\u53f7\u3010" + bill.getBillno() + "\u3011\u5df2\u88ab\u9a73\u56de";
            Notitype = "\u5355\u636e\u5ba1\u6279\u63d0\u9192";
        } else {
            return;
        }
        if (billsource.equalsIgnoreCase("APP")) {
            try {
                userid = AbstractEntityBean.fetchDeclaredField(bill.getClass(), "sbid").get(bill).toString();
            }
            catch (Exception e) {
                userid = bill.getInputer();
            }
            postid = "99999999";
        } else {
            userid = bill.getInputer();
            postid = "0";
        }
        this.insertnotification(postid, userid, bill.getBillmoduleid(), bill.getBillno(), notiinfo, title, Notitype);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void insertnotification(String postid, String userid, String moduleid, String billno, String notiinfo, String title, String Notitype) {
        FMybatisTemplate storage = null;
        try {
            storage = this.getStorageOperations(FMybatisTemplate.class);
            String sql = "CALL DBUSRPUB.INSERT_NOTIFICATION('" + postid + "','" + userid + "','" + moduleid + "','" + billno + "','" + notiinfo + "','" + title + "','" + Notitype + "')";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", sql);
            storage.getSqlSessionTemplate().insert("mybatis.sql.insert", map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ServiceResponse get(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            String ignorefilter = this.getParamWithCheck(jsonparam, "ignorefilter", false, "N");
            if (jsonparam.containsKey((Object)"ignorefilter")) {
                jsonparam.remove((Object)"ignorefilter");
            }
            String idkey = this.getIdKey();
            String table = this.getBeanTable();
            String masterkey = this.getMasterSlaveKey();
            if (!(jsonparam.containsKey((Object)idkey) && !StringUtils.isEmpty((Object)jsonparam.get((Object)idkey)) || jsonparam.containsKey((Object)masterkey) && !StringUtils.isEmpty((Object)jsonparam.get((Object)masterkey)))) {
                return ServiceResponse.buildFailure(session, "50004", "{0} {1} is empty", table, idkey);
            }
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            Object obj = null;
            obj = StringUtils.isEmpty((Object)jsonparam.get((Object)"fields")) ? (Object)this.doSearchOne(jsonparam, this.getBeanClass()) : this.doSearchOneForMap(jsonparam, this.getBeanClass());
            if (obj == null) {
                return ServiceResponse.buildFailure(session, "10003", "{0} {1} [{2}] does not exist", table, idkey, jsonparam.getLong(idkey));
            }
            if ("N".equals(ignorefilter)) {
                obj = this.filter(obj, this.getBeanClass());
            }
            JSONObject respdata = new JSONObject();
            respdata.put(table, obj);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public ServiceResponse getBillSubmitter(ServiceSession session, JSONObject jsonparam) throws Exception {
        jsonparam.put("billid", (Object)((String)jsonparam.get((Object)"billno")));
        return BpmService.getBpmService().getsubmitter((Map<String, Object>)jsonparam);
    }

    public double DiffDate(String curdate, String comparedate) throws ParseException {
        Date now = this.sdf.parse(curdate);
        Date date = this.sdf.parse(comparedate);
        long l = now.getTime() - date.getTime();
        long day = l / 86400000L;
        long hour = l / 3600000L - day * 24L;
        long min = l / 60000L - day * 24L * 60L - hour * 60L;
        long s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        return s;
    }

    @Override
    public ServiceResponse sheetAuditLog(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"billid"))) {
            jsonparam.put("billno", (Object)((String)jsonparam.get((Object)"billid")));
        }
        return BpmService.getBpmService().auditlog((Map<String, Object>)jsonparam);
    }

    @Override
    public ServiceResponse getProcessList(ServiceSession session, JSONObject jsonparam) throws Exception {
        return BpmService.getBpmService().processList((Map<String, Object>)jsonparam);
    }

    @Override
    public ServiceResponse getUserList(ServiceSession session, JSONObject jsonparam) throws Exception {
        return BpmService.getBpmService().getuserlist((Map<String, Object>)jsonparam);
    }

    @Override
    public ServiceResponse getUserGroupList(ServiceSession session, JSONObject jsonparam) throws Exception {
        return BpmService.getBpmService().getgrouplist((Map<String, Object>)jsonparam);
    }

    @Override
    public ServiceResponse billaddtask(ServiceSession session, JSONObject jsonparam) throws Exception {
        return this.billbpmexec(session, jsonparam, "J");
    }

    public static interface BillSource {
        public static final String APP = "APP";
        public static final String MSS = "MSS";
    }

    public static interface BillStatus {
        public static final String NEW = "N";
        public static final String GENRATE = "M";
        public static final String AUDIT = "Y";
        public static final String CANCEL = "C";
        public static final String WAIT = "W";
        public static final String EXEC = "T";
        public static final String AUDITING = "A";
        public static final String SUBMIT = "S";
        public static final String REJECT = "R";
        public static final String ERR = "E";
        public static final String PAY = "P";
        public static final String ADDTASK = "J";
        public static final String EFFECT = "X";
    }
}

