/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.annotation.CallTime;
import com.efuture.ocp.common.cache.CacheUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.rubyeye.xmemcached.GetsResponse;

public class CacheUtilsInMemoryObject
extends CacheUtils
implements Serializable {
    private static final Map<String, Object> CACHE_MAP = new ConcurrentHashMap<String, Object>();
    private static final String EXPIREKEY = "_ExpireTime";

    @Override
    @CallTime(Service="OCP", KeyArgIndex=0)
    public String putData(String key, Object object, int timeout) {
        CACHE_MAP.put(key, object);
        CACHE_MAP.put(key.concat(EXPIREKEY), System.currentTimeMillis() + (long)timeout * 1000L);
        return key;
    }

    @Override
    @CallTime(Service="OCP", KeyArgIndex=0)
    public Object getData(String key) {
        if (CacheUtilsInMemoryObject.checkCacheName(key)) {
            return CACHE_MAP.get(key);
        }
        return null;
    }

    @Override
    public Object getCacheData(String key) {
        return null;
    }

    @Override
    public boolean deleteData(String key) {
        CacheUtilsInMemoryObject.remove(key);
        return true;
    }

    @Override
    public long getCasValue(String key) {
        return 0L;
    }

    @Override
    public GetsResponse getCasData(String key) {
        return null;
    }

    @Override
    public boolean putbyCas(String key, Object object, int timeout, long casvalue) {
        return false;
    }

    public Object getCacheType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteBatch(String key) {
        int result = 0;
        for (Map.Entry<String, Object> entry : CACHE_MAP.entrySet()) {
            if (!entry.getKey().contains(key)) continue;
            CacheUtilsInMemoryObject cacheUtilsInMemoryObject = this;
            synchronized (cacheUtilsInMemoryObject) {
                CacheUtilsInMemoryObject.remove(entry.getKey());
                ++result;
            }
        }
        return result;
    }

    @Override
    public boolean tryLock(String lockKey, String lockId, int timeout, int waitTime) {
        return false;
    }

    @Override
    public int releaseLock(String lockKey, int timeout, String lockId) {
        return 0;
    }

    public static void removeAll() {
        CACHE_MAP.clear();
    }

    public static void remove(String cacheName) {
        CACHE_MAP.remove(cacheName);
        CACHE_MAP.remove(cacheName.concat(EXPIREKEY));
    }

    public static boolean checkCacheName(String cacheName) {
        Long cacheHoldTime = (Long)CACHE_MAP.get(cacheName.concat(EXPIREKEY));
        if (cacheHoldTime == null || cacheHoldTime == 0L) {
            return false;
        }
        if (cacheHoldTime < System.currentTimeMillis()) {
            CacheUtilsInMemoryObject.remove(cacheName);
            return false;
        }
        return true;
    }
}

