/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.WebPathUtils;
import com.google.code.yanf4j.core.impl.StandardSocketOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.GetsResponse;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class CacheUtilsMemcached
extends CacheUtils
implements Serializable {
    private MemcachedClientBuilder builder = null;
    private MemcachedClient memcachedClient = null;
    private boolean reBuild = false;
    private String cfgFile = null;
    private int cachetime = -1;
    public Logger logger = Logger.getLogger(CacheUtilsMemcached.class);

    public CacheUtilsMemcached() {
        this(null);
    }

    public CacheUtilsMemcached(String config) {
        this(config, -1);
    }

    public CacheUtilsMemcached(String config, int cachetime) {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    private MemcachedClient getClient() throws FileNotFoundException, IOException {
        if (this.memcachedClient == null) {
            this.CreateBuilder();
        }
        return this.memcachedClient;
    }

    @Override
    public String putData(String key, Object object, int timeout) {
        if (this.memcachedClient == null) {
            try {
                this.CreateBuilder();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            if (timeout < 0) {
                timeout = this.cachetime > 0 ? this.cachetime : 0;
            }
            this.memcachedClient.set(key, timeout, object);
            return key;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            if (this.reBuild) {
                this.logger.warn((Object)"memcached Client ReBuild!!!!!!!!!!!");
                this.builder = null;
                this.memcachedClient = null;
            }
            return null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
        catch (MemcachedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getData(String key) {
        if (this.memcachedClient == null) {
            try {
                this.CreateBuilder();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        Object result = null;
        try {
            result = this.memcachedClient.get(key);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            if (this.reBuild) {
                this.logger.warn((Object)"memcached Client ReBuild!!!!!!!!!!!");
                this.builder = null;
                this.memcachedClient = null;
            }
            return null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
        catch (MemcachedException e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    @Override
    public Object getCacheData(String key) {
        return this.getData(key);
    }

    @Override
    public boolean deleteData(String key) {
        if (this.memcachedClient == null) {
            try {
                this.CreateBuilder();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            this.memcachedClient.delete(key);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            if (this.reBuild) {
                this.logger.warn((Object)"memcached Client ReBuild!!!!!!!!!!!");
                this.builder = null;
                this.memcachedClient = null;
            }
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        catch (MemcachedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized MemcachedClient CreateBuilder() throws FileNotFoundException, IOException {
        String p;
        if (this.memcachedClient != null) {
            return this.memcachedClient;
        }
        String ini = null;
        String ini0 = null;
        boolean useconfig = false;
        if (this.config != null && StringUtils.isEmpty((Object)this.cfgFile)) {
            useconfig = true;
        } else if (StringUtils.isEmpty((Object)this.cfgFile)) {
            p = WebPathUtils.getWebRootClassPath();
            ini = p + "/memcached.ini";
            ini0 = p + "/conf/memcached.ini";
        } else if (this.cfgFile.startsWith("\\") || this.cfgFile.startsWith("/")) {
            p = WebPathUtils.getWebRootClassPath();
            ini = p + this.cfgFile;
            ini0 = p + "/conf" + this.cfgFile;
        } else {
            ini = this.cfgFile;
        }
        String serverList = "localhost:11211";
        int iPoolSize = 10;
        int iTimeOut = 5000;
        int iMerge = 150;
        boolean bHeart = true;
        int iRcvBuf = 32;
        int iSndBuf = 16;
        File input = null;
        if (!StringUtils.isEmpty((Object)ini)) {
            input = new File(ini);
            if (ini0 != null && !input.exists()) {
                input = new File(ini0);
            }
        }
        this.logger.info((Object)("memcached.ini path:" + ini));
        if (!useconfig && input != null && input.exists()) {
            String re;
            String sHeart;
            String sMerge;
            String sTimeOut;
            String sSndBuf;
            String sRcvBuf;
            String sPoolSize;
            FileInputStream is = new FileInputStream(input);
            Properties p2 = new Properties();
            p2.load(is);
            ((InputStream)is).close();
            String sServer = p2.getProperty("server");
            if (sServer != null) {
                sServer = sServer.replaceAll(";", " ");
                serverList = sServer.trim();
            }
            if ((sPoolSize = p2.getProperty("poolsize")) != null) {
                iPoolSize = Integer.parseInt(sPoolSize);
            }
            if ((sRcvBuf = p2.getProperty("rcvbuf")) != null) {
                iRcvBuf = Integer.parseInt(sRcvBuf);
            }
            if ((sSndBuf = p2.getProperty("sndbuf")) != null) {
                iSndBuf = Integer.parseInt(sSndBuf);
            }
            if ((sTimeOut = p2.getProperty("timeout")) != null) {
                iTimeOut = Integer.parseInt(sTimeOut);
            }
            if ((sMerge = p2.getProperty("merge")) != null) {
                iMerge = Integer.parseInt(sMerge);
            }
            if ((sHeart = p2.getProperty("heart")) != null) {
                boolean bl = bHeart = sHeart == null || !sHeart.equalsIgnoreCase("false");
            }
            if ((re = p2.getProperty("rebuild")) != null) {
                this.reBuild = re != null && re.equalsIgnoreCase("true");
            }
            this.logger.info((Object)("memcached server:" + serverList));
        } else if (useconfig) {
            serverList = this.config.getServerList().trim();
            serverList = serverList.replaceAll(";", " ");
            iPoolSize = this.config.getPoolsize();
            iRcvBuf = this.config.getRcvbuf();
            iSndBuf = this.config.getSndbuf();
            iTimeOut = this.config.getTimeout();
            iMerge = this.config.getMerge();
            bHeart = this.config.isHeart();
            this.reBuild = this.config.isRebuild();
        } else {
            this.logger.warn((Object)"memcached.ini not exits!");
            serverList = "localhost:11211";
            iPoolSize = 2;
            System.out.println("memcached server-\u5730\u5740:localhost:11211");
        }
        this.builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)serverList));
        this.builder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
        this.builder.setConnectionPoolSize(iPoolSize);
        this.builder.setSocketOption(StandardSocketOption.SO_RCVBUF, (Object)(iRcvBuf * 1024));
        this.builder.setSocketOption(StandardSocketOption.SO_SNDBUF, (Object)(iSndBuf * 1024));
        this.builder.setSocketOption(StandardSocketOption.TCP_NODELAY, (Object)false);
        this.memcachedClient = this.builder.build();
        this.memcachedClient.setOpTimeout((long)iTimeOut);
        if (iMerge <= 0) {
            this.memcachedClient.setOptimizeMergeBuffer(false);
        }
        if (iMerge > 0) {
            this.memcachedClient.setMergeFactor(iMerge);
        }
        this.memcachedClient.setEnableHeartBeat(bHeart);
        return this.memcachedClient;
    }

    @Override
    public long getCasValue(String key) {
        if (this.memcachedClient == null) {
            try {
                this.CreateBuilder();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return -1L;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1L;
            }
        }
        try {
            GetsResponse res = this.memcachedClient.gets(key);
            if (res == null) {
                return 0L;
            }
            return res.getCas();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            if (this.reBuild) {
                this.logger.warn((Object)"memcached Client ReBuild!!!!!!!!!!!");
                this.builder = null;
                this.memcachedClient = null;
            }
            return -1L;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return -1L;
        }
        catch (MemcachedException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    @Override
    public boolean putbyCas(String key, Object object, int timeout, long casvalue) {
        if (this.memcachedClient == null) {
            try {
                this.CreateBuilder();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            if (timeout < 0) {
                timeout = this.cachetime > 0 ? this.cachetime : 0;
            }
            return this.memcachedClient.cas(key, timeout, object, casvalue);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            if (this.reBuild) {
                this.logger.warn((Object)"memcached Client ReBuild!!!!!!!!!!!");
                this.builder = null;
                this.memcachedClient = null;
            }
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        catch (MemcachedException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public GetsResponse getCasData(String key) {
        if (this.memcachedClient == null) {
            try {
                this.CreateBuilder();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            GetsResponse res = this.memcachedClient.gets(key);
            return res;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            if (this.reBuild) {
                this.logger.warn((Object)"memcached Client ReBuild!!!!!!!!!!!");
                this.builder = null;
                this.memcachedClient = null;
            }
            return null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
        catch (MemcachedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean AddData(String key, Object object, int timeout) {
        MemcachedClient client;
        try {
            client = this.getClient();
        }
        catch (IOException e) {
            throw new ServiceException("30001", "Memcached\u521b\u5efa\u9519\u8bef!", new Object[0]);
        }
        boolean ibadd = true;
        try {
            ibadd = client.add(key, timeout, object);
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new ServiceException("30002", "\u6267\u884cMem_AddData\u9519\u8bef!", new Object[0]);
        }
        return ibadd;
    }

    @Override
    public boolean tryLock(String lockKey, String lockId, int timeout, int waitTime) {
        return false;
    }

    @Override
    public int releaseLock(String lockKey, int timeout, String lockId) {
        return 0;
    }
}

