/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.SerializeUtil.SerializeUtil;
import com.efuture.ocp.common.cache.CacheUtilsRediscached;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.common.util.WebPathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public class CacheUtilsRedisCluster
extends CacheUtilsRediscached
implements Serializable {
    private JedisCluster jedispool;
    private String cfgFile = null;
    private int cachetime = -1;
    public Logger logger = Logger.getLogger(CacheUtilsRedisCluster.class);

    public CacheUtilsRedisCluster() {
        this(null);
    }

    public CacheUtilsRedisCluster(String config) {
        this(config, -1);
    }

    public CacheUtilsRedisCluster(String config, int cachetime) {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    private JedisCluster getJedis() {
        try {
            if (this.jedispool == null) {
                try {
                    this.jedispool = this.CreateJedisPool();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return this.jedispool;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void returnJedis(JedisCluster jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putData(String key, Object object, int timeout) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        try {
            if (timeout < 0) {
                timeout = this.cachetime > 0 ? this.cachetime : 0;
            }
            jedis.setex(key.getBytes(), timeout, SerializeUtil.serialize(object));
            String string = key;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String key) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        Object result = null;
        try {
            byte[] obj = jedis.get(key.getBytes());
            result = SerializeUtil.unserialize(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteData(String key) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return false;
        }
        try {
            jedis.del(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnJedis(jedis);
        }
        return true;
    }

    private synchronized JedisCluster CreateJedisPool() throws FileNotFoundException, IOException {
        if (this.jedispool != null) {
            return this.jedispool;
        }
        if (this.config != null) {
            String[] str_nodes;
            this.logger.info((Object)"Redis client is creating with configuration.");
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setTestOnBorrow(this.config.isRedisTestOnBorrow());
            poolConfig.setMaxTotal(this.config.getRedisMaxActive());
            poolConfig.setMaxIdle(this.config.getRedisMaxIdle());
            poolConfig.setMinIdle(this.config.getRedisMinIdle());
            poolConfig.setMaxWaitMillis((long)this.config.getRedisMaxWait());
            LinkedHashSet<HostAndPort> node_set = new LinkedHashSet<HostAndPort>();
            for (String str : str_nodes = this.config.getRedisNodes().split(",")) {
                String l_host = str.split(":")[0];
                int l_port = Integer.valueOf(str.split(":")[1]);
                node_set.add(new HostAndPort(l_host, l_port));
            }
            this.jedispool = new JedisCluster(node_set, this.config.getRedisTimeout(), 0, 0, this.config.getRedisPassword(), (GenericObjectPoolConfig)poolConfig);
        } else {
            String p;
            String ini = null;
            String ini0 = null;
            if (StringUtils.isEmpty((Object)this.cfgFile)) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + "/redisCluster.ini";
                ini0 = p + "/conf/redisCluster.ini";
            } else if (this.cfgFile.startsWith("\\") || this.cfgFile.startsWith("/")) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + this.cfgFile;
                ini0 = p + "/conf" + this.cfgFile;
            } else {
                ini = this.cfgFile;
            }
            int maxActive = 100;
            int timeout = 5000;
            int maxIdle = 30;
            int minIdle = 10;
            boolean testOnBorrow = true;
            String nodes = "";
            String host = "localhost";
            int port = 6379;
            int database = 0;
            int maxWait = 5000;
            File input = new File(ini);
            if (ini0 != null && !input.exists()) {
                input = new File(ini0);
            }
            this.logger.info((Object)("redisCluster.ini path:" + ini));
            if (input.exists()) {
                String[] str_nodes;
                String sdatabase;
                String password_prop;
                String password;
                String smaxWait;
                String sport;
                String stestOnBorrow;
                String sminIdle;
                String smaxIdle;
                String stimeout;
                String smaxActive;
                String sServer;
                FileInputStream is = new FileInputStream(input);
                Properties p2 = new Properties();
                p2.load(is);
                ((InputStream)is).close();
                String sNodes = Utils.getEnvValue(p2.getProperty("redis.nodes"));
                if (sNodes != null) {
                    nodes = sNodes.trim();
                }
                if ((sServer = Utils.getEnvValue(p2.getProperty("redis.host"))) != null) {
                    host = sServer.trim();
                }
                if ((smaxActive = p2.getProperty("redis.maxActive")) != null) {
                    maxActive = Integer.parseInt(smaxActive);
                }
                if ((stimeout = p2.getProperty("redis.timeout")) != null) {
                    timeout = Integer.parseInt(stimeout);
                }
                if ((smaxIdle = p2.getProperty("redis.maxIdle")) != null) {
                    maxIdle = Integer.parseInt(smaxIdle);
                }
                if ((sminIdle = p2.getProperty("redis.minIdle")) != null) {
                    minIdle = Integer.parseInt(sminIdle);
                }
                if ((stestOnBorrow = p2.getProperty("redis.testOnBorrow")) != null) {
                    boolean bl = testOnBorrow = stestOnBorrow == null || !stestOnBorrow.equalsIgnoreCase("false");
                }
                if ((sport = Utils.getEnvValue(p2.getProperty("redis.port"))) != null) {
                    port = Integer.parseInt(sport);
                }
                if ((smaxWait = p2.getProperty("redis.maxWait")) != null) {
                    maxWait = Integer.parseInt(smaxWait);
                }
                if ((password = Utils.getEnvValue(password_prop = p2.getProperty("redis.password"))) != null) {
                    password = password.trim();
                }
                if ((sdatabase = Utils.getEnvValue(p2.getProperty("redis.database"))) != null) {
                    database = Integer.parseInt(sdatabase);
                }
                this.logger.info((Object)("rediscached server:" + sNodes));
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow(true);
                config.setMaxTotal(maxActive);
                config.setMaxIdle(maxIdle);
                config.setMinIdle(minIdle);
                config.setMaxWaitMillis((long)maxWait);
                LinkedHashSet<HostAndPort> node_set = new LinkedHashSet<HostAndPort>();
                for (String str : str_nodes = nodes.split(",")) {
                    String l_host = str.split(":")[0];
                    int l_port = Integer.valueOf(str.split(":")[1]);
                    node_set.add(new HostAndPort(l_host, l_port));
                }
                this.jedispool = new JedisCluster(node_set, timeout, 0, 0, null, (GenericObjectPoolConfig)config);
            } else {
                this.logger.warn((Object)"redis.ini not exits!");
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow(true);
                config.setMaxTotal(maxActive);
                config.setMaxIdle(maxIdle);
                config.setMinIdle(minIdle);
                config.setMaxWaitMillis((long)maxWait);
                HostAndPort node = new HostAndPort(host, port);
                this.jedispool = new JedisCluster(node, (GenericObjectPoolConfig)config);
                System.out.println("rediscached server-\u5730\u5740:localhost:" + port);
            }
        }
        return this.jedispool;
    }
}

