/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.SerializeUtil.SerializeUtil;
import com.efuture.ocp.common.cache.CacheUtilsRediscached;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.common.util.WebPathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.rubyeye.xmemcached.GetsResponse;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class CacheUtilsRedisSentinel
extends CacheUtilsRediscached
implements Serializable {
    private JedisSentinelPool jedispool;
    private String cfgFile = null;
    private int cachetime = -1;
    private boolean debug = false;
    public Logger logger = Logger.getLogger(CacheUtilsRedisSentinel.class);

    public CacheUtilsRedisSentinel() {
        this(null);
    }

    public CacheUtilsRedisSentinel(String config) {
        this(config, -1);
    }

    public CacheUtilsRedisSentinel(String config, int cachetime) {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    private Jedis getJedis() {
        try {
            if (this.jedispool == null) {
                try {
                    this.jedispool = this.CreateJedisPool();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return this.jedispool.getResource();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private synchronized JedisSentinelPool CreateJedisPool() throws FileNotFoundException, IOException {
        if (this.jedispool != null) {
            return this.jedispool;
        }
        if (this.config != null) {
            String[] str_nodes;
            this.logger.info((Object)"Redis client is creating with configuration.");
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(this.config.getRedisMaxActive());
            poolConfig.setMaxIdle(this.config.getRedisMaxIdle());
            poolConfig.setMinIdle(this.config.getRedisMinIdle());
            poolConfig.setMaxWaitMillis((long)this.config.getRedisMaxWait());
            HashSet<String> sentinels = new HashSet<String>();
            for (String str : str_nodes = this.config.getRedisNodes().split(",")) {
                sentinels.add(str);
            }
            this.jedispool = new JedisSentinelPool(this.config.getRedisMaster(), sentinels, (GenericObjectPoolConfig)poolConfig, this.config.getRedisTimeout(), this.config.getRedisPassword());
        } else {
            String p;
            String ini = null;
            String ini0 = null;
            if (StringUtils.isEmpty((Object)this.cfgFile)) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + "/redisCluster.ini";
                ini0 = p + "/conf/redisCluster.ini";
            } else if (this.cfgFile.startsWith("\\") || this.cfgFile.startsWith("/")) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + this.cfgFile;
                ini0 = p + "/conf" + this.cfgFile;
            } else {
                ini = this.cfgFile;
            }
            int maxActive = 100;
            int timeout = 5000;
            int maxIdle = 30;
            int minIdle = 10;
            boolean testOnBorrow = true;
            String nodes = "";
            String host = "localhost";
            int port = 6379;
            int database = 0;
            int maxWait = 5000;
            File input = new File(ini);
            if (ini0 != null && !input.exists()) {
                input = new File(ini0);
            }
            this.logger.info((Object)("redisCluster.ini path:" + ini));
            if (input.exists()) {
                String[] str_nodes;
                String password_prop;
                String password;
                String smaxWait;
                String stestOnBorrow;
                String sminIdle;
                String smaxIdle;
                String stimeout;
                String smaxActive;
                FileInputStream is = new FileInputStream(input);
                Properties p2 = new Properties();
                p2.load(is);
                ((InputStream)is).close();
                String sNodes = Utils.getEnvValue(p2.getProperty("redis.nodes"));
                if (sNodes != null) {
                    nodes = sNodes.trim();
                }
                if ((smaxActive = p2.getProperty("redis.maxActive")) != null) {
                    maxActive = Integer.parseInt(smaxActive);
                }
                if ((stimeout = p2.getProperty("redis.timeout")) != null) {
                    timeout = Integer.parseInt(stimeout);
                }
                if ((smaxIdle = p2.getProperty("redis.maxIdle")) != null) {
                    maxIdle = Integer.parseInt(smaxIdle);
                }
                if ((sminIdle = p2.getProperty("redis.minIdle")) != null) {
                    minIdle = Integer.parseInt(sminIdle);
                }
                if ((stestOnBorrow = p2.getProperty("redis.testOnBorrow")) != null) {
                    boolean bl = testOnBorrow = stestOnBorrow == null || !stestOnBorrow.equalsIgnoreCase("false");
                }
                if ((smaxWait = p2.getProperty("redis.maxWait")) != null) {
                    maxWait = Integer.parseInt(smaxWait);
                }
                if ((password = Utils.getEnvValue(password_prop = p2.getProperty("redis.password"))) != null) {
                    password = password.trim();
                }
                String master = Utils.getEnvValue(p2.getProperty("redis.master"));
                String sdatabase = Utils.getEnvValue(p2.getProperty("redis.database"));
                if (sdatabase != null) {
                    database = Integer.parseInt(sdatabase);
                }
                this.logger.info((Object)("redisSentinel server:" + sNodes));
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow(true);
                config.setMaxTotal(maxActive);
                config.setMaxIdle(maxIdle);
                config.setMinIdle(minIdle);
                config.setMaxWaitMillis((long)maxWait);
                HashSet<String> sentinels = new HashSet<String>();
                for (String str : str_nodes = nodes.split(",")) {
                    sentinels.add(str);
                }
                this.jedispool = new JedisSentinelPool(master, sentinels, (GenericObjectPoolConfig)config, timeout, password, database);
            } else {
                this.logger.warn((Object)"redis.ini not exits!");
                throw new FileNotFoundException();
            }
        }
        return this.jedispool;
    }

    private void returnJedis(Jedis jedis) {
        if (jedis != null) {
            try {
                jedis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putData(String key, Object object, int timeout) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        try {
            if (timeout < 0) {
                timeout = this.cachetime > 0 ? this.cachetime : 0;
            }
            jedis.setex(key.getBytes(), timeout, SerializeUtil.serialize(object));
            String string = key;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String key) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        Object result = null;
        try {
            byte[] obj = jedis.get(key.getBytes());
            result = SerializeUtil.unserialize(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getCacheData(String key) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        String result = null;
        try {
            result = jedis.get(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteData(String key) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return false;
        }
        try {
            jedis.del(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnJedis(jedis);
        }
        return true;
    }

    @Override
    public long getCasValue(String key) {
        return 0L;
    }

    @Override
    public GetsResponse getCasData(String key) {
        return null;
    }

    @Override
    public boolean putbyCas(String key, Object object, int timeout, long casvalue) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getBatchData(List<String> keys) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Pipeline pipeline = jedis.pipelined();
            pipeline.multi();
            HashMap<String, Response> resp_map = new HashMap<String, Response>();
            for (String key : keys) {
                resp_map.put(key, pipeline.get(key.getBytes()));
            }
            pipeline.exec();
            pipeline.sync();
            for (String key : keys) {
                result.put(key, SerializeUtil.unserialize((byte[])((Response)resp_map.get(key)).get()));
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean AddData(String key, Object object, int timeout) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return false;
        }
        try {
            String script = "if (redis.call('exists', KEYS[1]) == 0) then    redis.call('hset', KEYS[1], ARGV[2], 1);    redis.call('pexpire', KEYS[1], ARGV[1]);    return 0; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then    redis.call('hincrby', KEYS[1], ARGV[2], 1);    redis.call('pexpire', KEYS[1], ARGV[1]);    return 0; end; return redis.call('pttl', KEYS[1]);";
            Object result = jedis.eval(script, Collections.singletonList(key), Arrays.asList(String.valueOf(timeout * 1000), object.toString()));
            if ("0".equals(result.toString())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = true;
            return bl;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getHashMap(int db, String key) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            jedis.select(db);
            Map val = jedis.hgetAll(key);
            for (Map.Entry e : val.entrySet()) {
                result.put((String)e.getKey(), e.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteBatch(String key) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return 0;
        }
        try {
            Set keys = jedis.keys(key.concat("*"));
            if (keys.size() <= 0) {
                int n = 0;
                return n;
            }
            Pipeline pipeline = jedis.pipelined();
            pipeline.multi();
            for (String str : keys) {
                pipeline.del(str.getBytes());
            }
            pipeline.exec();
            pipeline.sync();
            int n = keys.size();
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getDataText(String key) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        Object result = null;
        try {
            String string = jedis.get(key);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putDataText(String key, Object object, int timeout) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        try {
            if (timeout < 0) {
                timeout = this.cachetime > 0 ? this.cachetime : 0;
            }
            jedis.setex(key, timeout, object.toString());
            String string = key;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tryLock(String lockKey, String lockId, int timeout, int waitTime) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return false;
        }
        Long start = System.currentTimeMillis();
        try {
            while (true) {
                String script = "if (redis.call('exists', KEYS[1]) == 0) then    redis.call('hset', KEYS[1], ARGV[2], 1);    redis.call('pexpire', KEYS[1], ARGV[1]);    return 0; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then    redis.call('hincrby', KEYS[1], ARGV[2], 1);    redis.call('pexpire', KEYS[1], ARGV[1]);    return 0; end; return redis.call('pttl', KEYS[1]);";
                Object result = jedis.eval(script, Collections.singletonList(lockKey), Arrays.asList(String.valueOf(timeout * 1000), lockId));
                if ("0".equals(result.toString())) {
                    boolean bl = true;
                    return bl;
                }
                long l = System.currentTimeMillis() - start;
                if (l >= (long)waitTime) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int releaseLock(String lockKey, int timeout, String lockId) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return 0;
        }
        try {
            String script = "if (redis.call('hexists', KEYS[1], ARGV[2]) == 0) then    return 1; end; local counter = redis.call('hincrby', KEYS[1], ARGV[2], -1); if (counter > 0) then \tredis.call('pexpire', KEYS[1], ARGV[1]); \treturn 0; else \tredis.call('del', KEYS[1]); \treturn 1; end;return 1;";
            Object result = jedis.eval(script, Collections.singletonList(lockKey), Arrays.asList(String.valueOf(timeout * 1000), lockId));
            int n = Integer.parseInt(result.toString());
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchSet(String[] list) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return;
        }
        try {
            jedis.mset(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> batchGet(String[] para) {
        Jedis jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        ArrayList<String> rtn = new ArrayList();
        try {
            rtn = jedis.mget(para);
        }
        catch (Exception e) {
            e.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            this.returnJedis(jedis);
        }
        return rtn;
    }
}

