/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache.redis;

import com.efuture.ocp.common.cache.redis.JedisProxyFactory;
import com.efuture.ocp.common.cache.redis.ObjectBytesExchange;
import com.efuture.ocp.common.cache.redis.RedisConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class JedisManager {
    private static final Log log = LogFactory.getLog(JedisManager.class);
    private static final String cacheType;
    private static JedisPool jedisPool;
    private static JedisCluster jedisCluster;
    private static JedisSentinelPool jedisSentinelPool;
    private static final JedisPoolConfig poolConfig;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getJedisResource() {
        try {
            switch (cacheType) {
                case "redis_cluster": {
                    if (jedisCluster != null) return jedisCluster;
                    log.error((Object)"JedisCluster is not initialized.");
                    throw new IllegalStateException("JedisCluster is not initialized.");
                }
                case "redis_sentinel": {
                    if (jedisSentinelPool == null) {
                        log.error((Object)"JedisSentinelPool is not initialized.");
                        throw new IllegalStateException("JedisSentinelPool is not initialized.");
                    }
                    try (Jedis jedis = jedisSentinelPool.getResource();){
                        Jedis jedis2 = jedis;
                        return jedis2;
                    }
                    catch (NoSuchElementException e) {
                        throw new IllegalStateException("Jedis instance not available from sentinel pool.", e);
                    }
                }
                case "redis": {
                    if (jedisPool == null) {
                        log.error((Object)"JedisPool is not initialized.");
                        throw new IllegalStateException("JedisPool is not initialized.");
                    }
                    try (Jedis jedis = jedisPool.getResource();){
                        Jedis jedis3 = jedis;
                        return jedis3;
                    }
                    catch (NoSuchElementException e) {
                        throw new IllegalStateException("Jedis instance not available from pool.", e);
                    }
                }
            }
            log.error((Object)("Unknown cache type: " + cacheType));
            throw new IllegalStateException("Unknown cache type: " + cacheType);
        }
        catch (JedisConnectionException e) {
            log.error((Object)"Jedis\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("Redis\u8fde\u63a5\u5931\u8d25", e);
        }
        catch (Exception e) {
            log.error((Object)"\u83b7\u53d6Jedis\u8d44\u6e90\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6Redis\u8d44\u6e90\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    public static Set<String> keys(String pattern) {
        Set set;
        block17: {
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                log.error((Object)"Jedis\u8d44\u6e90\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6keys");
                return Collections.emptySet();
            }
            set = Collections.emptySet();
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    set = jedisCluster.keys(pattern);
                    break block17;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        set = jedis.keys(pattern);
                        break block17;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)"Jedis\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
            }
        }
        return set;
    }

    public static String setString(String key, String str, int liveSeconds) {
        String ret;
        block18: {
            if (key == null || str == null) {
                return null;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                log.error((Object)"Jedis\u8d44\u6e90\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5b57\u7b26\u4e32");
                return null;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    ret = liveSeconds <= 0 ? jedisCluster.set(JedisManager.encode(key), str) : jedisCluster.setex(JedisManager.encode(key), liveSeconds, str);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = liveSeconds <= 0 ? jedis.set(JedisManager.encode(key), str) : jedis.setex(JedisManager.encode(key), liveSeconds, str);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)"Jedis\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public static String getString(String key) {
        String ret;
        block18: {
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                log.error((Object)"Jedis\u8d44\u6e90\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5b57\u7b26\u4e32");
                return null;
            }
            ret = null;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    ret = jedisCluster.get(JedisManager.encode(key));
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.get(JedisManager.encode(key));
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (RuntimeException e) {
                log.error((Object)("Jedis\u8fde\u63a5\u5f02\u5e38\uff0ckey: " + key), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)("\u4eceRedis\u83b7\u53d6\u5b57\u7b26\u4e32\u65f6\u53d1\u751f\u5f02\u5e38\uff0ckey: " + key), (Throwable)e);
            }
        }
        return ret;
    }

    public static long delString(String key) {
        return JedisManager.del(key);
    }

    public static long delStringNew(String key) {
        return JedisManager.del(JedisManager.encode(key));
    }

    public static long delObject(String key) {
        return JedisManager.del(key);
    }

    public static Object getObject(String key) {
        if (key == null) {
            return null;
        }
        byte[] ret = JedisManager.getBytes(key.getBytes());
        if (ret == null) {
            return null;
        }
        return ObjectBytesExchange.toObject(ret);
    }

    public static String setObject(String key, int seconds, Object obj) {
        if (key == null || obj == null) {
            return null;
        }
        byte[] byteObj = ObjectBytesExchange.toByteArray(obj);
        if (null == byteObj) {
            return null;
        }
        return JedisManager.setBytes(key.getBytes(), seconds, byteObj);
    }

    public static byte[] getBytes(byte[] key) {
        byte[] ret;
        block18: {
            if (key == null) {
                return null;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                log.error((Object)"Jedis\u8d44\u6e90\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5b57\u8282\u6570\u7ec4");
                return null;
            }
            ret = null;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    ret = jedisCluster.get(key);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.get(key);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)("\u4eceRedis\u83b7\u53d6\u5b57\u8282\u6570\u7ec4\u65f6\u53d1\u751f\u5f02\u5e38\uff0ckey: " + Arrays.toString(key)), (Throwable)e);
            }
        }
        return ret;
    }

    public static String setBytes(byte[] key, int seconds, byte[] bytes) {
        String ret;
        block18: {
            if (key == null || bytes == null) {
                log.error((Object)"\u952e\u6216\u5b57\u8282\u6570\u7ec4\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6eRedis\u503c");
                return null;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                log.error((Object)"Jedis\u8d44\u6e90\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5b57\u8282\u6570\u7ec4");
                return null;
            }
            ret = null;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    ret = seconds <= 0 ? jedisCluster.set(key, bytes) : jedisCluster.setex(key, seconds, bytes);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = seconds <= 0 ? jedis.set(key, bytes) : jedis.setex(key, seconds, bytes);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)("\u8bbe\u7f6eRedis\u503c\u65f6\u53d1\u751f\u5f02\u5e38\uff0ckey: " + Arrays.toString(key) + ", seconds: " + seconds), (Throwable)e);
            }
        }
        return ret;
    }

    public static String encode(String str) {
        String ret = null;
        if (str != null) {
            try {
                ret = URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
            }
        }
        return ret;
    }

    public static long del(byte[] key) {
        long ret;
        block20: {
            if (key == null) {
                log.warn((Object)"\u5c1d\u8bd5\u5220\u9664Redis\u952e\u65f6\uff0c\u952e\u4e3anull\uff0c\u65e0\u6cd5\u6267\u884c\u5220\u9664\u64cd\u4f5c");
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                log.error((Object)"Jedis\u8d44\u6e90\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5220\u9664\u64cd\u4f5c");
                return 0L;
            }
            ret = 0L;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    ret = jedisCluster.del(key);
                    break block20;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.del(key);
                        break block20;
                    }
                    catch (Exception e) {
                        log.error((Object)("\u5728\u4f7f\u7528Jedis\u8d44\u6e90\u65f6\u53d1\u751f\u5f02\u5e38\uff0ckey: " + Arrays.toString(key)), (Throwable)e);
                        ret = -1L;
                    }
                    break block20;
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)("\u6267\u884c\u5220\u9664Redis\u952e\u65f6\u53d1\u751f\u5f02\u5e38\uff0ckey: " + Arrays.toString(key)), (Throwable)e);
                ret = -1L;
            }
        }
        return ret;
    }

    private static long del(String key) {
        return JedisManager.del(key.getBytes());
    }

    public static long expire(String key, int seconds) {
        long ret;
        block18: {
            if (key == null) {
                log.error((Object)"\u952e\u4e3anull\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u6709\u6548\u671f");
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                log.error((Object)"Jedis\u8d44\u6e90\u4e3a\u7a7a, \u65e0\u6cd5\u8bbe\u7f6e\u6709\u6548\u671f");
                return 0L;
            }
            ret = 0L;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    ret = jedisCluster.expire(key, seconds);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.expire(key, seconds);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)("\u8bbe\u7f6e\u952e" + key + "\u7684\u6709\u6548\u671f\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38"), (Throwable)e);
                ret = -1L;
            }
        }
        return ret;
    }

    private static boolean tryLockJedisCluster(JedisCluster jedisCluster, String encodedKey, String lockValue, int seconds) {
        if (jedisCluster.setnx(encodedKey, lockValue) == 1L) {
            jedisCluster.expire(encodedKey, seconds);
            return true;
        }
        String oldValue = jedisCluster.get(encodedKey);
        if (oldValue != null && Long.parseLong(oldValue) < System.currentTimeMillis()) {
            jedisCluster.del(encodedKey);
            if (jedisCluster.setnx(encodedKey, lockValue) == 1L) {
                jedisCluster.expire(encodedKey, seconds);
                return true;
            }
        }
        return false;
    }

    private static boolean tryLockJedis(Jedis jedis, String encodedKey, String lockValue, int seconds) {
        if (jedis.setnx(encodedKey, lockValue) == 1L) {
            jedis.expire(encodedKey, seconds);
            return true;
        }
        String oldValue = jedis.get(encodedKey);
        try {
            if (oldValue != null && Long.parseLong(oldValue) < System.currentTimeMillis()) {
                jedis.del(encodedKey);
                if (jedis.setnx(encodedKey, lockValue) == 1L) {
                    jedis.expire(encodedKey, seconds);
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"\u5c1d\u8bd5\u83b7\u53d6\u9501\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            jedis.del(encodedKey);
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean lock(String key, int seconds) {
        if (seconds <= 0) {
            seconds = 21600;
        }
        if (key == null || key.isEmpty()) {
            log.warn((Object)"\u9501\u5b9a\u7684\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u9501");
            return false;
        }
        Object resource = JedisManager.getJedisResource();
        if (resource == null) {
            log.warn((Object)"Jedis\u8d44\u6e90\u4e3a\u7a7a, \u65e0\u6cd5\u8bbe\u7f6e\u9501");
            return false;
        }
        long expireTime = System.currentTimeMillis() + (long)seconds * 1000L;
        String encodedKey = JedisManager.encode(key);
        String lockValue = String.valueOf(expireTime);
        try {
            if (resource instanceof JedisCluster) {
                return JedisManager.tryLockJedisCluster((JedisCluster)resource, encodedKey, lockValue, seconds);
            }
            if (!(resource instanceof Jedis)) {
                log.error((Object)("Unexpected resource type: " + resource.getClass().getName()));
                return false;
            }
            try (Jedis jedis = (Jedis)resource;){
                boolean bl = JedisManager.tryLockJedis(jedis, encodedKey, lockValue, seconds);
                return bl;
            }
        }
        catch (Exception e) {
            log.error((Object)("\u83b7\u53d6\u9501\u65f6\u53d1\u751f\u5f02\u5e38\uff1akey:" + key), (Throwable)e);
            return false;
        }
    }

    public static long incrByStr(String key) {
        long ret;
        block18: {
            if (key == null) {
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                log.warn((Object)"Jedis\u8d44\u6e90\u4e3a\u7a7a, \u65e0\u6cd5\u589e\u52a0\u8ba1\u6570\u5668");
                return 0L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    ret = jedisCluster.incr(key);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.incr(key);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)("\u589e\u52a0\u8ba1\u6570\u5668\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff1akey:" + key), (Throwable)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static long decrByStr(String key, long integer) {
        long ret;
        block18: {
            if (key == null) {
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                log.warn((Object)"Jedis\u8d44\u6e90\u4e3a\u7a7a, \u65e0\u6cd5\u51cf\u5c11\u8ba1\u6570\u5668");
                return 0L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    ret = jedisCluster.decrBy(key, integer);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.decrBy(key, integer);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)("\u51cf\u5c11\u8ba1\u6570\u5668\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff1akey:" + key), (Throwable)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static double incrByFloat(String key, double integer) {
        double ret;
        block18: {
            if (key == null) {
                return 0.0;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                log.warn((Object)"Jedis\u8d44\u6e90\u4e3a\u7a7a, \u65e0\u6cd5\u589e\u52a0\u8ba1\u6570\u5668");
                return 0.0;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    ret = jedisCluster.incrByFloat(key, integer);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.incrByFloat(key, integer);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)("\u589e\u52a0\u8ba1\u6570\u5668\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff1akey:" + key), (Throwable)e);
                ret = -1.0;
            }
        }
        return ret;
    }

    public static long decrByStr(String key) {
        long ret;
        block18: {
            if (key == null) {
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                log.warn((Object)"Jedis\u8d44\u6e90\u4e3a\u7a7a, \u65e0\u6cd5\u51cf\u5c11\u8ba1\u6570\u5668");
                return 0L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    ret = jedisCluster.decr(key);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.decr(key);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)("\u51cf\u5c11\u8ba1\u6570\u5668\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff1akey:" + key), (Throwable)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static long incrByByte(byte[] key) {
        long ret;
        block18: {
            if (key == null || key.length == 0) {
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return 0L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    ret = jedisCluster.incr(key);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.incr(key);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static long rpush(String key, String value) {
        long ret;
        block18: {
            if (key == null) {
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return 0L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedisCluster = (JedisCluster)resource;
                    ret = jedisCluster.rpush(key, new String[]{value});
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.rpush(key, new String[]{value});
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static long llen(String key) {
        long ret;
        block18: {
            if (key == null) {
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return 0L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.llen(key);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.llen(key);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static List<String> lrange(String key, int start, int end) {
        List ret;
        block17: {
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return null;
            }
            ret = null;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.lrange(key, (long)start, (long)end);
                    break block17;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.lrange(key, (long)start, (long)end);
                        break block17;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return ret;
    }

    public static String lpop(String key) {
        String ret;
        block18: {
            if (key == null) {
                return null;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return null;
            }
            ret = null;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.lpop(key);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.lpop(key);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return ret;
    }

    public static long ttl(String key) {
        long ret;
        block18: {
            if (key == null) {
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return -1L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.ttl(key);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.ttl(key);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static long lpush(String key, String ... value) {
        long ret;
        block18: {
            if (key == null) {
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return -1L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.lpush(key, value);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.lpush(key, value);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static List<String> lrange(String key, long start, long end) {
        List<String> ret;
        block17: {
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return null;
            }
            ret = new ArrayList<String>();
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.lrange(key, start, end);
                    break block17;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.lrange(key, start, end);
                        break block17;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return ret;
    }

    public static String rpop(String key) {
        String ret;
        block18: {
            if (key == null) {
                return null;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return null;
            }
            ret = null;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.rpop(key);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.rpop(key);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return ret;
    }

    public static long lrem(String key, long count, String value) {
        long ret;
        block18: {
            if (key == null) {
                return -1L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return -1L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.lrem(key, count, value);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.lrem(key, count, value);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static String ltrim(String key, long start, long end) {
        String ret;
        block18: {
            if (key == null) {
                return null;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return null;
            }
            ret = null;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.ltrim(key, start, end);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.ltrim(key, start, end);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return ret;
    }

    public static Set<String> spop(String key, long count) {
        Set ret;
        block18: {
            if (key == null) {
                return null;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return null;
            }
            ret = null;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.spop(key, count);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.spop(key, count);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e);
            }
        }
        return ret;
    }

    public static Set<String> smembers(String key) {
        Set ret;
        block18: {
            if (key == null) {
                return null;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return null;
            }
            ret = null;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.smembers(key);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.smembers(key);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return ret;
    }

    public static String spop(String key) {
        String ret;
        block18: {
            if (key == null) {
                return null;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return null;
            }
            ret = null;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.spop(key);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.spop(key);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return ret;
    }

    public static long sadd(String key, String ... members) {
        long ret;
        block18: {
            if (key == null) {
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return -1L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.sadd(key, members);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.sadd(key, members);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static long zadd(String key, double score, String member) {
        long ret;
        block18: {
            if (key == null) {
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return -1L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.zadd(key, score, member);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.zadd(key, score, member);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static long zrem(String key, String member) {
        long ret;
        block18: {
            if (key == null) {
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return -1L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.zrem(key, new String[]{member});
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.zrem(key, new String[]{member});
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static double zscore(String key, String member) {
        double ret;
        block17: {
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return -1.0;
            }
            ret = 0.0;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.zscore(key, member);
                    break block17;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.zscore(key, member);
                        break block17;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return ret;
    }

    public static Set<String> zrange(String key, long start, long end) {
        Set ret;
        block17: {
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return null;
            }
            ret = null;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.zrange(key, start, end);
                    break block17;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.zrange(key, start, end);
                        break block17;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return ret;
    }

    public static long zcard(String key) {
        long ret;
        block18: {
            if (key == null) {
                return 0L;
            }
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return -1L;
            }
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.zcard(key);
                    break block18;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.zcard(key);
                        break block18;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
                ret = -1L;
            }
        }
        return ret;
    }

    public static String get(String key) {
        String ret;
        block17: {
            Object resource = JedisManager.getJedisResource();
            if (resource == null) {
                return null;
            }
            ret = null;
            try {
                if (resource instanceof JedisCluster) {
                    JedisCluster jedis = (JedisCluster)resource;
                    ret = jedis.get(key);
                    break block17;
                }
                if (resource instanceof Jedis) {
                    try (Jedis jedis = (Jedis)resource;){
                        ret = jedis.get(key);
                        break block17;
                    }
                }
                throw new IllegalStateException("Unexpected resource type: " + resource.getClass().getName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return ret;
    }

    static {
        poolConfig = new JedisPoolConfig();
        log.info((Object)"JedisManager static code block loader...");
        poolConfig.setMaxTotal(500);
        poolConfig.setMaxIdle(60000);
        poolConfig.setMaxWaitMillis(1000L);
        poolConfig.setTestOnBorrow(true);
        cacheType = RedisConfig.getString("efuture.cache.cacheType");
        String dbIndex = RedisConfig.getString("efuture.cache.redisDatabase");
        String redisPassword = RedisConfig.getString("efuture.cache.redisPassword");
        if ("redis_cluster".equals(cacheType)) {
            String redisNodes = RedisConfig.getString("efuture.cache.redisNodes");
            LinkedHashSet<HostAndPort> node_set = new LinkedHashSet<HostAndPort>();
            String[] str_nodes = redisNodes.split(",");
            Arrays.stream(str_nodes).forEach(str -> {
                String l_host = str.split(":")[0];
                int l_port = Integer.parseInt(str.split(":")[1]);
                node_set.add(new HostAndPort(l_host, l_port));
            });
            jedisCluster = JedisProxyFactory.createJedisCluster(poolConfig, node_set, 5000, redisPassword);
        } else if ("redis_sentinel".equals(cacheType)) {
            String redisNodes = RedisConfig.getString("efuture.cache.redisNodes");
            String redisMaster = RedisConfig.getString("efuture.cache.redisMaster");
            HashSet<String> sentinels = new HashSet<String>();
            String[] str_nodes = redisNodes.split(",");
            Collections.addAll(sentinels, str_nodes);
            jedisSentinelPool = JedisProxyFactory.createJedisSentinelPool(poolConfig, redisMaster, sentinels, 5000, redisPassword, Integer.parseInt(dbIndex));
        } else if ("redis".equals(cacheType)) {
            String redisHost = RedisConfig.getString("efuture.cache.redisHost");
            String redisPort = RedisConfig.getString("efuture.cache.redisPort");
            jedisPool = JedisProxyFactory.createJedisPoolForStandalone(poolConfig, redisHost, Integer.parseInt(redisPort), 5000, redisPassword, Integer.parseInt(dbIndex));
        }
    }
}

