/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.component;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.component.GlobRuleBean;
import com.efuture.ocp.common.component.GlobRuleSrv;
import com.efuture.ocp.common.component.INORule;
import com.efuture.ocp.common.component.ruleimpl.MappedRuleImpl;
import com.efuture.ocp.common.distributedLock.DLock;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class GlobRuleSrvimpl
extends BasicComponent
implements GlobRuleSrv,
ApplicationContextAware,
InitializingBean {
    public Map<String, INORule> ruleHandles = new HashMap<String, INORule>();
    ApplicationContext applicationContext;

    public static GlobRuleSrv getInstance() {
        return (GlobRuleSrv)SpringBeanFactory.getContext().getBean(GlobRuleSrv.class);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @DLock(key="#args[0].toString() +'-' + #args[1] + '-' + #args[2]", lockExpire=120, waitMillSeconds=5)
    public long getlast(long ent_id, String ruleid, String ruletypestr, String datestr, long keynum) {
        String globruledet = "globruledet";
        long startseqno = 0L;
        long endseqno = 0L;
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("ruleid").is((Object)ruleid).and("ruletypestr").is((Object)ruletypestr);
        Query query = new Query((CriteriaDefinition)criteria);
        FMybatisTemplate storage = this.getGlobalStorageOperations(FMybatisTemplate.class);
        Map map = storage.selectOne(query, globruledet);
        if (map != null) {
            if (!StringUtils.isEmpty((Object)datestr) && !datestr.equals(MapUtils.getString(map, "ruletypeday"))) {
                endseqno = keynum;
            } else {
                startseqno = MapUtils.getLongValue(map, "rulecurseqno");
                endseqno = startseqno + keynum;
            }
            Update upt = new Update();
            upt.set("rulecurseqno", (Object)String.valueOf(endseqno));
            upt.set("ruletypeday", (Object)datestr);
            storage.update(query, upt, globruledet);
        } else {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("ent_id", ent_id);
            data.put("ruleid", ruleid);
            data.put("ruletypestr", ruletypestr);
            endseqno = keynum;
            data.put("rulecurseqno", String.valueOf(endseqno));
            data.put("ruletypeday", datestr);
            storage.insert(data, globruledet);
        }
        return startseqno;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public long getnext(long ent_id, String ruleid, String ruletypestr, String datestr) {
        return GlobRuleSrvimpl.getInstance().getlast(ent_id, ruleid, ruletypestr, datestr, 1L) + 1L;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String getrulekey(long ent_id, String ruleid, String moduleid, String type, String level) {
        GlobRuleBean rule = GlobRuleSrvimpl.getInstance().getrule(ent_id, ruleid);
        rule.setEnt_id(ent_id);
        rule.setPreStr(moduleid);
        rule.setLevelStr(level);
        HashMap<String, Object> filds = new HashMap<String, Object>();
        filds.put("TYPE", type);
        rule.setFields(filds);
        return this.getRuleCodeList(rule, 1).get(0);
    }

    @Override
    @AutoCache(Readable=true)
    public GlobRuleBean getrule(long ent_id, String ruleid) {
        FMybatisTemplate storage = this.getGlobalStorageOperations(FMybatisTemplate.class);
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("ruleid").is((Object)ruleid);
        Query query = new Query((CriteriaDefinition)criteria);
        String globruled = "globrule";
        GlobRuleBean rule = (GlobRuleBean)storage.selectOne(query, GlobRuleBean.class, "globrule");
        if (rule == null) {
            throw new ServiceException("90001", "\u6ca1\u6709\u627e\u5230\u7f16\u7801\u89c4\u5219[{0}]", ruleid);
        }
        return rule;
    }

    @Override
    public ServiceResponse getRuleDef(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject jsonrtn = new JSONObject();
        this.checkPara(session, jsonparam);
        String ruleId = jsonparam.getString("ruleid");
        GlobRuleBean globrule = GlobRuleSrvimpl.getInstance().getrule(session.getEnt_id(), jsonparam.getString("ruleid"));
        jsonrtn.put("globrule", (Object)globrule);
        return ServiceResponse.buildSuccess(jsonrtn);
    }

    @Override
    public ServiceResponse getRuleList(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject jsonrtn = new JSONObject();
        this.checkPara(session, jsonparam);
        String ruleId = jsonparam.getString("ruleid");
        if (ruleId == null || ruleId.equalsIgnoreCase("")) {
            ServiceResponse.buildFailure(session, "90001", "ruleid \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] rules = ruleId.split(",");
        ArrayList<GlobRuleBean> ruleList = new ArrayList<GlobRuleBean>();
        for (String rid : rules) {
            GlobRuleBean globrule = GlobRuleSrvimpl.getInstance().getrule(session.getEnt_id(), rid);
            if (globrule == null) continue;
            ruleList.add(globrule);
        }
        jsonrtn.put("globrule", ruleList);
        return ServiceResponse.buildSuccess(jsonrtn);
    }

    private INORule getRuleHandle(String ruleCode) {
        INORule handle = this.ruleHandles.get(ruleCode);
        if (handle == null) {
            handle = new MappedRuleImpl();
        }
        return handle;
    }

    public void getRuleCodeTemplate(GlobRuleBean rule) {
        String prestr = rule.getPreStr();
        String level = rule.getLevelStr();
        Map<String, Object> fields = rule.getFields();
        String[] ruledefs = rule.getRuledef().split("\\|");
        StringBuilder ruleCodeStr = new StringBuilder();
        StringBuilder ruleTypeStr = new StringBuilder();
        if (fields == null) {
            fields = new HashMap<String, Object>();
        }
        if (fields.get("NOW") == null) {
            fields.put("NOW", new Date());
        }
        if (!StringUtils.isEmpty((Object)prestr)) {
            ruleTypeStr.append(prestr);
            fields.put("PRESTR", prestr);
        } else {
            prestr = "#";
        }
        if (!StringUtils.isEmpty((Object)level)) {
            fields.put("LEVEL", level);
        } else {
            level = "#";
        }
        String DateStr = null;
        if (rule.getRuleisrule().equalsIgnoreCase("L")) {
            if (!StringUtils.isEmpty((Object)prestr) && !prestr.equalsIgnoreCase("#")) {
                ruleCodeStr.append(prestr);
            }
            ruleCodeStr.append("#SEQ");
            String[] levels = rule.getRuledef().toString().split("\\-");
            int prelevel = 0;
            int seqlen = 0;
            for (int i = 0; i < levels.length; ++i) {
                if (i + 1 == Integer.parseInt(level)) {
                    seqlen = Integer.parseInt(levels[i]);
                    break;
                }
                prelevel += Integer.parseInt(levels[i]);
            }
            seqlen = seqlen + ruleCodeStr.length() - 4;
            rule.setRulesyslen(seqlen);
            rule.setRuleTypeDay("");
            rule.setRuleCodeStr(ruleCodeStr.toString());
            rule.setRuleTypeStr(ruleTypeStr.toString());
            return;
        }
        for (String def : ruledefs) {
            if ("#SEQ".equalsIgnoreCase(def)) {
                ruleCodeStr.append("#SEQ");
                continue;
            }
            if (def.startsWith("#")) {
                String codeStr = def;
                String ruleCode = def.substring(1).toLowerCase();
                INORule handle = this.getRuleHandle(ruleCode);
                codeStr = handle.getCodeStr(ruleCode, fields);
                if (codeStr == null) {
                    codeStr = def;
                }
                if (handle.isDateRule()) {
                    DateStr = codeStr;
                } else if (!codeStr.equalsIgnoreCase(prestr) && !codeStr.equalsIgnoreCase(level)) {
                    ruleTypeStr.append("-" + codeStr);
                }
                ruleCodeStr.append(codeStr);
                continue;
            }
            ruleCodeStr.append(def);
            ruleTypeStr.append(def);
        }
        rule.setRuleTypeDay(DateStr);
        rule.setRuleCodeStr(ruleCodeStr.toString());
        rule.setRuleTypeStr(ruleTypeStr.toString());
    }

    public ServiceResponse getRuleCodeStrTest(ServiceSession session, JSONObject jsonparam) {
        return ServiceResponse.buildSuccess(this.doGenRuleCodeBatch(session.getEnt_id(), jsonparam.getString("ruleid"), jsonparam.getString("prestr"), jsonparam.getString("level"), jsonparam.getIntValue("num"), (Map<String, Object>)jsonparam));
    }

    private List<String> getRuleCodeList(GlobRuleBean rule, int num) {
        ArrayList<String> rulecodelist = new ArrayList<String>();
        this.getRuleCodeTemplate(rule);
        long startSeqNo = GlobRuleSrvimpl.getInstance().getlast(rule.getEnt_id(), rule.ruleid, rule.getRuleTypeStr(), rule.getRuleTypeDay(), num);
        long lastNum = startSeqNo + (long)num;
        String baseCode = rule.getRuleCodeStr();
        int seqlen = rule.getRulesyslen() - baseCode.length() + 4;
        for (int i = 0; i < num; ++i) {
            String seqNo;
            int len;
            if ((len = seqlen - String.valueOf(seqNo = String.valueOf(++startSeqNo)).length()) < 0) {
                throw new ServiceException("10000", "seqno [{0}] length is max [{1}]", seqNo, seqlen);
            }
            len += String.valueOf(seqNo).length();
            seqNo = "00000000000000000000" + seqNo;
            seqNo = seqNo.substring(seqNo.length() - len);
            String code = rule.getRuleCodeStr().replace("#SEQ", seqNo);
            rulecodelist.add(code);
        }
        return rulecodelist;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<String> doGenRuleCodeBatch(long ent_id, String ruleid, String prestr, String level, int num, Map<String, Object> fields) {
        GlobRuleBean rule = GlobRuleSrvimpl.getInstance().getrule(ent_id, ruleid);
        rule.setEnt_id(ent_id);
        rule.setPreStr(prestr);
        rule.setLevelStr(level);
        rule.setFields(fields);
        return this.getRuleCodeList(rule, num);
    }

    public void afterPropertiesSet() throws Exception {
        Objects.nonNull(this.applicationContext);
        Map rules = this.applicationContext.getBeansOfType(INORule.class);
        if (Objects.nonNull(rules)) {
            for (INORule rule : rules.values()) {
                ServiceLogs.debuglog("GlobRule", "\u6ce8\u518c\u89c4\u5219\u7f16\u7801\u751f\u6210\u5668[{0}]", 0L, rule.getRuleCode());
                this.ruleHandles.put(rule.getRuleCode().toLowerCase(), rule);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

