/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.datasync;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.datasync.DataSyncService;
import com.efuture.ocp.common.datasync.DxpTransReq;
import com.efuture.ocp.common.datasync.FindTargets;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FStorageOperations;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class DxpDataSync
extends BasicComponent
implements DataSyncService {
    private Map<String, Map<String, Object>> cmdconfig = new HashMap<String, Map<String, Object>>();
    private boolean ibinit = false;
    private boolean initerror = false;
    private boolean ibcanuse = false;

    public boolean isIbcanuse() {
        return this.ibcanuse;
    }

    public void setIbcanuse(boolean ibcanuse) {
        this.ibcanuse = ibcanuse;
    }

    private synchronized void init() {
        try {
            if (!this.ibinit) {
                Criteria criteria = Criteria.where((String)"1").is((Object)"1");
                Query query = new Query((CriteriaDefinition)criteria);
                List list = this.getStorageOperations().select(query, "trans_cmddef");
                for (int i = 0; i < list.size(); ++i) {
                    String cmdid = (String)((Map)list.get(i)).get("cmdid");
                    this.cmdconfig.put(cmdid, (Map<String, Object>)list.get(i));
                }
                this.ibinit = true;
            }
        }
        catch (Exception e) {
            this.initerror = true;
            this.getLogger().error((Object)("\u521d\u59cb\u5316\u6570\u636e\u540c\u6b65\u53c2\u6570\u9519\u8bef->" + e.getMessage()));
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void sync(AbstractEntityBean bean) throws IllegalArgumentException, IllegalAccessException {
        if (!this.ibcanuse) {
            return;
        }
        String tablename = AbstractEntityBean.fetchAnnotationTableName(bean.getClass());
        this.sync(bean, tablename);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void sync(AbstractEntityBean bean, String cmdid) throws IllegalArgumentException, IllegalAccessException {
        if (!this.ibcanuse) {
            return;
        }
        if (this.findCmdConfig(cmdid, "keycol") == null) {
            return;
        }
        String keycols = this.findCmdConfig(cmdid, "keycol").toString();
        if (StringUtils.isEmpty((Object)keycols)) {
            return;
        }
        Field fld = bean.fetchDeclaredField(keycols);
        Object value = fld.get(bean);
        String keyvalue = null;
        if (!StringUtils.isEmpty((Object)value)) {
            keyvalue = value.toString();
        }
        this.sync(keyvalue, cmdid);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void sync(String keyvalue, String cmdid) {
        if (!this.ibcanuse) {
            return;
        }
        Map<String, Object> cmdconfig = this.findCmdConfig(cmdid);
        if (cmdconfig == null) {
            return;
        }
        if (StringUtils.isEmpty((Object)keyvalue)) {
            return;
        }
        List<String> targets = this.getTargets(cmdconfig, keyvalue);
        if (targets.size() <= 0) {
            return;
        }
        DxpTransReq req = this.createReq(cmdconfig, keyvalue);
        this.insertcmd(req, targets);
    }

    private void insertcmd(DxpTransReq req, List<String> targets) {
        List<Map<String, Object>> reqitem = req.getItems();
        JSONObject reqjson = (JSONObject)JSONObject.toJSON((Object)req);
        reqjson.remove((Object)"items");
        for (int i = 0; i < targets.size(); ++i) {
            req.setTargetid(targets.get(i));
            reqjson.put("targetid", (Object)targets.get(i));
            this.insertcmd(reqjson, reqitem);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int getId(String key) {
        FStorageOperations fso = this.getStorageOperations();
        Criteria criteria = Criteria.where((String)"term").is((Object)key);
        Query query = new Query((CriteriaDefinition)criteria);
        Update upt = new Update();
        upt.set("term", (Object)key);
        int rtnid = 0;
        if (fso.update(query, upt, "trans_next_value") <= 0) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("term", key);
            data.put("next_value", ++rtnid);
            fso.insert(data, "trans_next_value");
        } else {
            Map map = fso.selectOne(query, "trans_next_value");
            rtnid = (Integer)map.get("next_value");
            upt = new Update();
            upt.set("next_value", (Object)(++rtnid));
            fso.update(query, upt, "trans_next_value");
        }
        return rtnid;
    }

    private void insertcmd(JSONObject req, List<Map<String, Object>> items) {
        FStorageOperations fso = this.getStorageOperations();
        DxpDataSync dds = SpringBeanFactory.getBean("efuture.com.datasync", DxpDataSync.class);
        long reqid = dds.getId("term");
        req.put("reqid", (Object)reqid);
        fso.insert((Object)req, "trans_req");
        for (Map<String, Object> map : items) {
            map.put("reqid", reqid);
            fso.insert(map, "trans_reqitems");
        }
    }

    private List<String> findOtherTargets(Map<String, Object> cmdconfig, String keyvalue) {
        if (cmdconfig.get("targetsobj") == null) {
            return null;
        }
        String objname = cmdconfig.get("targetsobj").toString();
        if (StringUtils.isEmpty((Object)objname)) {
            return null;
        }
        FindTargets obj = null;
        List<String> rtn = null;
        if (SpringBeanFactory.containsBean(objname)) {
            obj = SpringBeanFactory.getBean(objname, FindTargets.class);
            rtn = obj.find(cmdconfig, keyvalue);
        }
        return rtn;
    }

    public List<String> getTargets(Map<String, Object> cmdconfig, String keyvalue) {
        String[] targets = cmdconfig.get("targets").toString().split(",");
        List<String> rtn = Arrays.asList(targets);
        List<String> others = this.findOtherTargets(cmdconfig, keyvalue);
        if (others != null && others.size() > 0) {
            rtn.addAll(others);
        }
        return rtn;
    }

    private String concat(Object src, String para) {
        if (!StringUtils.isEmpty((Object)src)) {
            String rtn = src.toString().trim() + para;
            return rtn;
        }
        return null;
    }

    private DxpTransReq createReq(Map<String, Object> cmdConfig, String keyvalue) {
        String keystr = StringUtils.isEmpty((Object)keyvalue) ? "()" : "('" + keyvalue + "')";
        Date now = new Date();
        String OPSql = this.concat(cmdConfig.get("opsql"), keystr);
        String OASql = this.concat(cmdConfig.get("oasql"), keystr);
        String IPSql = this.concat(cmdConfig.get("ipsql"), keystr);
        String IASql = this.concat(cmdConfig.get("iasql"), keystr);
        DxpTransReq req = new DxpTransReq();
        req.setReqtype(Integer.parseInt(cmdConfig.get("reqtype").toString()));
        req.setReqdate(now);
        req.setSheettype(cmdConfig.get("sheettype").toString());
        req.setLocaltype(cmdConfig.get("localtype").toString());
        req.setExecuteflag(0);
        req.setOpsql(OPSql);
        req.setOasql(OASql);
        req.setIpsql(IPSql);
        req.setIasql(IASql);
        req.setDescription(cmdConfig.get("cmdname").toString());
        req.setCmdid(cmdConfig.get("cmdid").toString());
        req.setKeyvalue(keyvalue);
        String[] fromTables = cmdConfig.get("fromtables").toString().split(",");
        String[] toTables = cmdConfig.get("totables").toString().split(",");
        String[] keyCols = cmdConfig.get("fromkeycols").toString().split(",");
        ArrayList<Map<String, Object>> itemlist = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < fromTables.length; ++i) {
            String ft = fromTables[i];
            String tt = toTables[i];
            String col = keyCols[i];
            String sql = "select * from " + ft + "";
            if (!StringUtils.isEmpty((Object)keyvalue)) {
                sql = sql + " where " + col + " = '" + keyvalue + "'";
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", i + 1);
            map.put("nodename", tt);
            map.put("outsql", sql);
            itemlist.add(map);
        }
        req.setItems(itemlist);
        return req;
    }

    private Object findCmdConfig(String cmdid, String configkey) {
        Map<String, Object> config = this.findCmdConfig(cmdid);
        if (config == null) {
            return null;
        }
        return config.get(configkey);
    }

    private Map<String, Object> findCmdConfig(String cmdid) {
        return this.getCmdconfig().get(cmdid.toUpperCase());
    }

    public Map<String, Map<String, Object>> getCmdconfig() {
        if (this.initerror) {
            return this.cmdconfig;
        }
        if (!this.ibinit) {
            this.init();
        }
        return this.cmdconfig;
    }
}

