/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.proxy.EnterpriseProxy;
import com.efuture.ocp.common.util.MD5Utils;
import com.efuture.ocp.common.util.RestClientUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy(value=true)
@Component(value="RestClientUtils_MSS")
public class RestClientUtils_MSS
extends RestClientUtils {
    @Override
    public Map<String, Object> doOverWrite(Object session, String method, String url, Object param) throws Exception {
        if (!method.startsWith("http")) {
            return super.doOverWrite(session, method, url, param);
        }
        long entId = 0L;
        if (session != null && session instanceof ServiceSession) {
            entId = ((ServiceSession)session).getEnt_id();
        } else if (session != null && session instanceof Long) {
            entId = (Long)session;
        } else {
            throw new ServiceException("50000", "\u672a\u4f20\u5165\u4f01\u4e1a\u7f16\u53f7", new Object[0]);
        }
        String token = this.getEntToken(entId);
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new ServiceException("50000", "\u65e0\u6cd5\u83b7\u53d6\u4f01\u4e1a\u8ba4\u8bc1Token", new Object[0]);
        }
        String signStr = String.format("%s=%s", EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_app_key", true, ""), EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_Secret", true, "")) + String.format("&body=%s", param.toString()) + String.format("&token=%s", token);
        String sign = MD5Utils.MD5(signStr);
        url = url.concat("&app_key=").concat(EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_app_key", true, "")).concat("&token=").concat(token).concat("&sign=").concat(sign);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", method);
        map.put("url", url);
        map.put("param", param);
        return map;
    }

    @AutoCache(Service="HGO", KeyArgIndex=0)
    private String getEntToken(Long entId) throws Exception {
        Object data;
        ServiceSession session = new ServiceSession();
        session.setEnt_id(entId);
        String token_Url = EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_AuthUrl", true, "");
        JSONObject param = new JSONObject();
        param.put("tag", (Object)EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_tag", true, ""));
        param.put("userCode", (Object)EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_userCode", true, ""));
        param.put("password", (Object)EnterpriseProxy.getInstance().getEnterpriseConfig(entId, "mss_password", true, ""));
        ServiceResponse response = RestClientUtils.getRestUtils().sendRequest(session, token_Url, param);
        if (response.getReturncode().equals("0") && (data = response.getData()) instanceof JSONObject && ((JSONObject)data).containsKey((Object)"access_token")) {
            return ((JSONObject)data).getString("access_token");
        }
        return null;
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param) throws Exception {
        return this.sendRequest(session, method, param, "");
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
        String url;
        ServiceSession ss = null;
        if (session instanceof ServiceSession) {
            ss = (ServiceSession)session;
        }
        if (method.toLowerCase().startsWith("http")) {
            url = method;
        } else {
            url = this.queryServiceURI(ss.getEnt_id(), method);
            if (org.springframework.util.StringUtils.isEmpty((Object)url)) {
                throw new Exception("can't find method service url:" + method);
            }
        }
        Map<String, Object> map = this.doOverWrite(session, method, url, param);
        method = map.get("method").toString();
        url = map.get("url").toString();
        param = map.get("param");
        Object result = RestClientUtils.getRestUtils().sendRequest(session, url, param, new RestClientUtils.defaultRequestCallback(), traceprex);
        ServiceResponse response = null;
        if (result != null) {
            JSONObject json;
            try {
                json = JSON.parseObject((String)((String)result));
            }
            catch (Exception ex) {
                json = new JSONObject();
                json.put("returncode", (Object)"50000");
                json.put("data", result);
            }
            response = (ServiceResponse)JSON.toJavaObject((JSON)json, ServiceResponse.class);
        }
        if (response == null) {
            throw new ServiceException("50000", (String)result, new Object[0]);
        }
        return response;
    }
}

