/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.proxy.EnterpriseConfigBean;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy(value=true)
@Component(value="RestClientUtils_TianJi")
public class RestClientUtils_TianJi
extends RestClientUtils {
    private String getData(JSONObject json, String key, String defval) {
        if (json.containsKey((Object)key)) {
            return json.getString(key);
        }
        return defval;
    }

    @Override
    public ServiceResponse sendRequest(ServiceSession session, String baseUrl, EnterpriseConfigBean ent, JSONObject param, String dataNode) throws Exception {
        String result;
        String urlstr = this.getUrl(session, baseUrl, ent.getSrvConfig("authUrl", true), ent.getSrvConfig("authKey", false), false);
        try {
            result = this.PostDataLog(session, urlstr, param.toJSONString());
        }
        catch (ServiceException e) {
            ServiceLogs.errLog("", e, "PostDataLog\u8bf7\u6c42\u5931\u8d25", new Object[0]);
            urlstr = this.getUrl(session, baseUrl, ent.getSrvConfig("authUrl", true), ent.getSrvConfig("authKey", false), true);
            result = this.PostDataLog(session, urlstr, param.toJSONString());
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return ServiceResponse.buildFailure(session, "10000", "\u6ca1\u6709\u8fd4\u56de\u6570\u636e!");
        }
        JSONObject ret = JSONObject.parseObject((String)result);
        String retcode = this.getData(ret, "code", "0");
        if (!"0000".equals(retcode)) {
            return ServiceResponse.buildFailure(session, "10000", this.getData(ret, "message", "N/A"));
        }
        if (ret.containsKey((Object)dataNode)) {
            JSONObject retData = ret.getJSONObject(dataNode);
            retcode = this.getData(retData, "retcode", "0");
            if (!"0".equals(retcode)) {
                return ServiceResponse.buildFailure(session, "10000", this.getData(ret, "retmsg", "N/A"));
            }
            return ServiceResponse.buildSuccess(retData);
        }
        return ServiceResponse.buildFailure(session, "10000", "\u6ca1\u6709\u8fd4\u56de\u6570\u636e!");
    }

    public String getTokenStr(ServiceSession session, String authUrl, boolean force) throws Exception {
        String memKey = "TianJi" + session.getEnt_id();
        String accessToken = (String)CacheUtils.getCacheUtils().getData(memKey);
        JSONObject remote_token = new JSONObject();
        if (StringUtils.isEmpty((CharSequence)accessToken) || force) {
            Object result = RestClientUtils.getRestUtils().sendRequest((Object)session, authUrl, "", new defaultRequestCallback(), "notrace");
            if (result != null) {
                remote_token = JSON.parseObject((String)((String)result));
            }
            if (remote_token.containsKey((Object)"access_token")) {
                accessToken = remote_token.getString("access_token");
                int expires_in = remote_token.getIntValue("expires_in");
                CacheUtils.getCacheUtils().putData(memKey, accessToken, expires_in - 10);
            } else {
                throw new ServiceException("10000", "\u83b7\u53d6\u4ee3\u7406TOKEN\u9519\u8bef,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01", new Object[0]);
            }
        }
        return "?access_token=".concat(accessToken);
    }

    public String getUrl(ServiceSession session, String baseUrl, String authUrl, String authKey, boolean force) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)authUrl)) {
            String tokenStr = this.getTokenStr(session, authUrl, force);
            return baseUrl.concat(tokenStr);
        }
        return baseUrl;
    }

    protected String PostDataLog(ServiceSession session, String urlStr, String content) throws Exception {
        Object result = RestClientUtils.getRestUtils().sendRequest((Object)session, urlStr, content, new defaultRequestCallback(), "notrace");
        return (String)result;
    }

    public class defaultRequestCallback
    implements RestClientUtils.requestCallback {
        @Override
        public Object onSend(String url, Client client, Object param) throws Exception {
            MultivaluedMapImpl queryParams;
            WebResource webResource = client.resource(url);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.queryParams((MultivaluedMap)(queryParams = new MultivaluedMapImpl())).header("Content-Type", (Object)"application/json").header("Accept", (Object)"application/json")).post(ClientResponse.class, param);
            if (response.getStatus() == 401) {
                throw new ServiceException("10000", "\u5f53\u524dtoken\u65e0\u6548\uff0c\u9700\u8981\u91cd\u65b0\u83b7\u53d6\uff01", new Object[0]);
            }
            Object resp = response.getEntity(String.class);
            return resp;
        }
    }
}

