/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.annotation;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.CallTime;
import com.efuture.ocp.common.rest.ServiceLogs;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class CallTimeAspect {
    private static final Logger logger = Logger.getLogger(CallTimeAspect.class);

    private String getKey(ProceedingJoinPoint point, CallTime around) {
        String serviceName = around.Service();
        String keyname = around.KeyName();
        int argindex = around.KeyArgIndex();
        String className = point.getTarget().getClass().getSimpleName();
        String methodName = point.getSignature().getName();
        Object[] args = point.getArgs();
        StringBuffer sb = new StringBuffer();
        if (argindex != -1 && args.length > argindex) {
            JSONObject jsonarg;
            Object arg = args[argindex];
            if (arg instanceof JSONObject) {
                jsonarg = (JSONObject)arg;
            } else if (arg instanceof String) {
                jsonarg = new JSONObject();
                jsonarg.put(String.valueOf(argindex), arg);
            } else {
                jsonarg = (JSONObject)JSONObject.toJSON((Object)arg);
            }
            if (StringUtils.isEmpty((Object)keyname)) {
                sb.append("_").append(JSONObject.toJSON((Object)arg));
            } else {
                String[] keys = keyname.split(",");
                StringBuffer sbkey = new StringBuffer();
                for (String key : keys) {
                    Object value;
                    if (key == null || (value = jsonarg.get((Object)key)) == null) continue;
                    sbkey.append("-").append(key).append(":").append(value.toString());
                }
                if (sbkey.length() > 0) {
                    sb.append("_").append(sbkey.toString());
                } else {
                    sb.append("_").append(jsonarg.toJSONString());
                }
            }
        } else if (argindex == 99) {
            String[] keys = keyname.split(",");
            StringBuffer sbkey = new StringBuffer();
            if (keys != null && keys.length > 0) {
                for (String key : keys) {
                    if (StringUtils.isEmpty((Object)key)) continue;
                    String keyVal = args[Integer.valueOf(key)].toString();
                    if (sbkey.length() > 0) {
                        sb.append("_").append(args[Integer.valueOf(key)].toString());
                        continue;
                    }
                    sb.append(args[Integer.valueOf(key)].toString());
                }
            }
        } else {
            for (Object arg : args) {
                if (arg == null) continue;
                sb.append("_").append(JSONObject.toJSON((Object)arg));
            }
        }
        if (sb.length() > 0) {
            return serviceName.concat("-").concat(className).concat("-").concat(methodName).concat("-").concat(sb.toString());
        }
        return serviceName.concat("-").concat(className).concat("-").concat(methodName);
    }

    @Around(value="@annotation(around)")
    public Object round(ProceedingJoinPoint point, CallTime around) throws Throwable {
        long starttime = System.currentTimeMillis();
        try {
            Object object = point.proceed();
            return object;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            ServiceLogs.debuglog("info", this.getKey(point, around), starttime);
        }
    }
}

