/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.proxy;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.proxy.EnterpriseProxy;
import com.efuture.ocp.common.util.DataUtils;
import java.sql.Date;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Document(collection="sys_enterprise")
public class EnterpriseConfigBean
extends AbstractEntityBean {
    private static final long serialVersionUID = -5056542499635144654L;
    private long ent_id;
    private String ent_name;
    private String proxy_objects;
    private String srv_para;
    private long ph_key;
    private Date ph_timestamp;
    @Transient
    private String bizKey;

    public String getBizKey() {
        return this.bizKey;
    }

    public void setBizKey(String bizKey) {
        this.bizKey = bizKey;
    }

    @Override
    public long getEnt_id() {
        return this.ent_id;
    }

    @Override
    public void setEnt_id(long ent_id) {
        this.ent_id = ent_id;
    }

    public String getEnt_name() {
        return this.ent_name;
    }

    public void setEnt_name(String ent_name) {
        this.ent_name = ent_name;
    }

    public String getSrv_para() {
        return this.srv_para;
    }

    public void setSrv_para(String srv_para) {
        this.srv_para = srv_para;
    }

    public long getPh_key() {
        return this.ph_key;
    }

    public void setPh_key(long ph_key) {
        this.ph_key = ph_key;
    }

    public Date getPh_timestamp() {
        return this.ph_timestamp;
    }

    public void setPh_timestamp(Date ph_timestamp) {
        this.ph_timestamp = ph_timestamp;
    }

    public String getProxy_objects() {
        return this.proxy_objects;
    }

    public void setProxy_objects(String proxy_objects) {
        this.proxy_objects = proxy_objects;
    }

    protected String getProxyObject(String bizKey) throws Exception {
        JSONObject proxyObjects = JSONObject.parseObject((String)this.getProxy_objects());
        if (StringUtils.isEmpty((Object)proxyObjects) || StringUtils.isEmpty((Object)bizKey)) {
            throw new Exception("PROXY OBJECT NOT DEFINE!");
        }
        if (!proxyObjects.containsKey((Object)bizKey)) {
            if (proxyObjects.containsKey((Object)"base")) {
                return proxyObjects.getString("base");
            }
            throw new Exception("PROXY OBJECT IS NULL " + bizKey);
        }
        return proxyObjects.getString(bizKey);
    }

    private String getMktBizExcepKey(String key) {
        if (!ObjectUtils.isEmpty((Object)EnterpriseProxy.getInstance().getMktBizKey())) {
            return key.concat("_").concat(EnterpriseProxy.getInstance().getMktBizKey());
        }
        return null;
    }

    private String getBizExcepKey(String key) {
        return key.concat("_").concat(DataUtils.nvl(this.bizKey, EnterpriseProxy.getInstance().getBizKey()));
    }

    public String getSrvConfigVal(String key, boolean checkNull, String defValue) throws Exception {
        JSONObject srvConfig = JSONObject.parseObject((String)this.getSrv_para());
        if (StringUtils.isEmpty((Object)srvConfig) || StringUtils.isEmpty((Object)key) || !srvConfig.containsKey((Object)key)) {
            if (checkNull) {
                throw new Exception("PROXY CONFIG IS NULL " + key);
            }
            return defValue;
        }
        return srvConfig.getString(key);
    }

    public String getSrvConfig(String key, boolean checkNull, String defValue) throws Exception {
        String result = this.getSrvConfigVal(this.getMktBizExcepKey(key), false, null);
        if (StringUtils.isEmpty((Object)result) && StringUtils.isEmpty((Object)(result = this.getSrvConfigVal(this.getBizExcepKey(key), false, null)))) {
            result = this.getSrvConfigVal(key, checkNull, defValue);
        }
        return result;
    }

    public String getSrvConfig(String key, boolean checkNull) throws Exception {
        return this.getSrvConfig(key, checkNull, null);
    }

    public String getBase_url() throws Exception {
        return DataUtils.nvl(this.getSrvConfig(this.getBizExcepKey("baseUrl"), false), this.getSrvConfig("baseUrl", true));
    }
}

