/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.trans;

import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.OcpApplicationContext;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TransactionManager {
    static final String DEFAULT_TX_NAME = "transactionManager";

    public static DataSourceTransactionManager getTxManager(String ... txName) {
        String txManagerName = null;
        txManagerName = txName != null && txName.length > 0 ? DataUtils.nvl(txName[0], DEFAULT_TX_NAME) : DEFAULT_TX_NAME;
        DataSourceTransactionManager transactionManager = (DataSourceTransactionManager)OcpApplicationContext.getInstance().getBean(txManagerName);
        return transactionManager;
    }

    public static TransactionStatus newTransaction(String ... txName) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = TransactionManager.getTxManager(txName).getTransaction((TransactionDefinition)def);
        return status;
    }

    public static void commit(TransactionStatus status, String ... txName) {
        if (status != null) {
            TransactionManager.getTxManager(txName).commit(status);
        }
    }

    public static void rollback(TransactionStatus status, String ... txName) {
        if (status != null) {
            TransactionManager.getTxManager(txName).rollback(status);
        }
    }
}

