/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.user;

import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.user.DataRange;
import com.efuture.ocp.user.UserService;
import com.efuture.ocp.user.UserTokenInfo;
import java.util.List;
import org.springframework.util.StringUtils;

public class UserDataRangeSrv {
    private static final InheritableThreadLocal<UserTokenInfo> LOCAL_USERINFO = new InheritableThreadLocal();
    private static final InheritableThreadLocal<List<DataRange>> LOCAL_DataRange = new InheritableThreadLocal();
    private static final InheritableThreadLocal<String> LOCAL_TOKEN = new InheritableThreadLocal();
    private static final InheritableThreadLocal<Boolean> LOCAL_ISRANGE = new InheritableThreadLocal();
    private static final InheritableThreadLocal<Boolean> RangeIsExec = new InheritableThreadLocal();
    private static boolean OPENRANGE;
    private static String PORTALKEY;
    private static UserService us;
    private static final String TOKEN_MEMKEY = "OCP:TOKEN:";

    public static void setlocaltoken(String token) {
        LOCAL_TOKEN.set(token);
        LOCAL_DataRange.remove();
        LOCAL_USERINFO.remove();
        RangeIsExec.set(false);
        if (StringUtils.isEmpty((Object)token)) {
            LOCAL_ISRANGE.set(false);
        } else {
            LOCAL_ISRANGE.set(true);
        }
    }

    public static boolean getlocalisrange() {
        if (!OPENRANGE) {
            return OPENRANGE;
        }
        Boolean b = (Boolean)LOCAL_ISRANGE.get();
        if (null == b) {
            return false;
        }
        return b;
    }

    public static boolean getRangeisexec() {
        Boolean b = (Boolean)RangeIsExec.get();
        if (null == b) {
            return false;
        }
        return b;
    }

    public static void setRangeisexec(boolean exec) {
        RangeIsExec.set(exec);
    }

    public static void setlocalisrange(boolean isrange) {
        LOCAL_ISRANGE.set(isrange);
    }

    public static String getlocaltoken() {
        return (String)LOCAL_TOKEN.get();
    }

    public static UserTokenInfo getlocaluser() {
        if (!OPENRANGE) {
            return null;
        }
        return UserDataRangeSrv.getuserinfo();
    }

    public static UserTokenInfo getuserinfo() {
        UserTokenInfo info = (UserTokenInfo)LOCAL_USERINFO.get();
        if (null == info) {
            String token = UserDataRangeSrv.getlocaltoken();
            if (token.isEmpty()) {
                return null;
            }
            info = UserDataRangeSrv.getuserinfo(token);
            LOCAL_USERINFO.set(info);
        }
        return (UserTokenInfo)LOCAL_USERINFO.get();
    }

    public static List<DataRange> getlocaldatarange() {
        if (!OPENRANGE) {
            return null;
        }
        List<DataRange> dr = (List<DataRange>)LOCAL_DataRange.get();
        if (null == dr || dr.size() < 1) {
            UserTokenInfo info = UserDataRangeSrv.getlocaluser();
            if (null == info) {
                return null;
            }
            dr = UserDataRangeSrv.getDataRangeBytoken(info.getToken());
            LOCAL_DataRange.set(dr);
        }
        return dr;
    }

    public static UserTokenInfo getuserinfo(String token) {
        if (!OPENRANGE) {
            return null;
        }
        if (StringUtils.isEmpty((Object)token)) {
            return null;
        }
        String key = TOKEN_MEMKEY + token;
        UserTokenInfo info = null;
        if (!PORTALKEY.equalsIgnoreCase("cloud")) {
            info = (UserTokenInfo)CacheUtils.getCacheUtils().getData(key);
        }
        if (null == info) {
            UserService us = UserDataRangeSrv.getServerSrv();
            info = us.getuserinfo(token);
            if (null == info) {
                return null;
            }
            if (!PORTALKEY.equalsIgnoreCase("cloud")) {
                CacheUtils.getCacheUtils().putData(key, info, 86400);
            }
        }
        return info;
    }

    private static UserService getServerSrv() {
        if (null == us) {
            String userService = "UserServerSrv_" + PORTALKEY;
            System.out.println("portalkey:".concat(PORTALKEY));
            System.out.println("userService:".concat(userService));
            us = SpringBeanFactory.containsBean(userService) ? SpringBeanFactory.getBean(userService, UserService.class) : SpringBeanFactory.getBean("UserServerSrv", UserService.class);
        }
        return us;
    }

    public static List<DataRange> getDataRangeBytoken(String token) {
        if (!OPENRANGE) {
            return null;
        }
        UserTokenInfo info = UserDataRangeSrv.getuserinfo(token);
        if (null == info) {
            return null;
        }
        return info.getDatarange();
    }

    public static boolean isOpenrange() {
        return OPENRANGE;
    }

    public static void setOpenrange(boolean openrange) {
        OPENRANGE = openrange;
    }

    public static String getPortalkey() {
        return PORTALKEY;
    }

    public static void setPortalkey(String portalkey) {
        PORTALKEY = portalkey;
    }

    private static interface PortalKey {
        public static final String CLOUD = "cloud";
        public static final String CONGOU = "congou";
    }
}

