/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.efuture.ocp.common.util.RestInfoGet;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.WebPathUtils;
import com.efuture.omd.storage.FStorageOperations;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="restinfogetfrominifile")
public class RestInfoGetFromIniFile
implements RestInfoGet {
    public Logger logger = Logger.getLogger(RestInfoGetFromIniFile.class);
    private Properties cfgProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String configfile) {
        if (!StringUtils.isEmpty((Object)configfile) && configfile.startsWith("DB:")) {
            FStorageOperations storage = null;
            try {
                Query query;
                List list;
                storage = SpringBeanFactory.getBean("StorageOperation", FStorageOperations.class);
                String[] ss = configfile.substring(3).split("\\|");
                String table = ss[0].trim();
                Criteria criteria = new Criteria();
                if (ss.length > 1) {
                    ss = ss[1].split(",");
                    for (int i = 0; i < ss.length; ++i) {
                        String[] cond = ss[i].split("=");
                        String key = cond[0].trim();
                        String val = cond[1].trim();
                        criteria = criteria.and(key).is((Object)val);
                    }
                }
                if ((list = storage.select(query = new Query((CriteriaDefinition)criteria), table)) != null && list.size() > 0) {
                    this.cfgProperties = new Properties();
                    for (Map map : list) {
                        this.cfgProperties.setProperty((String)map.get("key"), (String)map.get("val"));
                    }
                }
            }
            finally {
                if (storage != null) {
                    storage.destroy();
                }
            }
            return;
        }
        String ini = null;
        ini = StringUtils.isEmpty((Object)configfile) ? WebPathUtils.getWebRootClassPath() + "/restservice.ini" : (configfile.startsWith("\\") || configfile.startsWith("/") ? WebPathUtils.getWebRootClassPath() + configfile : configfile);
        System.out.println("restservice.ini path:" + ini);
        try {
            this.logger.info((Object)("restservice.ini path:" + ini));
            File input = new File(ini);
            if (input.exists()) {
                FileInputStream is = new FileInputStream(input);
                this.cfgProperties = new Properties();
                this.cfgProperties.load(is);
                ((InputStream)is).close();
            } else {
                URL fps = new URL(ini);
                File fp = new File(fps.toURI());
                FileInputStream is = new FileInputStream(fp);
                this.cfgProperties = new Properties();
                this.cfgProperties.load(is);
                ((InputStream)is).close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String queryServiceURI(long ent_id, String method) {
        return this.queryServiceURI(method);
    }

    @Override
    public String queryServiceURI(String method) {
        String servicePath = "";
        if (this.cfgProperties == null) {
            return null;
        }
        String curservice = method;
        while (!StringUtils.isEmpty((Object)curservice)) {
            int n;
            Enumeration<?> names;
            String url = this.cfgProperties.getProperty(curservice);
            if (url != null && !url.equals("")) {
                servicePath = url;
                break;
            }
            if (curservice.equals("*")) break;
            boolean matches = false;
            if (!curservice.endsWith(".*") && (names = this.cfgProperties.propertyNames()) != null) {
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    if (name.endsWith(".*") || name.indexOf("*") <= 0) continue;
                    String prefix = name.substring(0, name.indexOf("*"));
                    String suffix = name.substring(name.indexOf("*") + 1);
                    if (StringUtils.isEmpty((Object)prefix) || !curservice.startsWith(prefix) || StringUtils.isEmpty((Object)suffix) || !curservice.endsWith(suffix)) continue;
                    matches = true;
                    servicePath = this.cfgProperties.getProperty(name);
                    break;
                }
            }
            if (matches) break;
            if (curservice.endsWith(".*")) {
                curservice = curservice.substring(0, curservice.lastIndexOf("."));
            }
            if ((n = curservice.lastIndexOf(".")) > 0) {
                curservice = curservice.substring(0, n) + ".*";
                continue;
            }
            curservice = "*";
        }
        return servicePath;
    }

    @Override
    public String queryServiceURIbymkt(String method, String mktid) throws Exception {
        String servicePath = "";
        String curservice = method;
        if (!StringUtils.isEmpty((Object)curservice)) {
            Criteria criteria = Criteria.where((String)"mktid").is((Object)mktid).and("id").is((Object)method);
            Query query = new Query((CriteriaDefinition)criteria);
            List list = SpringBeanFactory.getBean("StorageOperation", FStorageOperations.class).select(query, "restconfig");
            if (list != null && !list.isEmpty() && list.size() > 0) {
                servicePath = (String)((Map)list.get(0)).get("resturl");
            } else {
                Criteria c2 = Criteria.where((String)"mktid").is((Object)"%").and("id").is((Object)method);
                Query q2 = new Query((CriteriaDefinition)c2);
                List list2 = SpringBeanFactory.getBean("StorageOperation", FStorageOperations.class).select(q2, "restconfig");
                if (list2 != null && !list2.isEmpty() && list2.size() > 0) {
                    servicePath = (String)((Map)list2.get(0)).get("resturl");
                } else {
                    throw new Exception("can't find method service url, please check restconfig !");
                }
            }
        }
        return servicePath;
    }
}

