package com.xxl.job.core.rpc.netcom.jetty.server;

import java.net.BindException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xxl.job.core.thread.ExecutorRegistryThread;
import com.xxl.job.core.thread.TriggerCallbackThread;

/**
 * rpc jetty server
 * @author xuxueli 2015-11-19 22:29:03
 */
public class JettyServer {
	private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);

	private Server server;
	private Thread thread;
	private List<Integer> list = null;
	public void start(final int port, final String ports, final String ip, final String appName) throws Exception {
		
		list = split(port, ports);
		
		thread = new Thread(new Runnable() {
			@Override
			public void run() {
				
				// The Server
				server = new Server(new ExecutorThreadPool(1000));

				// HTTP connector
				ServerConnector connector = new ServerConnector(server);
				if (ip!=null && ip.trim().length()>0) {
					//connector.setHost(ip);	// The network interface this connector binds to as an IP address or a hostname.  If null or 0.0.0.0, then bind to all interfaces.
				}
				try {
					//限制最多32个可选范围
					for(int step = 0 ; step < list.size() && step < 32; step++) {
						connector.setPort(list.get(step));
						server.setConnectors(new Connector[]{connector});

						// Set a handler
						HandlerCollection handlerc =new HandlerCollection();
						handlerc.setHandlers(new Handler[]{new JettyServerHandler()});
						server.setHandler(handlerc);

						try {
							// Start server
							server.start();
							logger.info(">>>>>>>>>>> xxl-job jetty server start success at port:{}.", list.get(step));
						} catch(BindException b) {
							logger.error(">>>>>>>>>>> xxl-rpc server join error, netcon={}, port={}, retry!", JettyServer.class.getName(), list.get(step));
							continue;
						} 
						// Start Registry-Server
						ExecutorRegistryThread.getInstance().start(list.get(step), ip, appName);
						// Start Callback-Server
						TriggerCallbackThread.getInstance().start();
						
						logger.info(">>>>>>>>>>> xxl-rpc server join success, netcon={}, port={}", JettyServer.class.getName(), list.get(step));
						server.join();	// block until thread stopped
						
						break;
					}
					
				} catch (Exception e) {
					logger.error(e.getMessage(), e);
				} finally {
					//destroy();
				}

			}
		});
		thread.setDaemon(true);	// daemon, service jvm, user thread leave >>> daemon leave >>> jvm leave
		thread.start();
	}
	
	/**
	 * 端口范围解释器: 可以用","指定列表,也可用"-" 指定范围 2081,2085,2094-2095,2099
	 * @param port 缺省端口
	 * @param ips  可选端口范围
	 * @return
	 */
	public static List<Integer> split(int port, String ips) {
		
		Map<String, String> ports = new HashMap<String,String>();
		List<Integer> rtn = new ArrayList<Integer>();
		rtn.add(port); ports.put(String.valueOf(port), String.valueOf(port));
		if (ips == null || "".equals(ips)) return rtn;
		String[] arry = ips.split(",");
		for(int i = 0; i < arry.length; i++) {
			String[] sa = arry[i].split("\\-");
			if (sa.length == 1) {
				String st = sa[0].trim();
				if (!"".equals(st)) {
					if (!ports.containsKey(st)) {
						rtn.add(Integer.valueOf(st));
						ports.put(st, st);
					}
					
				}
			} else {
				String ts = sa[0].trim(), te = sa[1].trim();
				if (ts.equals("") || te.equals("")) {
					ports.put(ts + te, ts + te);
					continue;
				}
				int start = Integer.parseInt(ts);
				int end   = Integer.parseInt(te);
				if (start > end) {
					int t = start; start = end; end = t;
				}
				for(int  j = start; j <= end; j++) {
					String p = String.valueOf(j);
					if (!ports.containsKey(p)) {
						rtn.add(Integer.valueOf(p));
						ports.put(p, p);
					}
				}
			}
		}
		return rtn;
	}

	public void destroy() {

		// destroy Registry-Server
		ExecutorRegistryThread.getInstance().toStop();

		// destroy Callback-Server
		TriggerCallbackThread.getInstance().toStop();

		// destroy server
		if (server != null) {
			try {
				server.stop();
				server.destroy();
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
			}
		}
		if (thread.isAlive()) {
			thread.interrupt();
		}

		logger.info(">>>>>>>>>>> xxl-rpc server destroy success, netcon={}", JettyServer.class.getName());
	}
	
	public static void main(String[] args) {
		System.out.println(split(203, "2078 , 199-203, 202,333, 456-457"));
	}
}
