package com.efuture.ocp.taskcore.rocketmq;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.efuture.ocp.taskcore.message.IMessageHandle;
import com.efuture.ocp.taskcore.service.IMessageDupHandle;
import com.efuture.ocp.taskcore.service.MessageDupService;


@Configuration
public class MqAutoConfig {
	
	@Bean(name="MessageHandle")
	@ConditionalOnProperty(prefix = "spring.rocketmq", value = { "nameServer", "producer.group" })
	public IMessageHandle MessageHandle() {
		return new RocketMqMessageHandle();
	}
	
	@Bean(name="MessageDupService")
	@ConditionalOnProperty(prefix = "spring.rocketmq", value = { "nameServer", "producer.group" })
	@ConditionalOnMissingBean(name="MessageDupService")
	public IMessageDupHandle MessageDupHandle() {
		return new MessageDupService();
	}

	
}
